/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1994/11/03 - 1995/02/19 by Erik Schnetter
 */

#include <alloca.h>
#include <X11/Xlib.h>
#include "header.h"



void X_DrawPoint (Display* display, INT drawable, GC gc, INT x, INT y)
     /* GC is struct* */
{
  XDrawPoint (display, drawable, gc, x, y);
}

void X_DrawLine (Display* display, INT drawable, GC gc,
		 INT x1, INT y1, INT x2, INT y2)
     /* GC is struct* */
{
  XDrawLine (display, drawable, gc, x1, y1, x2, y2);
}

void X_CopyArea (Display* display, INT src, INT dest, GC gc,
		 INT src_x, INT src_y, INT width, INT height,
		 INT dest_x, INT dest_y)
     /* GC is struct* */
{
  XCopyArea (display, src, dest, gc,
	     src_x, src_y, width, height, dest_x, dest_y);
}

void X_CopyPlane (Display* display, INT src, INT dest, GC gc,
		  INT src_x, INT src_y, INT width, INT height,
		  INT dest_x, INT dest_y, INT plane)
     /* GC is struct* */
{
  XCopyPlane (display, src, dest, gc,
	      src_x, src_y, width, height, dest_x, dest_y, plane);
}

void X_DrawArc (Display* display, INT drawable, GC gc,
		INT x, INT y, INT width, INT height, INT angle1, INT angle2)
     /* GC is struct* */
{
  XDrawArc (display, drawable, gc, x, y, width, height, angle1, angle2);
}

void X_DrawArcs (Display* display, INT drawable, GC gc, INT* ints, INT narcs)
     /* GC is struct* */
{
  XArc* arcs = (XArc*) alloca (narcs * sizeof(XArc));
  int i;
  for (i=narcs; i--;) {
    arcs[i].x = ints[6*i];
    arcs[i].y = ints[6*i+1];
    arcs[i].width = ints[6*i+2];
    arcs[i].height = ints[6*i+3];
    arcs[i].angle1 = ints[6*i+4];
    arcs[i].angle2 = ints[6*i+5];
  }
  XDrawArcs (display, drawable, gc, arcs, narcs);
}

void X_FillRectangle (Display* display, INT drawable, GC gc,
		      INT x, INT y, INT width, INT height)
     /* GC is struct* */
{
  XFillRectangle (display, drawable, gc, x, y, width, height);
}
