/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "StringMessageBoxDrawable.h"
#include <iostream>
#include "LabelBoxElement.h"
#include "EditLineBoxElement.h"

StringMessageBoxDrawable::StringMessageBoxDrawable(std::string mess,std::string title,int startX,int startY,int &screenWidth,int &screenHeight,StringDrawer *drawer):actualMessage_(mess),actualTitle_(title)
,startX_(startX),startY_(startY),screenWidth_(&screenWidth),screenHeight_(&screenHeight),decalage_(0),selected_(-1),drawer_(drawer)

{
	precalculated_=false;
}

StringMessageBoxDrawable::StringMessageBoxDrawable(std::vector<BoxElement *> stringList,std::string title,int startX,int startY,int &screenWidth,int &screenHeight,StringDrawer *drawer):actualTitle_(title)
	,startX_(startX),startY_(startY),screenWidth_(&screenWidth),screenHeight_(&screenHeight),decalage_(0),selected_(-1),stringList_(stringList),drawer_(drawer){
	precalculated_=true;
}


StringMessageBoxDrawable::~StringMessageBoxDrawable(void)
{

}



void StringMessageBoxDrawable::drawSimple( ){
	
	
	// remove the first line
	int decalage=0;
	unsigned int i=0;
	for (i=0;i<actualMessage_.size()+1  ;i++)
	{
		int index=(*screenWidth_+1)*(startY_-1)+startX_+i-decalage;
		if (((unsigned int)index)>=(*screenHeight_*(*screenWidth_)+*screenHeight_)) 
			continue;
		drawer_->writeXY(startX_+i-decalage,startY_-1, '-');
		//screen_[index]=(char)'-';
	}
	for (i=0;i<actualMessage_.size()+1  ;i++)
	{
		int index=(*screenWidth_+1)*(startY_+1)+startX_+i-decalage;
		if (((unsigned int)index)>=(*screenHeight_*(*screenWidth_)+*screenHeight_)) 
			continue;
			drawer_->writeXY(startX_+i-decalage,startY_+1, '-');
		//screen_[index]=(char)'-';
	}
	int index=(*screenWidth_+1)*(startY_+1)+startX_-1-decalage;
	drawer_->writeXY(startX_-1-decalage,startY_+1, '|');
	//screen_[index]=(char)'|';
	index=(*screenWidth_+1)*(startY_+1)+startX_+actualMessage_.size()-decalage;
	drawer_->writeXY(startX_+actualMessage_.size()-decalage,startY_+1, '|-');
	
	//screen_[index]=(char)'|';
	index=(*screenWidth_+1)*(startY_-1)+startX_-1-decalage;
	drawer_->writeXY(startX_-1-decalage,startY_-1, '|');
	//screen_[index]=(char)'|';
	index=(*screenWidth_+1)*(startY_-1)+startX_+actualMessage_.size()-decalage;
	drawer_->writeXY(startX_+actualMessage_.size()-decalage,startY_-1, '|');
	//screen_[index]=(char)'|';
	index=(*screenWidth_+1)*(startY_)+startX_-1-decalage;
	drawer_->writeXY(startX_-1-decalage,startY_, '|');
	//screen_[index]=(char)'|';
	index=(*screenWidth_+1)*(startY_)+startX_+actualMessage_.size()-decalage;
	drawer_->writeXY(startX_+actualMessage_.size()-decalage,startY_, '|');
	//screen_[index]=(char)'|';
	

	for (i=-1;i<actualMessage_.size()+1  ;i++)
	{

		int index=(*screenWidth_+1)*(startY_)+startX_+i-decalage;
		if (i==0||i==actualMessage_.size())
		{
			drawer_->writeXY(startX_+i-decalage,startY_, '|');
			//screen_[index]=(char)'|';
		}
		if (((unsigned int)index)>=(*screenHeight_*(*screenWidth_)+*screenHeight_)) 
			continue;
		drawer_->writeXY(startX_+i-decalage,startY_, actualMessage_.at(i));
		//screen_[index]=actualMessage_.at(i);
	}	

	

	
}

void StringMessageBoxDrawable::calculateLength(){
	
	maxCharByLine_=0;

	decalage_=0;
	
	unsigned int i=0;
	
	for (i=0;i<stringList_.size();i++)
	{
		BoxElement *el=stringList_.at(i);
		LabelBoxElement *elLab=dynamic_cast<LabelBoxElement *>(el);
		if (elLab!=NULL)
		{
			if ((elLab->getLabel()).size()>((unsigned int)maxCharByLine_))
			{
				maxCharByLine_=(elLab->getLabel()).size();
			}
			
		}
		EditLineBoxElement *elLab2=dynamic_cast<EditLineBoxElement *>(el);
		if (elLab2!=NULL)
		{
			if ((elLab2->getLabel()).size()>((unsigned int)maxCharByLine_))
			{
				maxCharByLine_=(elLab2->getLabel()).size();
			}
			if ((elLab2->getMaxChar())>(maxCharByLine_))
			{
				maxCharByLine_=elLab2->getMaxChar();
			}
		}
		
	}
	if ((int)actualTitle_.length()>maxCharByLine_)
	{
		maxCharByLine_=actualTitle_.length();
	}
	if (selected_>-1)
	{
		maxCharByLine_+=2;
	}
	decalage_+=maxCharByLine_/2+2;
}

void StringMessageBoxDrawable::calculateLines(std::string pp)
{
	stringList_.clear();
	//stringList_;
	maxCharByLine_=0;
	unsigned int i=0;
	std::string actualWord;
	for (i=0;i<pp.length();i++)
	{
		if (pp.at(i)=='\n'){
			stringList_.push_back(new LabelBoxElement(actualWord));
			if (actualWord.size()>((unsigned int)maxCharByLine_))
			{
				maxCharByLine_=actualWord.size();
			}
			actualWord="";
		}
		else
		{
			actualWord+=pp.at(i);
		}
	}
	if (!actualWord.empty())
	{
		if (actualWord.size()>((unsigned int)maxCharByLine_))
		{
			maxCharByLine_=actualWord.size();
		}
		stringList_.push_back(new LabelBoxElement(actualWord));
	}
	if (actualTitle_.size()>((unsigned int)maxCharByLine_))
	{
		maxCharByLine_=actualTitle_.size();
	}
	decalage_=0;
	//decalage_+=maxCharByLine_/2+2;
}


#include <sstream>
void StringMessageBoxDrawable::drawComplexLine(std::string line,int lineNumber,char esp){
	int i=0;
	
	int indexX=  startX_-2-decalage_;
	int indexY=  startY_+lineNumber;
	
	drawer_->writeXY(indexX,indexY, '|');
	indexX=  startX_-1-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');
	indexX=  startX_-3-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');
	
	
	
	
	if (startX_+maxCharByLine_-decalage_>*screenWidth_)
		maxCharByLine_=(*screenWidth_) +decalage_-startX_;
	
	for (i=0;i<maxCharByLine_  ;i++)
	{
		indexX=  startX_+i-decalage_;
		
		if (i<line.size())
		{
			drawer_->writeXY(indexX,indexY, line.at(i));
			
		}
		else{
			drawer_->writeXY(indexX,indexY, esp);
			
		}
	}
	indexX=  maxCharByLine_+startX_+1-decalage_;
	drawer_->writeXY(indexX,indexY, '|');
	indexX=  maxCharByLine_+startX_-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');
	indexX=  maxCharByLine_+startX_+2-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');

	indexX=  startX_-2-decalage_;
	indexY=  startY_+lineNumber;
	
	drawer_->writeXY(indexX,indexY, '|');
	indexX=  startX_-1-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');
	indexX=  startX_-3-decalage_;
	drawer_->writeXY(indexX,indexY, ' ');
	std::stringstream pp;
	
}


void StringMessageBoxDrawable::drawEmptyLine(int lineNumber){
	int i=0;
	
	unsigned int index=0;

	for (i=-3;i<maxCharByLine_+3  ;i++)
	{
		index=(*screenWidth_+1)*(startY_+lineNumber)+startX_+i-decalage_;
		if (index>=0&&index<(*screenHeight_*(*screenWidth_)+*screenHeight_))
		drawer_->writeXY(startX_+i-decalage_,startY_+lineNumber, ' ');
		//screen_[index]=' ';
	}
}

void StringMessageBoxDrawable::drawLine(int lineNumber){
	int i=0;
	
	unsigned int index=0;

	for (i=-3;i<maxCharByLine_+3  ;i++)
	{
		index=(*screenWidth_+1)*(startY_+lineNumber)+startX_+i-decalage_;
		if (index>=0&&index<(*screenHeight_*(*screenWidth_)+*screenHeight_))
		if (i>=-2&&i<=maxCharByLine_+1)
		{
			drawer_->writeXY(startX_+i-decalage_,startY_+lineNumber, '-');
			//screen_[index]='-';
		}
		else
		{
			drawer_->writeXY(startX_+i-decalage_,startY_+lineNumber, ' ');
			//screen_[index]=' ';
		}
	}
}

void StringMessageBoxDrawable::drawComplex( ){

	if (selected_<0)
	{
		selected_=stringList_.size()-1;
	}
	if (selected_>(int)stringList_.size())
	{
		selected_=0;
	}
	if (!precalculated_)
	calculateLines(actualMessage_);
	else
		calculateLength();
	
	drawEmptyLine(-4);
	drawLine(-3);
	drawComplexLine(actualTitle_,-2);
	drawLine(-1);
	unsigned int i=0;
	int bb=0;
	unsigned int max=stringList_.size();
	if (((int)stringList_.size())>(*screenHeight_-14))
	{
		max=*screenHeight_-14+1;
		bb=selected_-max+1;
	}
	if (bb<0) bb=0;
	
	for (i=0;i<max;i++)
	{
		if (i+bb<stringList_.size())
		{
			BoxElement *el=stringList_.at(i+bb);
			LabelBoxElement *llab=dynamic_cast<LabelBoxElement *>(el);
			
			if (llab!=NULL)
			{
				
				if (i+bb==selected_)
				{				
					drawComplexLine("> "+llab->getLabel(),i);
				}
				else if (selected_ > -1 )
				{
					drawComplexLine("  "+llab->getLabel(),i);
				}
				else
					drawComplexLine(llab->getLabel(),i);
			}	

			EditLineBoxElement *llab2=dynamic_cast<EditLineBoxElement *>(el);
			if (llab2!=NULL)
			{
				
				if (i+bb==selected_)
				{				
					drawComplexLine("> "+llab2->getLabel()+":"+llab2->getValue(),i,'_');
				}
				else if (selected_ > -1 )
				{
					drawComplexLine("  "+llab2->getLabel()+":"+llab2->getValue(),i);
				}
				else
					drawComplexLine(llab->getLabel(),i);
			}
		}
		else
		{
			drawComplexLine(" ",i);
		}
	}
	drawLine(max);
	drawEmptyLine(max+1);
	

}



void StringMessageBoxDrawable::draw( ){
	
	drawComplex( );
	
	
}



void StringMessageBoxDrawable::setSelected(int p){
	if ((unsigned int)p>stringList_.size()-1)
	{
		selected_=0;
	}else if (p<0)
	{
		selected_=stringList_.size()-1;
	}
	else
		selected_=p;

}

void StringMessageBoxDrawable::setTitle(std::string tit){
	actualTitle_=tit;
}
void StringMessageBoxDrawable::setMessage(std::string mess){
	actualMessage_=mess;
}
