/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "Player.h"


Player::Player(std::string name,PLAYERTYPE pp):type_(pp)
{
	name_=name;
	hasLost_=false;
}


Player::~Player(void)
{
}

std::string Player::getName(){
	return name_;
}

std::istream& operator>> (std::istream& in, Player& per){
	int version=0;
	in >> version;
	if (version==1)
	{
		in >> per.name_;
	
	}
	return in;
}

std::ostream& operator<< (std::ostream& in, Player& per){
	int version=0;
	in << 1;
	in << per.name_;
	return in;
}

Serializer& operator>> (Serializer& in, Player& per){
	int version=0;
	in >> version;
	if (version==1)
	{
		in >> per.name_;
		int typp=0;
		in >> typp;
		per.type_=(Player::PLAYERTYPE)typp;
		in >> per.hasLost_;

	
	}

	return in;
}

Serializer& operator<< (Serializer& in, Player& per){
	int version=0;
	in << 1;
	in << per.name_;
	in << (int)per.type_;
	in << per.hasLost_;
	return in;
}

Player::PLAYERTYPE Player::getType(){
	return type_;
}


void Player::setName(std::string ee){
	name_=ee;
}

void Player::setType(PLAYERTYPE a){
	type_=a;
}

bool Player::hasLost(){
	return hasLost_;
	}
void Player::setLost(bool a){
	hasLost_=a;
	}
	