/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef OCCUPY_H

#define OCCUPY_H 1

#define ATT_PER_TURN 6
#define EVENT_ATT 1
#define EVENT_DEF 2
#define EVENT_GUE 4
#define EVENT_ENCIRCLEMENT 8
#define EVENT_NEWTURN 16
#define EVENT_UNOCCUPY 32
#define EVENT_DEFEAT 64
#define EVENT_REFRESH 128

typedef struct
{
  int count;
  char type;
  Coord *loc;
} Action;

extern void init_occupy (void);
extern void defeat_players (const int, Action *);
extern void action (int, Action *);

#endif /* occupy.h */
