/* -*-C-*-

$Id: ntapi.h,v 1.21 2007/04/24 05:31:25 cph Exp $

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

*/

/* This flag, defined by "syscall.h", means to define the syscall
   enums normally defined by that file.  */
#ifdef DEFINE_WIN32_SYSCALLS

enum syscall_names
{
  /* Native Win32 API procedures: */
  apicall_CloseHandle,
  apicall_CopyFile,
  apicall_CreateDirectory,
  apicall_CreateFile,
  apicall_CreatePipe,
  apicall_CreateProcess,
  apicall_DeleteFile,
  apicall_DuplicateHandle,
  apicall_EnumWindows,
  apicall_ExpandEnvironmentStrings,
  apicall_FindFirstFile,
  apicall_GetExitCodeProcess,
  apicall_GetFileAttributes,
  apicall_GetFileInformationByHandle,
  apicall_GetFileSize,
  apicall_GetFileTime,
  apicall_GetKeyboardState,
  apicall_GetStdHandle,
  apicall_InitializeSecurityDescriptor,
  apicall_MoveFile,
  apicall_MsgWaitForMultipleObjects,
  apicall_PeekNamedPipe,
  apicall_ReadFile,
  apicall_RegCloseKey,
  apicall_RegCreateKeyEx,
  apicall_RegDeleteKey,
  apicall_RegDeleteValue,
  apicall_RegEnumKeyEx,
  apicall_RegEnumValue,
  apicall_RegOpenKeyEx,
  apicall_RegQueryInfoKey,
  apicall_RegQueryValueEx,
  apicall_RegSetValueEx,
  apicall_RemoveDirectory,
  apicall_SetCurrentDirectory,
  apicall_SetEndOfFile,
  apicall_SetFileAttributes,
  apicall_SetFilePointer,
  apicall_SetFileTime,
  apicall_SetKeyboardState,
  apicall_SetSecurityDescriptorDacl,
  apicall_SetStdHandle,
  apicall_SetTimer,
  apicall_TerminateProcess,
  apicall_WaitForMultipleObjects,
  apicall_WaitForSingleObject,
  apicall_WriteFile,

  /* Winsock procedures: */
  apicall_accept,
  apicall_bind,
  apicall_closesocket,
  apicall_connect,
  apicall_gethostbyname,
  apicall_gethostname,
  apicall_getsockopt,
  apicall_ioctlsocket,
  apicall_listen,
  apicall_recv,
  apicall_select,
  apicall_send,
  apicall_setsockopt,
  apicall_shutdown,
  apicall_socket,

  /* C Library's unix-style procedures: */
  syscall_close,
  syscall_fstat,
  syscall_getcwd,
  syscall_gmtime,
  syscall_localtime,
  syscall_lseek,
  syscall_malloc,
  syscall_mkdir,
  syscall_mktime,
  syscall_open,
  syscall_read,
  syscall_realloc,
  syscall_rmdir,
  syscall_stat,
  syscall_unlink,
  syscall_write
};

/* Machine-generated table, do not edit: */
enum syserr_names
{
  /* Win32 error codes: */
  syserr_success,
  syserr_invalid_function,
  syserr_file_not_found,
  syserr_path_not_found,
  syserr_too_many_open_files,
  syserr_access_denied,
  syserr_invalid_handle,
  syserr_arena_trashed,
  syserr_not_enough_memory,
  syserr_invalid_block,
  syserr_bad_environment,
  syserr_bad_format,
  syserr_invalid_access,
  syserr_invalid_data,
  syserr_outofmemory,
  syserr_invalid_drive,
  syserr_current_directory,
  syserr_not_same_device,
  syserr_no_more_files,
  syserr_write_protect,
  syserr_bad_unit,
  syserr_not_ready,
  syserr_bad_command,
  syserr_crc,
  syserr_bad_length,
  syserr_seek,
  syserr_not_dos_disk,
  syserr_sector_not_found,
  syserr_out_of_paper,
  syserr_write_fault,
  syserr_read_fault,
  syserr_gen_failure,
  syserr_sharing_violation,
  syserr_lock_violation,
  syserr_wrong_disk,
  syserr_sharing_buffer_exceeded,
  syserr_handle_eof,
  syserr_handle_disk_full,
  syserr_not_supported,
  syserr_rem_not_list,
  syserr_dup_name,
  syserr_bad_netpath,
  syserr_network_busy,
  syserr_dev_not_exist,
  syserr_too_many_cmds,
  syserr_adap_hdw_err,
  syserr_bad_net_resp,
  syserr_unexp_net_err,
  syserr_bad_rem_adap,
  syserr_printq_full,
  syserr_no_spool_space,
  syserr_print_cancelled,
  syserr_netname_deleted,
  syserr_network_access_denied,
  syserr_bad_dev_type,
  syserr_bad_net_name,
  syserr_too_many_names,
  syserr_too_many_sess,
  syserr_sharing_paused,
  syserr_req_not_accep,
  syserr_redir_paused,
  syserr_file_exists,
  syserr_cannot_make,
  syserr_fail_i24,
  syserr_out_of_structures,
  syserr_already_assigned,
  syserr_invalid_password,
  syserr_invalid_parameter,
  syserr_net_write_fault,
  syserr_no_proc_slots,
  syserr_too_many_semaphores,
  syserr_excl_sem_already_owned,
  syserr_sem_is_set,
  syserr_too_many_sem_requests,
  syserr_invalid_at_interrupt_time,
  syserr_sem_owner_died,
  syserr_sem_user_limit,
  syserr_disk_change,
  syserr_drive_locked,
  syserr_broken_pipe,
  syserr_open_failed,
  syserr_buffer_overflow,
  syserr_disk_full,
  syserr_no_more_search_handles,
  syserr_invalid_target_handle,
  syserr_invalid_category,
  syserr_invalid_verify_switch,
  syserr_bad_driver_level,
  syserr_call_not_implemented,
  syserr_sem_timeout,
  syserr_insufficient_buffer,
  syserr_invalid_name,
  syserr_invalid_level,
  syserr_no_volume_label,
  syserr_mod_not_found,
  syserr_proc_not_found,
  syserr_wait_no_children,
  syserr_child_not_complete,
  syserr_direct_access_handle,
  syserr_negative_seek,
  syserr_seek_on_device,
  syserr_is_join_target,
  syserr_is_joined,
  syserr_is_substed,
  syserr_not_joined,
  syserr_not_substed,
  syserr_join_to_join,
  syserr_subst_to_subst,
  syserr_join_to_subst,
  syserr_subst_to_join,
  syserr_busy_drive,
  syserr_same_drive,
  syserr_dir_not_root,
  syserr_dir_not_empty,
  syserr_is_subst_path,
  syserr_is_join_path,
  syserr_path_busy,
  syserr_is_subst_target,
  syserr_system_trace,
  syserr_invalid_event_count,
  syserr_too_many_muxwaiters,
  syserr_invalid_list_format,
  syserr_label_too_long,
  syserr_too_many_tcbs,
  syserr_signal_refused,
  syserr_discarded,
  syserr_not_locked,
  syserr_bad_threadid_addr,
  syserr_bad_arguments,
  syserr_bad_pathname,
  syserr_signal_pending,
  syserr_max_thrds_reached,
  syserr_lock_failed,
  syserr_busy,
  syserr_cancel_violation,
  syserr_atomic_locks_not_supported,
  syserr_invalid_segment_number,
  syserr_invalid_ordinal,
  syserr_already_exists,
  syserr_invalid_flag_number,
  syserr_sem_not_found,
  syserr_invalid_starting_codeseg,
  syserr_invalid_stackseg,
  syserr_invalid_moduletype,
  syserr_invalid_exe_signature,
  syserr_exe_marked_invalid,
  syserr_bad_exe_format,
  syserr_iterated_data_exceeds_64k,
  syserr_invalid_minallocsize,
  syserr_dynlink_from_invalid_ring,
  syserr_iopl_not_enabled,
  syserr_invalid_segdpl,
  syserr_autodataseg_exceeds_64k,
  syserr_ring2seg_must_be_movable,
  syserr_reloc_chain_xeeds_seglim,
  syserr_infloop_in_reloc_chain,
  syserr_envvar_not_found,
  syserr_no_signal_sent,
  syserr_filename_exced_range,
  syserr_ring2_stack_in_use,
  syserr_meta_expansion_too_long,
  syserr_invalid_signal_number,
  syserr_thread_1_inactive,
  syserr_locked,
  syserr_too_many_modules,
  syserr_nesting_not_allowed,
  syserr_bad_pipe,
  syserr_pipe_busy,
  syserr_no_data,
  syserr_pipe_not_connected,
  syserr_more_data,
  syserr_vc_disconnected,
  syserr_invalid_ea_name,
  syserr_ea_list_inconsistent,
  syserr_no_more_items,
  syserr_cannot_copy,
  syserr_directory,
  syserr_eas_didnt_fit,
  syserr_ea_file_corrupt,
  syserr_ea_table_full,
  syserr_invalid_ea_handle,
  syserr_eas_not_supported,
  syserr_not_owner,
  syserr_too_many_posts,
  syserr_partial_copy,
  syserr_mr_mid_not_found,
  syserr_invalid_address,
  syserr_arithmetic_overflow,
  syserr_pipe_connected,
  syserr_pipe_listening,
  syserr_ea_access_denied,
  syserr_operation_aborted,
  syserr_io_incomplete,
  syserr_io_pending,
  syserr_noaccess,
  syserr_swaperror,
  syserr_stack_overflow,
  syserr_invalid_message,
  syserr_can_not_complete,
  syserr_invalid_flags,
  syserr_unrecognized_volume,
  syserr_file_invalid,
  syserr_fullscreen_mode,
  syserr_no_token,
  syserr_baddb,
  syserr_badkey,
  syserr_cantopen,
  syserr_cantread,
  syserr_cantwrite,
  syserr_registry_recovered,
  syserr_registry_corrupt,
  syserr_registry_io_failed,
  syserr_not_registry_file,
  syserr_key_deleted,
  syserr_no_log_space,
  syserr_key_has_children,
  syserr_child_must_be_volatile,
  syserr_notify_enum_dir,
  syserr_dependent_services_running,
  syserr_invalid_service_control,
  syserr_service_request_timeout,
  syserr_service_no_thread,
  syserr_service_database_locked,
  syserr_service_already_running,
  syserr_invalid_service_account,
  syserr_service_disabled,
  syserr_circular_dependency,
  syserr_service_does_not_exist,
  syserr_service_cannot_accept_ctrl,
  syserr_service_not_active,
  syserr_failed_service_controller_connect,
  syserr_exception_in_service,
  syserr_database_does_not_exist,
  syserr_service_specific_error,
  syserr_process_aborted,
  syserr_service_dependency_fail,
  syserr_service_logon_failed,
  syserr_service_start_hang,
  syserr_invalid_service_lock,
  syserr_service_marked_for_delete,
  syserr_service_exists,
  syserr_already_running_lkg,
  syserr_service_dependency_deleted,
  syserr_boot_already_accepted,
  syserr_service_never_started,
  syserr_duplicate_service_name,
  syserr_end_of_media,
  syserr_filemark_detected,
  syserr_beginning_of_media,
  syserr_setmark_detected,
  syserr_no_data_detected,
  syserr_partition_failure,
  syserr_invalid_block_length,
  syserr_device_not_partitioned,
  syserr_unable_to_lock_media,
  syserr_unable_to_unload_media,
  syserr_media_changed,
  syserr_bus_reset,
  syserr_no_media_in_drive,
  syserr_no_unicode_translation,
  syserr_dll_init_failed,
  syserr_shutdown_in_progress,
  syserr_no_shutdown_in_progress,
  syserr_io_device,
  syserr_serial_no_device,
  syserr_irq_busy,
  syserr_more_writes,
  syserr_counter_timeout,
  syserr_floppy_id_mark_not_found,
  syserr_floppy_wrong_cylinder,
  syserr_floppy_unknown_error,
  syserr_floppy_bad_registers,
  syserr_disk_recalibrate_failed,
  syserr_disk_operation_failed,
  syserr_disk_reset_failed,
  syserr_eom_overflow,
  syserr_not_enough_server_memory,
  syserr_possible_deadlock,
  syserr_mapped_alignment,
  syserr_set_power_state_vetoed,
  syserr_set_power_state_failed,
  syserr_old_win_version,
  syserr_app_wrong_os,
  syserr_single_instance_app,
  syserr_rmode_app,
  syserr_invalid_dll,
  syserr_no_association,
  syserr_dde_fail,
  syserr_dll_not_found,
  syserr_bad_username,
  syserr_not_connected,
  syserr_open_files,
  syserr_active_connections,
  syserr_device_in_use,
  syserr_bad_device,
  syserr_connection_unavail,
  syserr_device_already_remembered,
  syserr_no_net_or_bad_path,
  syserr_bad_provider,
  syserr_cannot_open_profile,
  syserr_bad_profile,
  syserr_not_container,
  syserr_extended_error,
  syserr_invalid_groupname,
  syserr_invalid_computername,
  syserr_invalid_eventname,
  syserr_invalid_domainname,
  syserr_invalid_servicename,
  syserr_invalid_netname,
  syserr_invalid_sharename,
  syserr_invalid_passwordname,
  syserr_invalid_messagename,
  syserr_invalid_messagedest,
  syserr_session_credential_conflict,
  syserr_remote_session_limit_exceeded,
  syserr_dup_domainname,
  syserr_no_network,
  syserr_cancelled,
  syserr_user_mapped_file,
  syserr_connection_refused,
  syserr_graceful_disconnect,
  syserr_address_already_associated,
  syserr_address_not_associated,
  syserr_connection_invalid,
  syserr_connection_active,
  syserr_network_unreachable,
  syserr_host_unreachable,
  syserr_protocol_unreachable,
  syserr_port_unreachable,
  syserr_request_aborted,
  syserr_connection_aborted,
  syserr_retry,
  syserr_connection_count_limit,
  syserr_login_time_restriction,
  syserr_login_wksta_restriction,
  syserr_incorrect_address,
  syserr_already_registered,
  syserr_service_not_found,
  syserr_not_authenticated,
  syserr_not_logged_on,
  syserr_continue,
  syserr_already_initialized,
  syserr_no_more_devices,
  syserr_not_all_assigned,
  syserr_some_not_mapped,
  syserr_no_quotas_for_account,
  syserr_local_user_session_key,
  syserr_null_lm_password,
  syserr_unknown_revision,
  syserr_revision_mismatch,
  syserr_invalid_owner,
  syserr_invalid_primary_group,
  syserr_no_impersonation_token,
  syserr_cant_disable_mandatory,
  syserr_no_logon_servers,
  syserr_no_such_logon_session,
  syserr_no_such_privilege,
  syserr_privilege_not_held,
  syserr_invalid_account_name,
  syserr_user_exists,
  syserr_no_such_user,
  syserr_group_exists,
  syserr_no_such_group,
  syserr_member_in_group,
  syserr_member_not_in_group,
  syserr_last_admin,
  syserr_wrong_password,
  syserr_ill_formed_password,
  syserr_password_restriction,
  syserr_logon_failure,
  syserr_account_restriction,
  syserr_invalid_logon_hours,
  syserr_invalid_workstation,
  syserr_password_expired,
  syserr_account_disabled,
  syserr_none_mapped,
  syserr_too_many_luids_requested,
  syserr_luids_exhausted,
  syserr_invalid_sub_authority,
  syserr_invalid_acl,
  syserr_invalid_sid,
  syserr_invalid_security_descr,
  syserr_bad_inheritance_acl,
  syserr_server_disabled,
  syserr_server_not_disabled,
  syserr_invalid_id_authority,
  syserr_allotted_space_exceeded,
  syserr_invalid_group_attributes,
  syserr_bad_impersonation_level,
  syserr_cant_open_anonymous,
  syserr_bad_validation_class,
  syserr_bad_token_type,
  syserr_no_security_on_object,
  syserr_cant_access_domain_info,
  syserr_invalid_server_state,
  syserr_invalid_domain_state,
  syserr_invalid_domain_role,
  syserr_no_such_domain,
  syserr_domain_exists,
  syserr_domain_limit_exceeded,
  syserr_internal_db_corruption,
  syserr_internal_error,
  syserr_generic_not_mapped,
  syserr_bad_descriptor_format,
  syserr_not_logon_process,
  syserr_logon_session_exists,
  syserr_no_such_package,
  syserr_bad_logon_session_state,
  syserr_logon_session_collision,
  syserr_invalid_logon_type,
  syserr_cannot_impersonate,
  syserr_rxact_invalid_state,
  syserr_rxact_commit_failure,
  syserr_special_account,
  syserr_special_group,
  syserr_special_user,
  syserr_members_primary_group,
  syserr_token_already_in_use,
  syserr_no_such_alias,
  syserr_member_not_in_alias,
  syserr_member_in_alias,
  syserr_alias_exists,
  syserr_logon_not_granted,
  syserr_too_many_secrets,
  syserr_secret_too_long,
  syserr_internal_db_error,
  syserr_too_many_context_ids,
  syserr_logon_type_not_granted,
  syserr_nt_cross_encryption_required,
  syserr_no_such_member,
  syserr_invalid_member,
  syserr_too_many_sids,
  syserr_lm_cross_encryption_required,
  syserr_no_inheritance,
  syserr_file_corrupt,
  syserr_disk_corrupt,
  syserr_no_user_session_key,
  syserr_license_quota_exceeded,
  syserr_invalid_window_handle,
  syserr_invalid_menu_handle,
  syserr_invalid_cursor_handle,
  syserr_invalid_accel_handle,
  syserr_invalid_hook_handle,
  syserr_invalid_dwp_handle,
  syserr_tlw_with_wschild,
  syserr_cannot_find_wnd_class,
  syserr_window_of_other_thread,
  syserr_hotkey_already_registered,
  syserr_class_already_exists,
  syserr_class_does_not_exist,
  syserr_class_has_windows,
  syserr_invalid_index,
  syserr_invalid_icon_handle,
  syserr_private_dialog_index,
  syserr_listbox_id_not_found,
  syserr_no_wildcard_characters,
  syserr_clipboard_not_open,
  syserr_hotkey_not_registered,
  syserr_window_not_dialog,
  syserr_control_id_not_found,
  syserr_invalid_combobox_message,
  syserr_window_not_combobox,
  syserr_invalid_edit_height,
  syserr_dc_not_found,
  syserr_invalid_hook_filter,
  syserr_invalid_filter_proc,
  syserr_hook_needs_hmod,
  syserr_global_only_hook,
  syserr_journal_hook_set,
  syserr_hook_not_installed,
  syserr_invalid_lb_message,
  syserr_setcount_on_bad_lb,
  syserr_lb_without_tabstops,
  syserr_destroy_object_of_other_thread,
  syserr_child_window_menu,
  syserr_no_system_menu,
  syserr_invalid_msgbox_style,
  syserr_invalid_spi_value,
  syserr_screen_already_locked,
  syserr_hwnds_have_diff_parent,
  syserr_not_child_window,
  syserr_invalid_gw_command,
  syserr_invalid_thread_id,
  syserr_non_mdichild_window,
  syserr_popup_already_active,
  syserr_no_scrollbars,
  syserr_invalid_scrollbar_range,
  syserr_invalid_showwin_command,
  syserr_no_system_resources,
  syserr_nonpaged_system_resources,
  syserr_paged_system_resources,
  syserr_working_set_quota,
  syserr_pagefile_quota,
  syserr_commitment_limit,
  syserr_menu_item_not_found,
  syserr_eventlog_file_corrupt,
  syserr_eventlog_cant_start,
  syserr_log_file_full,
  syserr_eventlog_file_changed,
  syserr_rpc_s_invalid_string_binding,
  syserr_rpc_s_wrong_kind_of_binding,
  syserr_rpc_s_invalid_binding,
  syserr_rpc_s_protseq_not_supported,
  syserr_rpc_s_invalid_rpc_protseq,
  syserr_rpc_s_invalid_string_uuid,
  syserr_rpc_s_invalid_endpoint_format,
  syserr_rpc_s_invalid_net_addr,
  syserr_rpc_s_no_endpoint_found,
  syserr_rpc_s_invalid_timeout,
  syserr_rpc_s_object_not_found,
  syserr_rpc_s_already_registered,
  syserr_rpc_s_type_already_registered,
  syserr_rpc_s_already_listening,
  syserr_rpc_s_no_protseqs_registered,
  syserr_rpc_s_not_listening,
  syserr_rpc_s_unknown_mgr_type,
  syserr_rpc_s_unknown_if,
  syserr_rpc_s_no_bindings,
  syserr_rpc_s_no_protseqs,
  syserr_rpc_s_cant_create_endpoint,
  syserr_rpc_s_out_of_resources,
  syserr_rpc_s_server_unavailable,
  syserr_rpc_s_server_too_busy,
  syserr_rpc_s_invalid_network_options,
  syserr_rpc_s_no_call_active,
  syserr_rpc_s_call_failed,
  syserr_rpc_s_call_failed_dne,
  syserr_rpc_s_protocol_error,
  syserr_rpc_s_unsupported_trans_syn,
  syserr_rpc_s_unsupported_type,
  syserr_rpc_s_invalid_tag,
  syserr_rpc_s_invalid_bound,
  syserr_rpc_s_no_entry_name,
  syserr_rpc_s_invalid_name_syntax,
  syserr_rpc_s_unsupported_name_syntax,
  syserr_rpc_s_uuid_no_address,
  syserr_rpc_s_duplicate_endpoint,
  syserr_rpc_s_unknown_authn_type,
  syserr_rpc_s_max_calls_too_small,
  syserr_rpc_s_string_too_long,
  syserr_rpc_s_protseq_not_found,
  syserr_rpc_s_procnum_out_of_range,
  syserr_rpc_s_binding_has_no_auth,
  syserr_rpc_s_unknown_authn_service,
  syserr_rpc_s_unknown_authn_level,
  syserr_rpc_s_invalid_auth_identity,
  syserr_rpc_s_unknown_authz_service,
  syserr_ept_s_invalid_entry,
  syserr_ept_s_cant_perform_op,
  syserr_ept_s_not_registered,
  syserr_rpc_s_nothing_to_export,
  syserr_rpc_s_incomplete_name,
  syserr_rpc_s_invalid_vers_option,
  syserr_rpc_s_no_more_members,
  syserr_rpc_s_not_all_objs_unexported,
  syserr_rpc_s_interface_not_found,
  syserr_rpc_s_entry_already_exists,
  syserr_rpc_s_entry_not_found,
  syserr_rpc_s_name_service_unavailable,
  syserr_rpc_s_invalid_naf_id,
  syserr_rpc_s_cannot_support,
  syserr_rpc_s_no_context_available,
  syserr_rpc_s_internal_error,
  syserr_rpc_s_zero_divide,
  syserr_rpc_s_address_error,
  syserr_rpc_s_fp_div_zero,
  syserr_rpc_s_fp_underflow,
  syserr_rpc_s_fp_overflow,
  syserr_rpc_x_no_more_entries,
  syserr_rpc_x_ss_char_trans_open_fail,
  syserr_rpc_x_ss_char_trans_short_file,
  syserr_rpc_x_ss_in_null_context,
  syserr_rpc_x_ss_context_damaged,
  syserr_rpc_x_ss_handles_mismatch,
  syserr_rpc_x_ss_cannot_get_call_handle,
  syserr_rpc_x_null_ref_pointer,
  syserr_rpc_x_enum_value_out_of_range,
  syserr_rpc_x_byte_count_too_small,
  syserr_rpc_x_bad_stub_data,
  syserr_invalid_user_buffer,
  syserr_unrecognized_media,
  syserr_no_trust_lsa_secret,
  syserr_no_trust_sam_account,
  syserr_trusted_domain_failure,
  syserr_trusted_relationship_failure,
  syserr_trust_failure,
  syserr_rpc_s_call_in_progress,
  syserr_netlogon_not_started,
  syserr_account_expired,
  syserr_redirector_has_open_handles,
  syserr_printer_driver_already_installed,
  syserr_unknown_port,
  syserr_unknown_printer_driver,
  syserr_unknown_printprocessor,
  syserr_invalid_separator_file,
  syserr_invalid_priority,
  syserr_invalid_printer_name,
  syserr_printer_already_exists,
  syserr_invalid_printer_command,
  syserr_invalid_datatype,
  syserr_invalid_environment,
  syserr_rpc_s_no_more_bindings,
  syserr_nologon_interdomain_trust_account,
  syserr_nologon_workstation_trust_account,
  syserr_nologon_server_trust_account,
  syserr_domain_trust_inconsistent,
  syserr_server_has_open_handles,
  syserr_resource_data_not_found,
  syserr_resource_type_not_found,
  syserr_resource_name_not_found,
  syserr_resource_lang_not_found,
  syserr_not_enough_quota,
  syserr_rpc_s_no_interfaces,
  syserr_rpc_s_call_cancelled,
  syserr_rpc_s_binding_incomplete,
  syserr_rpc_s_comm_failure,
  syserr_rpc_s_unsupported_authn_level,
  syserr_rpc_s_no_princ_name,
  syserr_rpc_s_not_rpc_error,
  syserr_rpc_s_uuid_local_only,
  syserr_rpc_s_sec_pkg_error,
  syserr_rpc_s_not_cancelled,
  syserr_rpc_x_invalid_es_action,
  syserr_rpc_x_wrong_es_version,
  syserr_rpc_x_wrong_stub_version,
  syserr_rpc_s_group_member_not_found,
  syserr_ept_s_cant_create,
  syserr_rpc_s_invalid_object,
  syserr_invalid_time,
  syserr_invalid_form_name,
  syserr_invalid_form_size,
  syserr_already_waiting,
  syserr_printer_deleted,
  syserr_invalid_printer_state,
  syserr_password_must_change,
  syserr_domain_controller_not_found,
  syserr_account_locked_out,
  syserr_no_browser_servers_found,
  syserr_invalid_pixel_format,
  syserr_bad_driver,
  syserr_invalid_window_style,
  syserr_metafile_not_supported,
  syserr_transform_not_supported,
  syserr_clipping_not_supported,
  syserr_unknown_print_monitor,
  syserr_printer_driver_in_use,
  syserr_spool_file_not_found,
  syserr_spl_no_startdoc,
  syserr_spl_no_addjob,
  syserr_print_processor_already_installed,
  syserr_print_monitor_already_installed,
  syserr_wins_internal,
  syserr_can_not_del_local_wins,
  syserr_static_init,
  syserr_inc_backup,
  syserr_full_backup,
  syserr_rec_non_existent,
  syserr_rpl_not_allowed,

  /* Winsock error codes: */
  syserr_wsaeintr,
  syserr_wsaebadf,
  syserr_wsaeacces,
  syserr_wsaefault,
  syserr_wsaeinval,
  syserr_wsaemfile,
  syserr_wsaewouldblock,
  syserr_wsaeinprogress,
  syserr_wsaealready,
  syserr_wsaenotsock,
  syserr_wsaedestaddrreq,
  syserr_wsaemsgsize,
  syserr_wsaeprototype,
  syserr_wsaenoprotoopt,
  syserr_wsaeprotonosupport,
  syserr_wsaesocktnosupport,
  syserr_wsaeopnotsupp,
  syserr_wsaepfnosupport,
  syserr_wsaeafnosupport,
  syserr_wsaeaddrinuse,
  syserr_wsaeaddrnotavail,
  syserr_wsaenetdown,
  syserr_wsaenetunreach,
  syserr_wsaenetreset,
  syserr_wsaeconnaborted,
  syserr_wsaeconnreset,
  syserr_wsaenobufs,
  syserr_wsaeisconn,
  syserr_wsaenotconn,
  syserr_wsaeshutdown,
  syserr_wsaetoomanyrefs,
  syserr_wsaetimedout,
  syserr_wsaeconnrefused,
  syserr_wsaeloop,
  syserr_wsaenametoolong,
  syserr_wsaehostdown,
  syserr_wsaehostunreach,
  syserr_wsaenotempty,
  syserr_wsaeproclim,
  syserr_wsaeusers,
  syserr_wsaedquot,
  syserr_wsaestale,
  syserr_wsaeremote,
  syserr_wsaediscon,
  syserr_wsasysnotready,
  syserr_wsavernotsupported,
  syserr_wsanotinitialised,
  syserr_wsahost_not_found,
  syserr_wsatry_again,
  syserr_wsano_recovery,
  syserr_wsano_data,

  /* Unix error codes: */
#define FIRST_UNIX_ERROR_CODE syserr_arg_list_too_long
  syserr_arg_list_too_long,
  syserr_bad_file_descriptor,
  syserr_domain_error,
  syserr_exec_format_error,
  syserr_unix_file_exists,
  syserr_interrupted_function_call,
  syserr_invalid_argument,
  syserr_no_such_file_or_directory,
  syserr_not_a_directory,
  syserr_not_enough_space,
  syserr_permission_denied,
  syserr_resource_deadlock_avoided,
  syserr_resource_temporarily_unavailable,
  syserr_result_too_large,
  syserr_unix_too_many_open_files,

  syserr_unknown
};

#else /* not DEFINE_WIN32_SYSCALLS */

extern void NT_prim_check_errno (enum syscall_names);
extern void NT_error_api_call (DWORD, enum syscall_names);
extern void NT_error_unix_call (int, enum syscall_names);

#define STD_VOID_UNIX_CALL(proc, args)					\
{									\
  while ((proc args) < 0)						\
    if (errno != EINTR)							\
      NT_error_unix_call (errno, syscall_ ## proc);			\
}

#define STD_UINT_UNIX_CALL(result, proc, args)				\
{									\
  if (((result) = (proc args)) == 0)					\
    NT_error_unix_call (errno, syscall_ ## proc);			\
}

#define STD_PTR_UNIX_CALL(result, proc, args)				\
{									\
  if (((result) = (proc args)) == 0)					\
    NT_error_unix_call (errno, syscall_ ## proc);			\
}

#define STD_BOOL_API_CALL(proc, args)					\
{									\
  if (! (proc args))							\
    NT_error_api_call ((GetLastError ()), apicall_ ## proc);		\
}

#define STD_HANDLE_API_CALL(result, proc, args)				\
{									\
  if (((result) = (proc args)) == INVALID_HANDLE_VALUE)			\
    NT_error_api_call ((GetLastError ()), apicall_ ## proc);		\
}

#ifdef SCM_NTTOP_C

static const char * syscall_names_table [] =
{
  /* Native Win32 API procedures: */
  "close-handle",
  "copy-file",
  "create-directory",
  "create-file",
  "create-pipe",
  "create-process",
  "delete-file",
  "duplicate-handle",
  "enum-windows",
  "expand-environment-strings",
  "find-first-file",
  "get-exit-code-process",
  "get-file-attributes",
  "get-file-information-by-handle",
  "get-file-size",
  "get-file-time",
  "get-keyboard-state",
  "get-std-handle",
  "initialize-security-descriptor",
  "move-file",
  "msg-wait-for-multiple-objects",
  "peek-named-pipe",
  "read-file",
  "reg-close-key",
  "reg-create-key-ex",
  "reg-delete-key",
  "reg-delete-value",
  "reg-enum-key-ex",
  "reg-enum-value",
  "reg-open-key-ex",
  "reg-query-info-key",
  "reg-query-value-ex",
  "reg-set-value-ex",
  "remove-directory",
  "set-current-directory",
  "set-end-of-file",
  "set-file-attributes",
  "set-file-pointer",
  "set-file-time",
  "set-keyboard-state",
  "set-security-descriptor-dacl",
  "set-std-handle",
  "set-timer",
  "terminate-process",
  "wait-for-multiple-objects",
  "wait-for-single-object",
  "write-file",

  /* Winsock procedures: */
  "accept",
  "bind",
  "close-socket",
  "connect",
  "get-host-by-name",
  "get-host-name",
  "get-socket-option",
  "ioctl-socket",
  "listen",
  "recv",
  "send",
  "select",
  "set-socket-option",
  "shutdown",
  "socket",

  /* C Library's unix-style procedures: */
  "close",
  "fstat",
  "getcwd",
  "gmtime",
  "localtime",
  "lseek",
  "malloc",
  "mkdir",
  "mktime",
  "open",
  "read",
  "realloc",
  "rmdir",
  "stat",
  "unlink",
  "write"
};

/* Machine-generated table, do not edit: */
static const char * syserr_names_table [] =
{
  /* Win32 error codes: */
  "success",
  "invalid-function",
  "file-not-found",
  "path-not-found",
  "too-many-open-files",
  "access-denied",
  "invalid-handle",
  "arena-trashed",
  "not-enough-memory",
  "invalid-block",
  "bad-environment",
  "bad-format",
  "invalid-access",
  "invalid-data",
  "outofmemory",
  "invalid-drive",
  "current-directory",
  "not-same-device",
  "no-more-files",
  "write-protect",
  "bad-unit",
  "not-ready",
  "bad-command",
  "crc",
  "bad-length",
  "seek",
  "not-dos-disk",
  "sector-not-found",
  "out-of-paper",
  "write-fault",
  "read-fault",
  "gen-failure",
  "sharing-violation",
  "lock-violation",
  "wrong-disk",
  "sharing-buffer-exceeded",
  "handle-eof",
  "handle-disk-full",
  "not-supported",
  "rem-not-list",
  "dup-name",
  "bad-netpath",
  "network-busy",
  "dev-not-exist",
  "too-many-cmds",
  "adap-hdw-err",
  "bad-net-resp",
  "unexp-net-err",
  "bad-rem-adap",
  "printq-full",
  "no-spool-space",
  "print-cancelled",
  "netname-deleted",
  "network-access-denied",
  "bad-dev-type",
  "bad-net-name",
  "too-many-names",
  "too-many-sess",
  "sharing-paused",
  "req-not-accep",
  "redir-paused",
  "file-exists",
  "cannot-make",
  "fail-i24",
  "out-of-structures",
  "already-assigned",
  "invalid-password",
  "invalid-parameter",
  "net-write-fault",
  "no-proc-slots",
  "too-many-semaphores",
  "excl-sem-already-owned",
  "sem-is-set",
  "too-many-sem-requests",
  "invalid-at-interrupt-time",
  "sem-owner-died",
  "sem-user-limit",
  "disk-change",
  "drive-locked",
  "broken-pipe",
  "open-failed",
  "buffer-overflow",
  "disk-full",
  "no-more-search-handles",
  "invalid-target-handle",
  "invalid-category",
  "invalid-verify-switch",
  "bad-driver-level",
  "call-not-implemented",
  "sem-timeout",
  "insufficient-buffer",
  "invalid-name",
  "invalid-level",
  "no-volume-label",
  "mod-not-found",
  "proc-not-found",
  "wait-no-children",
  "child-not-complete",
  "direct-access-handle",
  "negative-seek",
  "seek-on-device",
  "is-join-target",
  "is-joined",
  "is-substed",
  "not-joined",
  "not-substed",
  "join-to-join",
  "subst-to-subst",
  "join-to-subst",
  "subst-to-join",
  "busy-drive",
  "same-drive",
  "dir-not-root",
  "dir-not-empty",
  "is-subst-path",
  "is-join-path",
  "path-busy",
  "is-subst-target",
  "system-trace",
  "invalid-event-count",
  "too-many-muxwaiters",
  "invalid-list-format",
  "label-too-long",
  "too-many-tcbs",
  "signal-refused",
  "discarded",
  "not-locked",
  "bad-threadid-addr",
  "bad-arguments",
  "bad-pathname",
  "signal-pending",
  "max-thrds-reached",
  "lock-failed",
  "busy",
  "cancel-violation",
  "atomic-locks-not-supported",
  "invalid-segment-number",
  "invalid-ordinal",
  "already-exists",
  "invalid-flag-number",
  "sem-not-found",
  "invalid-starting-codeseg",
  "invalid-stackseg",
  "invalid-moduletype",
  "invalid-exe-signature",
  "exe-marked-invalid",
  "bad-exe-format",
  "iterated-data-exceeds-64k",
  "invalid-minallocsize",
  "dynlink-from-invalid-ring",
  "iopl-not-enabled",
  "invalid-segdpl",
  "autodataseg-exceeds-64k",
  "ring2seg-must-be-movable",
  "reloc-chain-xeeds-seglim",
  "infloop-in-reloc-chain",
  "envvar-not-found",
  "no-signal-sent",
  "filename-exced-range",
  "ring2-stack-in-use",
  "meta-expansion-too-long",
  "invalid-signal-number",
  "thread-1-inactive",
  "locked",
  "too-many-modules",
  "nesting-not-allowed",
  "bad-pipe",
  "pipe-busy",
  "no-data",
  "pipe-not-connected",
  "more-data",
  "vc-disconnected",
  "invalid-ea-name",
  "ea-list-inconsistent",
  "no-more-items",
  "cannot-copy",
  "directory",
  "eas-didnt-fit",
  "ea-file-corrupt",
  "ea-table-full",
  "invalid-ea-handle",
  "eas-not-supported",
  "not-owner",
  "too-many-posts",
  "partial-copy",
  "mr-mid-not-found",
  "invalid-address",
  "arithmetic-overflow",
  "pipe-connected",
  "pipe-listening",
  "ea-access-denied",
  "operation-aborted",
  "io-incomplete",
  "io-pending",
  "noaccess",
  "swaperror",
  "stack-overflow",
  "invalid-message",
  "can-not-complete",
  "invalid-flags",
  "unrecognized-volume",
  "file-invalid",
  "fullscreen-mode",
  "no-token",
  "baddb",
  "badkey",
  "cantopen",
  "cantread",
  "cantwrite",
  "registry-recovered",
  "registry-corrupt",
  "registry-io-failed",
  "not-registry-file",
  "key-deleted",
  "no-log-space",
  "key-has-children",
  "child-must-be-volatile",
  "notify-enum-dir",
  "dependent-services-running",
  "invalid-service-control",
  "service-request-timeout",
  "service-no-thread",
  "service-database-locked",
  "service-already-running",
  "invalid-service-account",
  "service-disabled",
  "circular-dependency",
  "service-does-not-exist",
  "service-cannot-accept-ctrl",
  "service-not-active",
  "failed-service-controller-connect",
  "exception-in-service",
  "database-does-not-exist",
  "service-specific-error",
  "process-aborted",
  "service-dependency-fail",
  "service-logon-failed",
  "service-start-hang",
  "invalid-service-lock",
  "service-marked-for-delete",
  "service-exists",
  "already-running-lkg",
  "service-dependency-deleted",
  "boot-already-accepted",
  "service-never-started",
  "duplicate-service-name",
  "end-of-media",
  "filemark-detected",
  "beginning-of-media",
  "setmark-detected",
  "no-data-detected",
  "partition-failure",
  "invalid-block-length",
  "device-not-partitioned",
  "unable-to-lock-media",
  "unable-to-unload-media",
  "media-changed",
  "bus-reset",
  "no-media-in-drive",
  "no-unicode-translation",
  "dll-init-failed",
  "shutdown-in-progress",
  "no-shutdown-in-progress",
  "io-device",
  "serial-no-device",
  "irq-busy",
  "more-writes",
  "counter-timeout",
  "floppy-id-mark-not-found",
  "floppy-wrong-cylinder",
  "floppy-unknown-error",
  "floppy-bad-registers",
  "disk-recalibrate-failed",
  "disk-operation-failed",
  "disk-reset-failed",
  "eom-overflow",
  "not-enough-server-memory",
  "possible-deadlock",
  "mapped-alignment",
  "set-power-state-vetoed",
  "set-power-state-failed",
  "old-win-version",
  "app-wrong-os",
  "single-instance-app",
  "rmode-app",
  "invalid-dll",
  "no-association",
  "dde-fail",
  "dll-not-found",
  "bad-username",
  "not-connected",
  "open-files",
  "active-connections",
  "device-in-use",
  "bad-device",
  "connection-unavail",
  "device-already-remembered",
  "no-net-or-bad-path",
  "bad-provider",
  "cannot-open-profile",
  "bad-profile",
  "not-container",
  "extended-error",
  "invalid-groupname",
  "invalid-computername",
  "invalid-eventname",
  "invalid-domainname",
  "invalid-servicename",
  "invalid-netname",
  "invalid-sharename",
  "invalid-passwordname",
  "invalid-messagename",
  "invalid-messagedest",
  "session-credential-conflict",
  "remote-session-limit-exceeded",
  "dup-domainname",
  "no-network",
  "cancelled",
  "user-mapped-file",
  "connection-refused",
  "graceful-disconnect",
  "address-already-associated",
  "address-not-associated",
  "connection-invalid",
  "connection-active",
  "network-unreachable",
  "host-unreachable",
  "protocol-unreachable",
  "port-unreachable",
  "request-aborted",
  "connection-aborted",
  "retry",
  "connection-count-limit",
  "login-time-restriction",
  "login-wksta-restriction",
  "incorrect-address",
  "already-registered",
  "service-not-found",
  "not-authenticated",
  "not-logged-on",
  "continue",
  "already-initialized",
  "no-more-devices",
  "not-all-assigned",
  "some-not-mapped",
  "no-quotas-for-account",
  "local-user-session-key",
  "null-lm-password",
  "unknown-revision",
  "revision-mismatch",
  "invalid-owner",
  "invalid-primary-group",
  "no-impersonation-token",
  "cant-disable-mandatory",
  "no-logon-servers",
  "no-such-logon-session",
  "no-such-privilege",
  "privilege-not-held",
  "invalid-account-name",
  "user-exists",
  "no-such-user",
  "group-exists",
  "no-such-group",
  "member-in-group",
  "member-not-in-group",
  "last-admin",
  "wrong-password",
  "ill-formed-password",
  "password-restriction",
  "logon-failure",
  "account-restriction",
  "invalid-logon-hours",
  "invalid-workstation",
  "password-expired",
  "account-disabled",
  "none-mapped",
  "too-many-luids-requested",
  "luids-exhausted",
  "invalid-sub-authority",
  "invalid-acl",
  "invalid-sid",
  "invalid-security-descr",
  "bad-inheritance-acl",
  "server-disabled",
  "server-not-disabled",
  "invalid-id-authority",
  "allotted-space-exceeded",
  "invalid-group-attributes",
  "bad-impersonation-level",
  "cant-open-anonymous",
  "bad-validation-class",
  "bad-token-type",
  "no-security-on-object",
  "cant-access-domain-info",
  "invalid-server-state",
  "invalid-domain-state",
  "invalid-domain-role",
  "no-such-domain",
  "domain-exists",
  "domain-limit-exceeded",
  "internal-db-corruption",
  "internal-error",
  "generic-not-mapped",
  "bad-descriptor-format",
  "not-logon-process",
  "logon-session-exists",
  "no-such-package",
  "bad-logon-session-state",
  "logon-session-collision",
  "invalid-logon-type",
  "cannot-impersonate",
  "rxact-invalid-state",
  "rxact-commit-failure",
  "special-account",
  "special-group",
  "special-user",
  "members-primary-group",
  "token-already-in-use",
  "no-such-alias",
  "member-not-in-alias",
  "member-in-alias",
  "alias-exists",
  "logon-not-granted",
  "too-many-secrets",
  "secret-too-long",
  "internal-db-error",
  "too-many-context-ids",
  "logon-type-not-granted",
  "nt-cross-encryption-required",
  "no-such-member",
  "invalid-member",
  "too-many-sids",
  "lm-cross-encryption-required",
  "no-inheritance",
  "file-corrupt",
  "disk-corrupt",
  "no-user-session-key",
  "license-quota-exceeded",
  "invalid-window-handle",
  "invalid-menu-handle",
  "invalid-cursor-handle",
  "invalid-accel-handle",
  "invalid-hook-handle",
  "invalid-dwp-handle",
  "tlw-with-wschild",
  "cannot-find-wnd-class",
  "window-of-other-thread",
  "hotkey-already-registered",
  "class-already-exists",
  "class-does-not-exist",
  "class-has-windows",
  "invalid-index",
  "invalid-icon-handle",
  "private-dialog-index",
  "listbox-id-not-found",
  "no-wildcard-characters",
  "clipboard-not-open",
  "hotkey-not-registered",
  "window-not-dialog",
  "control-id-not-found",
  "invalid-combobox-message",
  "window-not-combobox",
  "invalid-edit-height",
  "dc-not-found",
  "invalid-hook-filter",
  "invalid-filter-proc",
  "hook-needs-hmod",
  "global-only-hook",
  "journal-hook-set",
  "hook-not-installed",
  "invalid-lb-message",
  "setcount-on-bad-lb",
  "lb-without-tabstops",
  "destroy-object-of-other-thread",
  "child-window-menu",
  "no-system-menu",
  "invalid-msgbox-style",
  "invalid-spi-value",
  "screen-already-locked",
  "hwnds-have-diff-parent",
  "not-child-window",
  "invalid-gw-command",
  "invalid-thread-id",
  "non-mdichild-window",
  "popup-already-active",
  "no-scrollbars",
  "invalid-scrollbar-range",
  "invalid-showwin-command",
  "no-system-resources",
  "nonpaged-system-resources",
  "paged-system-resources",
  "working-set-quota",
  "pagefile-quota",
  "commitment-limit",
  "menu-item-not-found",
  "eventlog-file-corrupt",
  "eventlog-cant-start",
  "log-file-full",
  "eventlog-file-changed",
  "rpc-s-invalid-string-binding",
  "rpc-s-wrong-kind-of-binding",
  "rpc-s-invalid-binding",
  "rpc-s-protseq-not-supported",
  "rpc-s-invalid-rpc-protseq",
  "rpc-s-invalid-string-uuid",
  "rpc-s-invalid-endpoint-format",
  "rpc-s-invalid-net-addr",
  "rpc-s-no-endpoint-found",
  "rpc-s-invalid-timeout",
  "rpc-s-object-not-found",
  "rpc-s-already-registered",
  "rpc-s-type-already-registered",
  "rpc-s-already-listening",
  "rpc-s-no-protseqs-registered",
  "rpc-s-not-listening",
  "rpc-s-unknown-mgr-type",
  "rpc-s-unknown-if",
  "rpc-s-no-bindings",
  "rpc-s-no-protseqs",
  "rpc-s-cant-create-endpoint",
  "rpc-s-out-of-resources",
  "rpc-s-server-unavailable",
  "rpc-s-server-too-busy",
  "rpc-s-invalid-network-options",
  "rpc-s-no-call-active",
  "rpc-s-call-failed",
  "rpc-s-call-failed-dne",
  "rpc-s-protocol-error",
  "rpc-s-unsupported-trans-syn",
  "rpc-s-unsupported-type",
  "rpc-s-invalid-tag",
  "rpc-s-invalid-bound",
  "rpc-s-no-entry-name",
  "rpc-s-invalid-name-syntax",
  "rpc-s-unsupported-name-syntax",
  "rpc-s-uuid-no-address",
  "rpc-s-duplicate-endpoint",
  "rpc-s-unknown-authn-type",
  "rpc-s-max-calls-too-small",
  "rpc-s-string-too-long",
  "rpc-s-protseq-not-found",
  "rpc-s-procnum-out-of-range",
  "rpc-s-binding-has-no-auth",
  "rpc-s-unknown-authn-service",
  "rpc-s-unknown-authn-level",
  "rpc-s-invalid-auth-identity",
  "rpc-s-unknown-authz-service",
  "ept-s-invalid-entry",
  "ept-s-cant-perform-op",
  "ept-s-not-registered",
  "rpc-s-nothing-to-export",
  "rpc-s-incomplete-name",
  "rpc-s-invalid-vers-option",
  "rpc-s-no-more-members",
  "rpc-s-not-all-objs-unexported",
  "rpc-s-interface-not-found",
  "rpc-s-entry-already-exists",
  "rpc-s-entry-not-found",
  "rpc-s-name-service-unavailable",
  "rpc-s-invalid-naf-id",
  "rpc-s-cannot-support",
  "rpc-s-no-context-available",
  "rpc-s-internal-error",
  "rpc-s-zero-divide",
  "rpc-s-address-error",
  "rpc-s-fp-div-zero",
  "rpc-s-fp-underflow",
  "rpc-s-fp-overflow",
  "rpc-x-no-more-entries",
  "rpc-x-ss-char-trans-open-fail",
  "rpc-x-ss-char-trans-short-file",
  "rpc-x-ss-in-null-context",
  "rpc-x-ss-context-damaged",
  "rpc-x-ss-handles-mismatch",
  "rpc-x-ss-cannot-get-call-handle",
  "rpc-x-null-ref-pointer",
  "rpc-x-enum-value-out-of-range",
  "rpc-x-byte-count-too-small",
  "rpc-x-bad-stub-data",
  "invalid-user-buffer",
  "unrecognized-media",
  "no-trust-lsa-secret",
  "no-trust-sam-account",
  "trusted-domain-failure",
  "trusted-relationship-failure",
  "trust-failure",
  "rpc-s-call-in-progress",
  "netlogon-not-started",
  "account-expired",
  "redirector-has-open-handles",
  "printer-driver-already-installed",
  "unknown-port",
  "unknown-printer-driver",
  "unknown-printprocessor",
  "invalid-separator-file",
  "invalid-priority",
  "invalid-printer-name",
  "printer-already-exists",
  "invalid-printer-command",
  "invalid-datatype",
  "invalid-environment",
  "rpc-s-no-more-bindings",
  "nologon-interdomain-trust-account",
  "nologon-workstation-trust-account",
  "nologon-server-trust-account",
  "domain-trust-inconsistent",
  "server-has-open-handles",
  "resource-data-not-found",
  "resource-type-not-found",
  "resource-name-not-found",
  "resource-lang-not-found",
  "not-enough-quota",
  "rpc-s-no-interfaces",
  "rpc-s-call-cancelled",
  "rpc-s-binding-incomplete",
  "rpc-s-comm-failure",
  "rpc-s-unsupported-authn-level",
  "rpc-s-no-princ-name",
  "rpc-s-not-rpc-error",
  "rpc-s-uuid-local-only",
  "rpc-s-sec-pkg-error",
  "rpc-s-not-cancelled",
  "rpc-x-invalid-es-action",
  "rpc-x-wrong-es-version",
  "rpc-x-wrong-stub-version",
  "rpc-s-group-member-not-found",
  "ept-s-cant-create",
  "rpc-s-invalid-object",
  "invalid-time",
  "invalid-form-name",
  "invalid-form-size",
  "already-waiting",
  "printer-deleted",
  "invalid-printer-state",
  "password-must-change",
  "domain-controller-not-found",
  "account-locked-out",
  "no-browser-servers-found",
  "invalid-pixel-format",
  "bad-driver",
  "invalid-window-style",
  "metafile-not-supported",
  "transform-not-supported",
  "clipping-not-supported",
  "unknown-print-monitor",
  "printer-driver-in-use",
  "spool-file-not-found",
  "spl-no-startdoc",
  "spl-no-addjob",
  "print-processor-already-installed",
  "print-monitor-already-installed",
  "wins-internal",
  "can-not-del-local-wins",
  "static-init",
  "inc-backup",
  "full-backup",
  "rec-non-existent",
  "rpl-not-allowed",

  /* Winsock error codes: */
  "wsaeintr",
  "wsaebadf",
  "wsaeacces",
  "wsaefault",
  "wsaeinval",
  "wsaemfile",
  "wsaewouldblock",
  "wsaeinprogress",
  "wsaealready",
  "wsaenotsock",
  "wsaedestaddrreq",
  "wsaemsgsize",
  "wsaeprototype",
  "wsaenoprotoopt",
  "wsaeprotonosupport",
  "wsaesocktnosupport",
  "wsaeopnotsupp",
  "wsaepfnosupport",
  "wsaeafnosupport",
  "wsaeaddrinuse",
  "wsaeaddrnotavail",
  "wsaenetdown",
  "wsaenetunreach",
  "wsaenetreset",
  "wsaeconnaborted",
  "wsaeconnreset",
  "wsaenobufs",
  "wsaeisconn",
  "wsaenotconn",
  "wsaeshutdown",
  "wsaetoomanyrefs",
  "wsaetimedout",
  "wsaeconnrefused",
  "wsaeloop",
  "wsaenametoolong",
  "wsaehostdown",
  "wsaehostunreach",
  "wsaenotempty",
  "wsaeproclim",
  "wsaeusers",
  "wsaedquot",
  "wsaestale",
  "wsaeremote",
  "wsaediscon",
  "wsasysnotready",
  "wsavernotsupported",
  "wsanotinitialised",
  "wsahost_not_found",
  "wsatry_again",
  "wsano_recovery",
  "wsano_data",

  /* Unix error codes: */
  "arg-list-too-long",
  "bad-file-descriptor",
  "domain-error",
  "exec-format-error",
  "file-exists",
  "interrupted-function-call",
  "invalid-argument",
  "no-such-file-or-directory",
  "not-a-directory",
  "not-enough-space",
  "permission-denied",
  "resource-deadlock-avoided",
  "resource-temporarily-unavailable",
  "result-too-large",
  "too-many-open-files",
  "unknown"
};

#endif /* SCM_NTTOP_C */

#endif /* not DEFINE_WIN32_SYSCALLS */
