#| -*-Scheme-*-

$Id: parser-macro.scm,v 1.9 2006/02/15 06:08:07 cph Exp $

Copyright 2001,2006 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

|#

;;;; XML parser macros

(declare (usual-integrations))

(define-*matcher-macro S `(+ (CHAR-SET CHAR-SET:XML-WHITESPACE)))
(define-*parser-macro S `(NOISE S))

(define-*matcher-macro S? `(* (CHAR-SET CHAR-SET:XML-WHITESPACE)))
(define-*parser-macro S? `(NOISE S?))

(define-*parser-macro (bracket description open close . body)
  (let ((v (generate-uninterned-symbol)))
    `(WITH-POINTER ,v
       (SEQ ,open
	    ,@body
	    (ALT ,close
		 (SEXP
		  (LAMBDA (BUFFER)
		    BUFFER
		    (PERROR
		     ,v
		     ,(if (string? description)
			  (string-append "Malformed " description)
			  `(STRING-APPEND "Malformed " ,description))))))))))

(define-*parser-macro (sbracket description open close . body)
  `(BRACKET ,description (NOISE (STRING ,open)) (NOISE (STRING ,close))
     ,@body))

(define-*parser-macro (require-success message body)
  `(ALT ,body (SEXP (LAMBDA (BUFFER) (PERROR BUFFER ,message)))))