/* -*-c-*- -------------- mixvm_loop.c :
 * Implementation of mix vm command loop.
 * ------------------------------------------------------------------
 * Copyright (C) 2000, 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#define _GNU_SOURCE 1
#include <stdio.h>

#include <mixlib/mix.h>
#include "mixvm_command.h"

#ifdef HAVE_LIBHISTORY
#  include <readline/history.h>
#else
#  define add_history(x) ((void)0)
#endif

#ifdef HAVE_LIBREADLINE
#  include <readline/readline.h>
#else /* !HAVE_LIBREADLINE */
static char *
readline (char *prompt)
{
  char *line = NULL;
  size_t s = 0;
  
  printf ("%s", prompt);
  getline (&line, &s, stdin);
  return line;
}
#endif /* HAVE_LIBREADLINE */

/* A static variable for holding the line. */
static char *line_read = (char *)NULL;
static const char *PROMPT = N_("MIX > ");

/* Read a string, and return a pointer to it.  Returns NULL on EOF. */
static char *
rl_gets ()
{
  /* If the buffer has already been allocated, return the memory
     to the free pool. */
  if (line_read)
    {
      g_free (line_read);
      line_read = (char *)NULL;
    }
     
  /* Get a line from the user. */
  line_read = readline ((char *)PROMPT);
     
  /* If the line has any text in it, save it on the history. */
  if (line_read && *line_read)
    add_history (line_read);
     
  return (line_read);
}


/* The main command loop of the virtual machine  */
void
mix_vmloop (const gchar *file, gboolean use_emacs)
{
  mixvm_cmd_init ((char *)file, use_emacs);
  while ( mixvm_cmd_exec (rl_gets ()) ) 
    ;
}


