/* -*-c-*- -------------- mixgtk_gen_handlers.c :
 * Implementation of the functions declared in mixgtk_gen_handlers.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-04-29 12:32:47 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <mixlib/mix_vm_command.h>
#include "mixgtk_gen_handlers.h"
#include "mixgtk_cmd_dispatcher.h"
#include "mixgtk_config.h"

typedef void (*file_callback_t)(const gchar *file);

static file_callback_t callback_ = NULL;

static void
on_file_ok_ (GtkWidget *w, gpointer fs)
{
  gchar *file = g_strdup
	  (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy (GTK_WIDGET (fs));
  if (callback_) callback_ (file);
  g_free (file);
}

static void
on_file_destroy_ (GtkWidget *w, gpointer data)
{
  gtk_grab_remove (GTK_WIDGET (w));
}
  
static void show_dlg_ (const gchar *title, const gchar *pattern)
{
  GtkWidget *file = gtk_file_selection_new (title);
  if (pattern)
    gtk_file_selection_complete (GTK_FILE_SELECTION (file), pattern);
  
  gtk_signal_connect (GTK_OBJECT (file), "destroy",
		      (GtkSignalFunc) on_file_destroy_,
		      GTK_OBJECT (file));
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file)->ok_button),
		      "clicked", (GtkSignalFunc) on_file_ok_,
		      GTK_OBJECT (file));
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (file)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (file));
  gtk_widget_show (file);
  gtk_grab_add (file);
}

/* exec prompt command */
static void exec_cmd_ (mix_vm_command_t cmd, const gchar *arg)
{
  gchar *command;
  if (arg)
    command = g_strdup_printf ("%s %s",
			       mix_vm_command_to_string (cmd),
			       arg);
  else
    command = g_strdup (mix_vm_command_to_string (cmd));
  mixgtk_cmd_dispatcher_dispatch (command);
  g_free (command);
}
  
/* load mix binary */
static void open_cb_ (const gchar *file)
{
  if (file)
      exec_cmd_ (MIX_CMD_LOAD, file);
}

void
on_file_open_activate (GtkWidget *w, gpointer data)
{
  callback_ = open_cb_;
  show_dlg_ ("Load MIX program...", "*.mix");
}

/* edit mixal source */
static void edit_cb_ (const gchar *file)
{
  exec_cmd_ (MIX_CMD_EDIT, file);
}

void
on_file_edit_activate (GtkWidget *w, gpointer data)
{
  callback_ = edit_cb_;
  show_dlg_ ("Edit MIXAL source file...",
	     mixgtk_cmd_dispatcher_get_src_path ());
}

/* compile mixal source */
static void compile_cb_ (const gchar *file)
{
  exec_cmd_ (MIX_CMD_COMPILE, file);
}

void
on_file_compile_activate (GtkWidget *w, gpointer data)
{
  callback_ = compile_cb_;
  show_dlg_ ("Compile MIXAL source file...",
	     mixgtk_cmd_dispatcher_get_src_path ());
}

void
on_main_window_destroy (GtkWidget *w, gpointer data)
{
  gtk_main_quit ();
}

void
on_debug_run_activate (GtkWidget *w, gpointer p)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_RUN));
}

void
on_debug_next_activate (GtkWidget *w, gpointer p)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_NEXT));
}


void
on_file_exit_activate (GtkWidget *w, gpointer data)
{
  gtk_main_quit ();
}


void
on_clear_breakpoints_activate (GtkWidget *w, gpointer data)
{
  mixgtk_cmd_dispatcher_dispatch (mix_vm_command_to_string (MIX_CMD_CABP));
}

void
on_save_on_exit_toggle (GtkWidget *w, gpointer data)
{
  mixgtk_config_set_autosave (GTK_CHECK_MENU_ITEM (w)->active);
}

void
on_save_activate (GtkWidget *w, gpointer data)
{
  mixgtk_config_save ();
}


