/* GNU mailutils - a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif  

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>  
#include <string.h>  
#include <sieve.h>

void
sieve_require (list_t slist)
{
  int status;
  iterator_t itr;

  status = iterator_create (&itr, slist);
  if (status)
    {
      sieve_compile_error (sieve_filename, sieve_line_num,
                   "cannot create iterator: %s",
		   mu_errstring (status));
      return;
    }

  for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
    {
      char *name;
      int (*reqfn) __PMT ((sieve_machine_t mach, const char *name)) = NULL;
      char *text = NULL;
      
      iterator_current (itr, (void **)&name);

      if (strncmp (name, "comparator-", 11) == 0)
	{
	  name += 11;
	  reqfn = sieve_require_comparator;
	  text = "comparator";
	}
      else if (strncmp (name, "test-", 5)  == 0) /* GNU extension */
	{
	  name += 5;
	  reqfn = sieve_require_test;
	  text = "test";
	}
      else
	{
	  reqfn = sieve_require_action;
	  text = "action";
	}

      if (reqfn (sieve_machine, name))
	{
	  sieve_compile_error (sieve_filename, sieve_line_num,
			       "source for the required %s %s is not available",
			       text,
			       name);
	}
    }
  iterator_destroy (&itr);
}
     
