/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Procedure;

public class WrongArguments
extends IllegalArgumentException {
    public int number;
    public String usage;
    public String procname;
    Procedure proc;

    public static String checkArgCount(Procedure procedure, int n) {
        int n2 = procedure.numArgs();
        int n3 = n2 & 0xFFF;
        int n4 = n2 >> 12;
        String string = procedure.getName();
        if (string == null) {
            string = procedure.getClass().getName();
        }
        return WrongArguments.checkArgCount(string, n3, n4, n);
    }

    public static String checkArgCount(String string, int n, int n2, int n3) {
        boolean bl;
        if (n3 < n) {
            bl = false;
        } else if (n2 >= 0 && n3 > n2) {
            bl = true;
        } else {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("call to ");
        if (string == null) {
            stringBuffer.append("unnamed procedure");
        } else {
            stringBuffer.append('\'');
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        stringBuffer.append(bl ? " has too many" : " has too few");
        stringBuffer.append(" arguments (");
        stringBuffer.append(n3);
        if (n == n2) {
            stringBuffer.append("; must be ");
            stringBuffer.append(n);
        } else {
            stringBuffer.append("; min=");
            stringBuffer.append(n);
            if (n2 >= 0) {
                stringBuffer.append(", max=");
                stringBuffer.append(n2);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String getMessage() {
        String string;
        if (this.proc != null && (string = WrongArguments.checkArgCount(this.proc, this.number)) != null) {
            return string;
        }
        return super.getMessage();
    }

    public WrongArguments(Procedure procedure, int n) {
        this.proc = procedure;
        this.number = n;
    }

    public WrongArguments(String string, int n, String string2) {
        this.procname = string;
        this.number = n;
        this.usage = string2;
    }
}

