/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RealNum;

public class DivideOp
extends ProcedureN
implements CanInline {
    boolean asInteger;
    public static final DivideOp $Sl = new DivideOp("/");
    public static final DivideOp idiv = new DivideOp("idiv");
    static ClassType typeRatNum;

    public DivideOp(String string) {
        super(string);
    }

    public Object applyN(Object[] objectArray) {
        int n;
        Numeric numeric = objectArray.length == 1 ? IntNum.one() : (Numeric)objectArray[n++];
        for (n = 0; n < objectArray.length; ++n) {
            numeric = numeric.div(objectArray[n]);
        }
        if (this.asInteger) {
            numeric = ((RealNum)numeric).toExactInt(3);
        }
        return numeric;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        Expression expression = applyExp.inlineIfConstant((Procedure)this, inlineCalls);
        if (expression != applyExp) {
            return expression;
        }
        if (this.asInteger) {
            return applyExp;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > 2) {
            return AddOp.pairwise(this, applyExp.getFunction(), expressionArray, inlineCalls);
        }
        if (expressionArray.length == 2) {
            Expression expression2;
            Type type = expressionArray[0].getType();
            Type type2 = expressionArray[1].getType();
            int n = AddOp.classify(type);
            int n2 = AddOp.classify(type2);
            if ((n == 4 || type.isSubtype(typeRatNum)) && (n2 == 4 || type2.isSubtype(typeRatNum))) {
                return new ApplyExp(typeRatNum.getDeclaredMethod("divide", 2), expressionArray);
            }
            if (n >= 3 && n2 >= 3 && (expression2 = AddOp.primInline(108, applyExp)) != applyExp) {
                return expression2;
            }
            if (n >= 2 && n2 >= 2) {
                return new ApplyExp(Arithmetic.typeRealNum.getDeclaredMethod("divide", 2), expressionArray);
            }
        }
        return applyExp;
    }

    static {
        DivideOp.idiv.asInteger = true;
        typeRatNum = ClassType.make("gnu.math.RatNum");
    }
}

