/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Expression;
import gnu.expr.ModuleBody;
import gnu.expr.ScopeExp;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.lists.Pair;
import gnu.mapping.Environment;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.GenericError;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class AutoloadSyntax
extends Syntax
implements Externalizable {
    String className;
    Environment env;
    Syntax loaded;

    public AutoloadSyntax() {
    }

    public AutoloadSyntax(String string, String string2) {
        super(string);
        this.className = string2;
    }

    public AutoloadSyntax(String string, String string2, Environment environment) {
        super(string);
        this.className = string2;
        this.env = environment;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<syntax ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
            stringBuffer.append(' ');
        }
        if (this.loaded != null) {
            stringBuffer.append("autoloaded>");
        } else {
            stringBuffer.append("autoload ");
            stringBuffer.append(this.className);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private void throw_error(String string) {
        throw new GenericError(string + this.className + " while autoloading " + (this.getName() == null ? "" : this.getName().toString()));
    }

    void load() {
        block12: {
            Environment environment = this.env != null ? this.env : Environment.getCurrent();
            String string = this.getName();
            try {
                Object object2 = Class.forName(this.className).newInstance();
                if (object2 instanceof ModuleBody) {
                    ClassMemberConstraint.defineAll(object2, environment);
                    ((ModuleBody)object2).run();
                    try {
                        object2 = environment.getFunction(string);
                    }
                    catch (Exception exception) {
                        object2 = null;
                    }
                    if (object2 == null || object2 == this || !(object2 instanceof Syntax)) {
                        this.throw_error("syntax not found in ");
                    }
                    this.loaded = (Syntax)object2;
                    break block12;
                }
                if (object2 instanceof Syntax) {
                    this.loaded = (Syntax)object2;
                } else {
                    this.throw_error("failed to autoload valid syntax object ");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.throw_error("failed to find class ");
            }
            catch (InstantiationException instantiationException) {
                this.throw_error("failed to instantiate class ");
            }
            catch (IllegalAccessException illegalAccessException) {
                this.throw_error("illegal access in class ");
            }
            catch (UnboundSymbol unboundSymbol) {
                this.throw_error("missing symbol '" + unboundSymbol.getMessage() + "' ");
            }
            catch (WrongArguments wrongArguments) {
                this.throw_error("type error");
            }
        }
    }

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (this.loaded == null) {
            try {
                this.load();
            }
            catch (RuntimeException runtimeException) {
                translator.syntaxError(runtimeException.getMessage());
                return false;
            }
        }
        return this.loaded.scanForDefinitions(pair, vector, scopeExp, translator);
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        if (this.loaded == null) {
            try {
                this.load();
            }
            catch (GenericError genericError) {
                return translator.syntaxError(genericError.getMessage());
            }
            catch (WrongType wrongType) {
                return translator.syntaxError(wrongType.getMessage());
            }
        }
        Syntax syntax2 = translator.currentSyntax;
        translator.currentSyntax = this.loaded;
        try {
            Expression expression = this.loaded.rewriteForm(pair, translator);
            Object var6_7 = null;
            translator.currentSyntax = syntax2;
            return expression;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            translator.currentSyntax = syntax2;
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.className);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.className = (String)objectInput.readObject();
    }
}

