/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.Symbol;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SymbolEnumeration
implements Enumeration {
    Symbol[] bindings;
    int index;
    Environment parent;

    public SymbolEnumeration(Symbol[] symbolArray, int n, Environment environment) {
        this.bindings = symbolArray;
        this.index = n;
        this.parent = environment;
    }

    public SymbolEnumeration(Symbol[] symbolArray, int n) {
        this.bindings = symbolArray;
        this.index = n;
        this.parent = null;
    }

    public SymbolEnumeration(Environment environment) {
        this(environment.table, 1 << environment.log2Size, environment.previous);
    }

    public boolean hasMoreElements() {
        while (true) {
            if (this.index > 0) {
                Symbol symbol;
                if ((symbol = this.bindings[--this.index]) == null || symbol == Symbol.hashDELETED) continue;
                ++this.index;
                return true;
            }
            if (this.parent == null) {
                return false;
            }
            this.bindings = this.parent.table;
            this.index = 1 << this.parent.log2Size;
            this.parent = this.parent.previous;
        }
    }

    public Object nextElement() {
        if (this.hasMoreElements()) {
            return this.bindings[--this.index];
        }
        throw new NoSuchElementException();
    }

    public Symbol nextSymbol() {
        return this.bindings[--this.index];
    }
}

