/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xslt;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.expr.ApplyExp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.xml.AttributeConstructor;
import gnu.kawa.xml.ElementConstructor;
import gnu.kawa.xml.XMLParser;
import gnu.kawa.xslt.XSLT;
import gnu.lists.Consumer;
import gnu.mapping.InPort;
import gnu.mapping.Symbol;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.xquery.lang.XQParser;
import java.util.Stack;

public class XslTranslator
extends Lexer
implements Consumer {
    boolean inTemplate;
    Declaration consumerDecl;
    Stack elements = new Stack();
    StringBuffer nesting = new StringBuffer(100);
    ModuleExp mexp;
    String attributeName;
    Object attributeType;
    AttributeConstructor attributeConstructor;
    StringBuffer attributeValue = new StringBuffer(100);
    XSLT interpreter;
    XMLParser parser;
    LambdaExp templateLambda;
    static final String XSL_TRANSFORM_URI = "http://www.w3.org/1999/XSL/Transform";
    static final ClassType typeXSLT = ClassType.make("gnu.kawa.xslt.XSLT");
    static final ClassType typeTemplateTable = ClassType.make("gnu.kawa.xslt.TemplateTable");
    static final Method defineTemplateMethod = typeXSLT.getDeclaredMethod("defineTemplate", 5);
    static final Method runStylesheetMethod = typeXSLT.getDeclaredMethod("runStylesheet", 0);
    static final PrimProcedure defineTemplateProc = new PrimProcedure(defineTemplateMethod);
    static final PrimProcedure runStylesheetProc = new PrimProcedure(runStylesheetMethod);
    static final Method applyTemplatesMethod = typeXSLT.getDeclaredMethod("applyTemplates", 2);
    static final PrimProcedure applyTemplatesProc = new PrimProcedure(applyTemplatesMethod);

    XslTranslator(InPort inPort, SourceMessages sourceMessages, XSLT xSLT) {
        super(inPort, sourceMessages);
        this.interpreter = xSLT;
    }

    public XslTranslator(ModuleExp moduleExp, SourceMessages sourceMessages, XSLT xSLT) {
        super(null, sourceMessages);
        this.mexp = moduleExp;
        this.interpreter = xSLT;
    }

    public String popMatchingAttribute(String string, String string2, int n) {
        int n2 = this.elements.size();
        int n3 = n;
        while (n3 < n2) {
            Object e = this.elements.elementAt(n);
            if (!(e instanceof ApplyExp)) {
                return null;
            }
            ApplyExp applyExp = (ApplyExp)e;
            Expression expression = applyExp.getFunction();
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof AttributeConstructor)) {
                return null;
            }
            AttributeConstructor attributeConstructor = (AttributeConstructor)object2;
            Symbol symbol = attributeConstructor.getQName();
            if (symbol.getLocalName() == string2 && symbol.getNamespaceURI() == string) {
                this.elements.removeElementAt(n3);
                return (String)((QuoteExp)applyExp.getArgs()[0]).getValue();
            }
            ++n3;
        }
        return null;
    }

    Expression popTemplateBody(int n) {
        int n2 = this.elements.size() - n;
        Expression[] expressionArray = new Expression[n2];
        while (--n2 >= 0) {
            expressionArray[n2] = (Expression)this.elements.pop();
        }
        return new ApplyExp(AppendValues.appendValues, expressionArray);
    }

    public static String isXslTag(Object object2) {
        if (object2 instanceof QuoteExp) {
            object2 = ((QuoteExp)object2).getValue();
        }
        if (object2 instanceof ElementConstructor) {
            object2 = ((ElementConstructor)object2).getQName();
        }
        if (!(object2 instanceof Symbol)) {
            return null;
        }
        Symbol symbol = (Symbol)object2;
        if (symbol.getNamespaceURI() != XSL_TRANSFORM_URI) {
            return null;
        }
        return symbol.getLocalName();
    }

    void append(Expression expression) {
    }

    public void beginGroup(String string, Object object2) {
        String string2 = XslTranslator.isXslTag(object2);
        if (string2 == "template") {
            this.templateLambda = new LambdaExp();
        }
        this.nesting.append((char)this.elements.size());
        this.push(ElementConstructor.make(string, (Symbol)object2));
    }

    public void beginAttribute(String string, Object object2) {
        this.attributeName = string;
        this.attributeType = object2;
        this.attributeConstructor = AttributeConstructor.make(string, (Symbol)object2);
        this.attributeValue.setLength(0);
        this.nesting.append((char)this.elements.size());
    }

    public void endAttribute() {
        Expression[] expressionArray = new Expression[]{new QuoteExp(this.attributeValue.toString())};
        this.push(new ApplyExp(this.attributeConstructor, expressionArray));
        this.nesting.setLength(this.nesting.length() - 1);
        this.attributeConstructor = null;
        this.attributeType = null;
        this.attributeName = null;
    }

    public void endGroup(String string) {
        int n = this.nesting.length() - 1;
        char c = this.nesting.charAt(n);
        this.nesting.setLength(n);
        Expression expression = (Expression)this.elements.elementAt(c);
        String string2 = XslTranslator.isXslTag(expression);
        if (string2 == "value-of") {
            String string3 = this.popMatchingAttribute("", "select", c + '\u0001');
            if (string3 != null) {
                Expression expression2 = this.interpreter.parseXPath(string3, this.getMessages());
                expression2 = XQParser.stringValue(expression2);
                this.elements.pop();
                this.push(expression2);
                return;
            }
        } else if (string2 == "apply-templates") {
            String string4 = this.popMatchingAttribute("", "select", c + '\u0001');
            String string5 = this.popMatchingAttribute("", "mode", c + '\u0001');
            Expression[] expressionArray = new Expression[]{new QuoteExp(string4), this.resolveQNameExpression(string5)};
            this.elements.pop();
            this.push(new ApplyExp(new QuoteExp(applyTemplatesProc), expressionArray));
        } else if (string2 == "if") {
            String string6 = this.popMatchingAttribute("", "test", c + '\u0001');
            Expression expression3 = this.interpreter.parseXPath(string6, this.getMessages());
            expression3 = XQParser.booleanValue(expression3);
            Expression expression4 = this.popTemplateBody(c + '\u0001');
            this.elements.pop();
            this.push(new IfExp(expression3, expression4, QuoteExp.voidExp));
        } else if (string2 == "stylesheet" || string2 == "transform") {
            this.push(new ApplyExp(new QuoteExp(runStylesheetProc), Expression.noExpressions));
            Expression expression5 = this.popTemplateBody(c + '\u0001');
            this.push(expression5);
            this.mexp.body = expression5;
        } else if (string2 == "template") {
            String string7 = this.popMatchingAttribute("", "match", c + '\u0001');
            String string8 = this.popMatchingAttribute("", "name", c + '\u0001');
            String string9 = this.popMatchingAttribute("", "priority", c + '\u0001');
            String string10 = this.popMatchingAttribute("", "mode", c + '\u0001');
            this.templateLambda.body = this.popTemplateBody(c + '\u0001');
            this.elements.pop();
            Expression[] expressionArray = new Expression[5];
            double d = 0.0;
            expressionArray[0] = this.resolveQNameExpression(string8);
            expressionArray[1] = new QuoteExp(string7);
            expressionArray[2] = new QuoteExp(DFloNum.make(d));
            expressionArray[3] = this.resolveQNameExpression(string10);
            expressionArray[4] = this.templateLambda;
            this.push(new ApplyExp(new QuoteExp(defineTemplateProc), expressionArray));
            this.templateLambda = null;
        } else {
            Expression[] expressionArray = new Expression[this.elements.size() - c - 1];
            int n2 = expressionArray.length;
            while (--n2 >= 0) {
                expressionArray[n2] = (Expression)this.elements.pop();
            }
            this.elements.pop();
            ApplyExp applyExp = new ApplyExp(expression, expressionArray);
            this.push(applyExp);
            this.mexp.body = applyExp;
        }
    }

    public void writeChar(int n) {
        if (this.attributeType != null) {
            this.attributeValue.append(n);
        } else {
            this.push(String.valueOf((char)n));
        }
    }

    void push(Expression expression) {
        this.elements.push(expression);
    }

    void push(Object object2) {
        this.push(new QuoteExp(object2));
    }

    public void writeBoolean(boolean bl) {
        if (this.attributeType != null) {
            this.attributeValue.append(bl);
        } else {
            this.push(bl ? QuoteExp.trueExp : QuoteExp.falseExp);
        }
    }

    public void writeFloat(float f) {
        if (this.attributeType != null) {
            this.attributeValue.append(f);
        } else {
            this.push(DFloNum.make(f));
        }
    }

    public void writeDouble(double d) {
        if (this.attributeType != null) {
            this.attributeValue.append(d);
        } else {
            this.push(DFloNum.make(d));
        }
    }

    public void writeInt(int n) {
        if (this.attributeType != null) {
            this.attributeValue.append(n);
        } else {
            this.push(IntNum.make(n));
        }
    }

    public void writeLong(long l) {
        if (this.attributeType != null) {
            this.attributeValue.append(l);
        } else {
            this.push(IntNum.make(l));
        }
    }

    public void beginDocument() {
    }

    public void beginDocument(ModuleExp moduleExp) {
        this.mexp = moduleExp;
        this.beginDocument();
    }

    public void endDocument() {
    }

    public void writeObject(Object object2) {
        if (this.attributeType != null) {
            this.attributeValue.append(object2);
        } else {
            this.push(object2);
        }
    }

    public void writeChars(String string) {
        if (this.attributeType != null) {
            this.attributeValue.append(string);
        } else {
            this.push(string);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.attributeType != null) {
            this.attributeValue.append(cArray, n, n2);
        } else {
            this.push(new String(cArray, n, n2));
        }
    }

    public boolean ignoring() {
        return false;
    }

    public Expression getExpression() {
        return (Expression)this.elements.pop();
    }

    Expression resolveQNameExpression(String string) {
        if (string == null) {
            return QuoteExp.nullExp;
        }
        return new QuoteExp(Symbol.make(null, string));
    }
}

