/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class defcustom
extends Syntax {
    @Override
    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        if (!(st.getCdr() instanceof Pair)) {
            return super.scanForDefinitions(st, forms, defs, tr);
        }
        Pair p = (Pair)st.getCdr();
        Object name = p.getCar();
        if (name instanceof String || name instanceof Symbol) {
            Declaration decl = defs.lookup(name);
            if (decl == null) {
                decl = new Declaration(name);
                defs.addDeclaration(decl);
            } else {
                tr.error('w', "duplicate declaration for `" + name + "'");
            }
            p = Translator.makePair(p, decl, p.getCdr());
            st = Translator.makePair(st, this, p);
            if (defs instanceof ModuleExp) {
                decl.setCanRead(true);
                decl.setCanWrite(true);
            }
        }
        forms.addElement(st);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        Pair p1;
        Object obj = form.getCdr();
        String name = null;
        Expression value = null;
        Declaration decl = null;
        if (obj instanceof Pair && (p1 = (Pair)obj).getCar() instanceof Declaration) {
            decl = (Declaration)p1.getCar();
            name = decl.getName();
            if (p1.getCdr() instanceof Pair) {
                Pair p2 = (Pair)p1.getCdr();
                value = tr.rewrite(p2.getCar());
                if (p2.getCdr() == LList.Empty) {
                    // empty if block
                }
            } else if (p1.getCdr() != LList.Empty) {
                name = null;
            }
        }
        if (name == null) {
            return tr.syntaxError("invalid syntax for " + this.getName());
        }
        SetExp sexp = new SetExp(name, value);
        sexp.setDefining(true);
        if (decl != null) {
            sexp.setBinding(decl);
            if (decl.context instanceof ModuleExp && decl.getCanWrite()) {
                value = null;
            }
            decl.noteValue(value);
        }
        return sexp;
    }
}

