/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpExpVisitor;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.TryExp;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.CompileReflect;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;
import java.lang.reflect.InvocationTargetException;

public class InlineCalls
extends ExpExpVisitor<Type> {
    private static Class[] inlinerMethodArgTypes;

    public static Expression inlineCalls(Expression exp, Compilation comp) {
        InlineCalls visitor = new InlineCalls(comp);
        return visitor.visit(exp, null);
    }

    public InlineCalls(Compilation comp) {
        this.setContext(comp);
    }

    @Override
    public Expression visit(Expression exp, Type required) {
        if (!exp.getFlag(1)) {
            exp.setFlag(1);
            exp = (Expression)super.visit(exp, required);
            exp.setFlag(1);
        }
        return this.checkType(exp, required);
    }

    public Expression checkType(Expression exp, Type required) {
        boolean incompatible;
        Type expType = exp.getType();
        if (required instanceof ClassType && ((ClassType)required).isInterface() && expType.isSubtype(Compilation.typeProcedure) && !expType.isSubtype(required)) {
            Method amethod;
            if (exp instanceof LambdaExp && (amethod = ((ClassType)required).checkSingleAbstractMethod()) != null) {
                LambdaExp lexp = (LambdaExp)exp;
                ObjectExp oexp = new ObjectExp();
                oexp.setLocation(exp);
                oexp.supers = new Expression[]{new QuoteExp(required)};
                oexp.setTypes(this.getCompilation());
                String mname = amethod.getName();
                oexp.addMethod(lexp, mname);
                Declaration mdecl = oexp.addDeclaration(mname, Compilation.typeProcedure);
                oexp.firstChild = lexp;
                oexp.declareParts(this.comp);
                return this.visit((Expression)oexp, required);
            }
            incompatible = true;
        } else {
            Expression converted;
            if (expType == Type.toStringType) {
                expType = Type.javalangStringType;
            }
            boolean bl = incompatible = required != null && required.compare(expType) == -3;
            if (incompatible && required instanceof TypeValue && (converted = ((TypeValue)((Object)required)).convertValue(exp)) != null) {
                return converted;
            }
        }
        if (incompatible) {
            Language language = this.comp.getLanguage();
            this.comp.error('w', "type " + language.formatType(expType) + " is incompatible with required type " + language.formatType(required), exp);
        }
        return exp;
    }

    @Override
    protected Expression visitApplyExp(ApplyExp exp, Type required) {
        Expression func = exp.func;
        if (func instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)func;
            Expression inlined = InlineCalls.inlineCall((LambdaExp)func, exp.args, false);
            if (inlined != null) {
                return this.visit(inlined, required);
            }
        }
        exp.func = func = this.visit(func, null);
        return func.validateApply(exp, this, required, null);
    }

    public final Expression visitApplyOnly(ApplyExp exp, Type required) {
        return exp.func.validateApply(exp, this, required, null);
    }

    public static Integer checkIntValue(Expression exp) {
        if (exp instanceof QuoteExp) {
            IntNum ivalue;
            QuoteExp qarg = (QuoteExp)exp;
            Object value = qarg.getValue();
            if (!qarg.isExplicitlyTyped() && value instanceof IntNum && (ivalue = (IntNum)value).inIntRange()) {
                return ivalue.intValue();
            }
        }
        return null;
    }

    public static Long checkLongValue(Expression exp) {
        if (exp instanceof QuoteExp) {
            IntNum ivalue;
            QuoteExp qarg = (QuoteExp)exp;
            Object value = qarg.getValue();
            if (!qarg.isExplicitlyTyped() && value instanceof IntNum && (ivalue = (IntNum)value).inLongRange()) {
                return ivalue.longValue();
            }
        }
        return null;
    }

    public QuoteExp fixIntValue(Expression exp) {
        Integer ival = InlineCalls.checkIntValue(exp);
        if (ival != null) {
            return new QuoteExp(ival, this.comp.getLanguage().getTypeFor(Integer.TYPE));
        }
        return null;
    }

    public QuoteExp fixLongValue(Expression exp) {
        Long ival = InlineCalls.checkLongValue(exp);
        if (ival != null) {
            return new QuoteExp(ival, this.comp.getLanguage().getTypeFor(Long.TYPE));
        }
        return null;
    }

    @Override
    protected Expression visitQuoteExp(QuoteExp exp, Type required) {
        Object value;
        if (exp.getRawType() == null && !exp.isSharedConstant() && (value = exp.getValue()) != null) {
            Language language = this.comp.getLanguage();
            Type vtype = language.getTypeFor(value.getClass());
            if (vtype == Type.toStringType) {
                vtype = Type.javalangStringType;
            }
            exp.type = vtype;
            if (required instanceof PrimType) {
                QuoteExp ret;
                char sig1 = required.getSignature().charAt(0);
                QuoteExp quoteExp = sig1 == 'I' ? this.fixIntValue(exp) : (ret = sig1 == 'J' ? this.fixLongValue(exp) : null);
                if (ret != null) {
                    exp = ret;
                }
            }
        }
        return exp;
    }

    @Override
    protected Expression visitReferenceExp(ReferenceExp exp, Type required) {
        Declaration decl = exp.getBinding();
        if (decl != null && decl.field == null && !decl.getCanWrite()) {
            Expression dval = decl.getValue();
            if (dval instanceof QuoteExp && dval != QuoteExp.undefined_exp) {
                return this.visitQuoteExp((QuoteExp)dval, required);
            }
            if (dval instanceof ReferenceExp && !decl.isAlias()) {
                ReferenceExp rval = (ReferenceExp)dval;
                Declaration rdecl = rval.getBinding();
                Type dtype = decl.getType();
                if (!(rdecl == null || rdecl.getCanWrite() || dtype != null && dtype != Type.pointer_type && dtype != rdecl.getType() || rval.getDontDereference())) {
                    return this.visitReferenceExp(rval, required);
                }
            }
            if (!exp.isProcedureName() && (decl.flags & 0x100080L) == 0x100080L) {
                this.comp.error('e', "unimplemented: reference to method " + decl.getName() + " as variable");
                this.comp.error('e', decl, "here is the definition of ", "");
            }
        }
        return (Expression)super.visitReferenceExp(exp, required);
    }

    @Override
    protected Expression visitIfExp(IfExp exp, Type required) {
        Expression value;
        Declaration decl;
        Expression test2 = exp.test.visit(this, null);
        if (test2 instanceof ReferenceExp && (decl = ((ReferenceExp)test2).getBinding()) != null && (value = decl.getValue()) instanceof QuoteExp && value != QuoteExp.undefined_exp) {
            test2 = value;
        }
        exp.test = test2;
        if (this.exitValue == null) {
            exp.then_clause = this.visit(exp.then_clause, required);
        }
        if (this.exitValue == null && exp.else_clause != null) {
            exp.else_clause = this.visit(exp.else_clause, required);
        }
        if (test2 instanceof QuoteExp) {
            boolean truth = this.comp.getLanguage().isTrue(((QuoteExp)test2).getValue());
            return exp.select(truth);
        }
        if (test2.getType().isVoid()) {
            boolean truth = this.comp.getLanguage().isTrue(Values.empty);
            this.comp.error('w', "void-valued condition is always " + truth);
            return new BeginExp(test2, exp.select(truth));
        }
        return exp;
    }

    @Override
    protected Expression visitBeginExp(BeginExp exp, Type required) {
        int last = exp.length - 1;
        for (int i = 0; i <= last; ++i) {
            exp.exps[i] = this.visit(exp.exps[i], i < last ? null : required);
        }
        return exp;
    }

    @Override
    protected Expression visitScopeExp(ScopeExp exp, Type required) {
        exp.visitChildren(this, null);
        this.visitDeclarationTypes(exp);
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.type != null) continue;
            Expression val = decl.getValue();
            decl.type = Type.objectType;
            decl.setType(val != null && val != QuoteExp.undefined_exp ? val.getType() : Type.objectType);
        }
        return exp;
    }

    @Override
    protected Expression visitLetExp(LetExp exp, Type required) {
        ReferenceExp ref;
        Declaration d;
        Declaration decl = exp.firstDecl();
        int n = exp.inits.length;
        int i = 0;
        while (i < n) {
            Expression init;
            Expression init0 = exp.inits[i];
            boolean typeSpecified = decl.getFlag(8192L);
            Type dtype = typeSpecified && init0 != QuoteExp.undefined_exp ? decl.getType() : null;
            exp.inits[i] = init = this.visit(init0, dtype);
            Expression dvalue = decl.value;
            if (dvalue == init0) {
                decl.value = dvalue = init;
                if (!typeSpecified) {
                    decl.setType(dvalue.getType());
                }
            }
            ++i;
            decl = decl.nextDecl();
        }
        if (this.exitValue == null) {
            exp.body = this.visit(exp.body, required);
        }
        if (exp.body instanceof ReferenceExp && (d = (ref = (ReferenceExp)exp.body).getBinding()) != null && d.context == exp && !ref.getDontDereference() && n == 1) {
            Expression init = exp.inits[0];
            Expression texp = d.getTypeExp();
            if (texp != QuoteExp.classObjectExp) {
                init = this.visitApplyOnly(Compilation.makeCoercion(init, texp), null);
            }
            return init;
        }
        return exp;
    }

    @Override
    protected Expression visitLambdaExp(LambdaExp exp, Type required) {
        Declaration firstDecl = exp.firstDecl();
        if (firstDecl != null && firstDecl.isThisParameter() && !exp.isClassMethod() && firstDecl.type == null) {
            firstDecl.setType(this.comp.mainClass);
        }
        return this.visitScopeExp((ScopeExp)exp, required);
    }

    @Override
    protected Expression visitTryExp(TryExp exp, Type required) {
        if (exp.getCatchClauses() == null && exp.getFinallyClause() == null) {
            return this.visit(exp.try_clause, required);
        }
        return (Expression)super.visitTryExp(exp, required);
    }

    @Override
    protected Expression visitSetExpValue(Expression new_value, Type required, Declaration decl) {
        return this.visit(new_value, decl == null || decl.isAlias() ? null : decl.type);
    }

    @Override
    protected Expression visitSetExp(SetExp exp, Type required) {
        Declaration decl = exp.getBinding();
        super.visitSetExp(exp, required);
        if (!exp.isDefining() && decl != null && (decl.flags & 0x100080L) == 0x100080L) {
            this.comp.error('e', "can't assign to method " + decl.getName(), exp);
        }
        if (decl != null && decl.getFlag(8192L) && CompileReflect.checkKnownClass(decl.getType(), this.comp) < 0) {
            decl.setType(Type.errorType);
        }
        return exp;
    }

    private static synchronized Class[] getInlinerMethodArgTypes() throws Exception {
        Class[] t = inlinerMethodArgTypes;
        if (t == null) {
            t = new Class[]{Class.forName("gnu.expr.ApplyExp"), Class.forName("gnu.expr.InlineCalls"), Class.forName("gnu.bytecode.Type"), Class.forName("gnu.mapping.Procedure")};
            inlinerMethodArgTypes = t;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression maybeInline(ApplyExp exp, Type required, Procedure proc) {
        try {
            Object inliner;
            Procedure procedure = proc;
            synchronized (procedure) {
                inliner = proc.getProperty(Procedure.validateApplyKey, null);
                if (inliner instanceof String) {
                    String inliners = (String)inliner;
                    int colon = inliners.indexOf(58);
                    java.lang.reflect.Method method = null;
                    if (colon > 0) {
                        String cname = inliners.substring(0, colon);
                        String mname = inliners.substring(colon + 1);
                        Class<?> clas = Class.forName(cname, true, proc.getClass().getClassLoader());
                        method = clas.getDeclaredMethod(mname, InlineCalls.getInlinerMethodArgTypes());
                    }
                    if (method == null) {
                        this.error('e', "inliner property string for " + proc + " is not of the form CLASS:METHOD");
                        return null;
                    }
                    inliner = method;
                }
            }
            if (inliner != null) {
                Object[] vargs = new Object[]{exp, this, required, proc};
                if (inliner instanceof Procedure) {
                    return (Expression)((Procedure)inliner).applyN(vargs);
                }
                if (inliner instanceof java.lang.reflect.Method) {
                    return (Expression)((java.lang.reflect.Method)inliner).invoke(null, vargs);
                }
            }
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            this.messages.error('e', "caught exception in inliner for " + proc + " - " + ex, ex);
        }
        return null;
    }

    public static Expression inlineCall(LambdaExp lexp, Expression[] args, boolean makeCopy) {
        boolean varArgs;
        if (lexp.keywords != null || lexp.nameDecl != null && !makeCopy) {
            return null;
        }
        boolean bl = varArgs = lexp.max_args < 0;
        if (lexp.min_args == lexp.max_args && lexp.min_args == args.length || varArgs && lexp.min_args == 0) {
            Expression[] cargs;
            IdentityHashTable<Declaration, Declaration> mapper;
            Declaration prev = null;
            int i = 0;
            if (makeCopy) {
                mapper = new IdentityHashTable<Declaration, Declaration>();
                cargs = Expression.deepCopy(args, mapper);
                if (cargs == null && args != null) {
                    return null;
                }
            } else {
                mapper = null;
                cargs = args;
            }
            if (varArgs) {
                Expression[] xargs = new Expression[args.length + 1];
                xargs[0] = QuoteExp.getInstance(lexp.firstDecl().type);
                System.arraycopy(args, 0, xargs, 1, args.length);
                cargs = new Expression[]{new ApplyExp(Invoke.make, xargs)};
            }
            LetExp let2 = new LetExp(cargs);
            Declaration param = lexp.firstDecl();
            while (param != null) {
                Declaration next = param.nextDecl();
                if (makeCopy) {
                    Declaration ldecl = let2.addDeclaration(param.symbol, param.type);
                    if (param.typeExp != null) {
                        ldecl.typeExp = Expression.deepCopy(param.typeExp);
                        if (ldecl.typeExp == null) {
                            return null;
                        }
                    }
                    mapper.put(param, ldecl);
                } else {
                    lexp.remove(prev, param);
                    let2.add(prev, param);
                }
                if (!varArgs && !param.getCanWrite()) {
                    param.setValue(cargs[i]);
                }
                prev = param;
                param = next;
                ++i;
            }
            Expression body = lexp.body;
            if (makeCopy && (body = Expression.deepCopy(body, mapper)) == null && lexp.body != null) {
                return null;
            }
            let2.body = body;
            return let2;
        }
        return null;
    }
}

