/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.functions.Convert;
import gnu.kawa.functions.Not;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import kawa.standard.Scheme;

public class CompileMisc
implements CanInline,
Inlineable {
    static final int CONSTANT_FUNCTION0 = 1;
    static final int CONVERT = 2;
    static final int NOT = 3;
    int code;
    Procedure proc;
    static ClassType typeType;
    static Method coerceMethod;

    public CompileMisc(Procedure proc, int code) {
        this.proc = proc;
        this.code = code;
    }

    public static CompileMisc forConstantFunction0(Object proc) {
        return new CompileMisc((Procedure)proc, 1);
    }

    public static CompileMisc forConvert(Object proc) {
        return new CompileMisc((Procedure)proc, 2);
    }

    public static CompileMisc forNot(Object proc) {
        return new CompileMisc((Procedure)proc, 3);
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        switch (this.code) {
            case 1: {
                return CompileMisc.inlineConstantFunction0((ConstantFunction0)this.proc, exp, walker, argsInlined);
            }
            case 2: {
                return CompileMisc.inlineConvert((Convert)this.proc, exp, walker, argsInlined);
            }
            case 3: {
                return CompileMisc.inlineNot((Not)this.proc, exp, walker, argsInlined);
            }
        }
        throw new Error();
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        switch (this.code) {
            case 2: {
                CompileMisc.compileConvert((Convert)this.proc, exp, comp, target);
                return;
            }
            case 3: {
                this.compileNot((Not)this.proc, exp, comp, target);
                return;
            }
        }
        throw new Error();
    }

    public Type getReturnType(Expression[] args) {
        switch (this.code) {
            case 2: {
                return CompileMisc.getReturnTypeConvert((Convert)this.proc, args);
            }
            case 3: {
                return ((Not)this.proc).language.getTypeFor(Boolean.TYPE);
            }
        }
        throw new Error();
    }

    public static Expression inlineConstantFunction0(ConstantFunction0 proc, ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        int nargs = exp.getArgCount();
        if (nargs != 0 && walker != null) {
            String message = WrongArguments.checkArgCount(proc, nargs);
            return walker.noteError(message);
        }
        return proc.constant;
    }

    public static Expression inlineConvert(Convert proc, ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        return Invoke.inlineClassName(exp, 0, walker);
    }

    public static Expression inlineNot(Not proc, ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        return exp.inlineIfConstant((Procedure)proc, walker);
    }

    public static void compileConvert(Convert proc, ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        if (args.length != 2) {
            throw new Error("wrong number of arguments to " + proc.getName());
        }
        CodeAttr code = comp.getCode();
        Type type = Scheme.getTypeValue(args[0]);
        if (type != null) {
            args[1].compile(comp, Target.pushValue(type));
            if (code.reachableHere()) {
                target.compileFromStack(comp, type);
            }
        } else {
            if (typeType == null) {
                typeType = ClassType.make("gnu.bytecode.Type");
            }
            if (coerceMethod == null) {
                coerceMethod = typeType.addMethod("coerceFromObject", Compilation.apply1args, Type.pointer_type, 1);
            }
            args[0].compile(comp, LangObjType.typeClassType);
            args[1].compile(comp, Target.pushObject);
            code.emitInvokeVirtual(coerceMethod);
            target.compileFromStack(comp, Type.pointer_type);
        }
    }

    public void compileNot(Not proc, ApplyExp exp, Compilation comp, Target target) {
        Expression arg = exp.getArgs()[0];
        Language language = proc.language;
        if (target instanceof ConditionalTarget) {
            ConditionalTarget ctarget = (ConditionalTarget)target;
            ConditionalTarget sub_target = new ConditionalTarget(ctarget.ifFalse, ctarget.ifTrue, language);
            sub_target.trueBranchComesFirst = !ctarget.trueBranchComesFirst;
            arg.compile(comp, sub_target);
            return;
        }
        CodeAttr code = comp.getCode();
        Type type = target.getType();
        if (target instanceof StackTarget && type.getSignature().charAt(0) == 'Z') {
            arg.compile(comp, target);
            code.emitNot(target.getType());
        } else {
            QuoteExp trueExp = QuoteExp.getInstance(language.booleanObject(true));
            QuoteExp falseExp = QuoteExp.getInstance(language.booleanObject(false));
            IfExp.compile(arg, falseExp, trueExp, comp, target);
        }
    }

    public static Type getReturnTypeConvert(Convert proc, Expression[] args) {
        Type type;
        if (args != null && args.length == 2 && (type = Scheme.getTypeValue(args[0])) != null) {
            return type;
        }
        return Type.pointer_type;
    }
}

