/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.LocalField;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;
    private Hashtable dotClasses;
    private boolean noDotSecurity = false;
    public DVResolver resolver;
    public Hashtable cnmap;

    public Library(Class[] staticLib, Class[] dynamicLib) {
        this(staticLib, dynamicLib, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses) {
        this(staticLib, dynamicLib, dotClasses, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses, DVResolver resolver) {
        this(staticLib, dynamicLib, dotClasses, resolver, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses, DVResolver resolver, Hashtable cnmap) {
        this.cnmap = cnmap;
        this.resolver = resolver;
        if (dotClasses == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = dotClasses.length == 0;
            this.dotClasses = new Hashtable();
            Class[] temp = new Class[1];
            int i = 0;
            while (i < dotClasses.length) {
                this.rehash(dotClasses[i]);
                ++i;
            }
        }
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (staticLib != null) {
            Library.rehash(staticLib, this.names, null, this.stateless);
        }
        if (dynamicLib != null) {
            Library.rehash(dynamicLib, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class cls) {
        Hashtable tempNames = new Hashtable();
        Class[] temp = new Class[]{cls};
        Library.rehash(temp, tempNames, new Hashtable(), null);
        this.dotClasses.put(cls, tempNames);
    }

    private static void rehash(Class[] arr, Hashtable hashedNames, Hashtable dynIDs, Hashtable stateless) {
        int i = 0;
        while (i < arr.length) {
            Integer dynID = new Integer(i);
            Method[] marr = arr[i].getMethods();
            Field[] farr = arr[i].getFields();
            int totalMethods = marr.length;
            int totalMembers = totalMethods + farr.length;
            int j = 0;
            while (j < totalMembers) {
                Method m;
                AccessibleObject accessibleObject = m = j < totalMethods ? marr[j] : farr[j - totalMethods];
                if ((m.getModifiers() & 8) > 0) {
                    if (stateless != null && Library.rehash(hashedNames, m)) {
                        stateless.put(m, Boolean.TRUE);
                    }
                } else if (dynIDs != null && Library.rehash(hashedNames, m)) {
                    dynIDs.put(m, dynID);
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean rehash(Hashtable hashedNames, Member m) {
        Hashtable signatures;
        String name = m.getName();
        String signature = TypesStack.getSignature(m);
        if (m instanceof Field || m instanceof LocalField) {
            signature = "()" + signature;
        }
        if ((signatures = (Hashtable)hashedNames.get(name)) == null) {
            Hashtable<String, Member> signatures_new = new Hashtable<String, Member>();
            signatures_new.put(signature, m);
            hashedNames.put(name, signatures_new);
            return true;
        }
        Object conflicting_method = signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, m);
            return true;
        }
        return false;
    }

    public void markStateDependent(String name, Class[] params) throws CompilationException {
        Member m = this.getMember(null, name, params);
        Object removed = this.stateless.remove(m);
        Debug.assert(removed != null, "State dependent methos \"" + m + "\"is made state dependend again.");
    }

    public boolean isStateless(Member o) {
        return this.stateless.containsKey(o);
    }

    public Member getMember(Class container, String name, Class[] params) throws CompilationException {
        Hashtable signatures;
        Hashtable hashedMembers = this.names;
        if (container != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(-1, 11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(container)) {
                Object[] paramsExc = new Object[]{container};
                throw new CompilationException(-1, 12, paramsExc);
            }
            hashedMembers = (Hashtable)this.dotClasses.get(container);
            if (hashedMembers == null) {
                this.rehash(container);
                hashedMembers = (Hashtable)this.dotClasses.get(container);
            }
        }
        if ((signatures = (Hashtable)hashedMembers.get(name)) == null) {
            Object[] paramsExc = new Object[]{name, container};
            throw new CompilationException(-1, container == null ? 5 : 6, paramsExc);
        }
        Vector<Member> applicable_methods = new Vector<Member>();
        Enumeration e = signatures.elements();
        while (e.hasMoreElements()) {
            Member cm = (Member)e.nextElement();
            Class[] cp = TypesStack.getParameterTypes(cm);
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    int i = 0;
                    while (i < cp.length && applicable) {
                        applicable = TypesStack.isWidening(params[i], cp[i]);
                        ++i;
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.addElement(cm);
        }
        if (applicable_methods.size() == 0) {
            Object[] paramsExc = new Object[]{name, Library.describe(name, params), container};
            throw new CompilationException(-1, container == null ? 7 : 8, paramsExc);
        }
        if (applicable_methods.size() == 1) {
            return (Member)applicable_methods.firstElement();
        }
        Enumeration e2 = applicable_methods.elements();
        Member most_specific = (Member)e2.nextElement();
        Class[] most_specific_params = TypesStack.getParameterTypes(most_specific);
        while (e2.hasMoreElements()) {
            Member cm = (Member)e2.nextElement();
            Class[] cp = TypesStack.getParameterTypes(cm);
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            int i = 0;
            while (i < cp.length) {
                moreSpecific = moreSpecific && TypesStack.isWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && TypesStack.isWidening(most_specific_params[i], cp[i]);
                ++i;
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            Object[] paramsExc = new Object[]{Library.describe(name, most_specific_params), Library.describe(name, cp), Library.describe(name, params), container};
            throw new CompilationException(-1, container == null ? 9 : 10, paramsExc);
        }
        return most_specific;
    }

    protected static String describe(String name, Class[] params) {
        StringBuffer invp = new StringBuffer();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
                ++k;
            }
        }
        invp.append(')');
        return invp.toString();
    }

    public int getDynamicMethodClassID(Member m) {
        Integer id = (Integer)this.dynIDs.get(m);
        if (id == null) {
            return -1;
        }
        return id;
    }
}

