/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.debug.Debug;

class OPlist
extends OP {
    protected int size;

    int size() {
        return this.size;
    }

    OP getFirst() {
        Debug.assert(this.size > 0, "First in empty list.");
        return this.next;
    }

    OP getLast() {
        Debug.assert(this.size > 0, "Last in empty list.");
        return this.prev;
    }

    void addFirst(OP o) {
        o.prev = null;
        o.next = null;
        if (this.next != null) {
            o.next = this.next;
            this.next.prev = o;
        }
        this.next = o;
        ++this.size;
    }

    void addLast(OP o) {
        o.prev = null;
        o.next = null;
        if (this.prev != null) {
            o.prev = this.prev;
            this.prev.next = o;
        }
        this.prev = o;
        if (this.next == null) {
            this.next = o;
        }
        ++this.size;
    }

    void addBefore(OP e, OP ne) {
        if (e == this.next) {
            this.addFirst(ne);
            return;
        }
        ne.prev = e.prev;
        ne.next = e;
        e.prev.next = ne;
        e.prev = ne;
        ++this.size;
    }

    void remove(OP o) {
        if (o.prev != null) {
            o.prev.next = o.next;
        } else {
            this.next = o.next;
        }
        if (o.next != null) {
            o.next.prev = o.prev;
        } else {
            this.prev = o.prev;
        }
        o.next = null;
        o.prev = null;
        --this.size;
    }

    void compile(ExpressionImage ei) {
        OP curr = this.next;
        while (curr != null) {
            curr.compile(ei);
            curr = curr.next;
        }
    }

    public String toString() {
        OP curr = this.next;
        StringBuffer res = new StringBuffer();
        while (curr != null) {
            res.append(curr.toString());
            curr = curr.next;
        }
        return res.toString();
    }

    OPlist() {
    }
}

