#include "tags.h"
#include "colors.h"
#include "keys.h"

Tags *GlobalTags = NULL ;

void setTags( Tags *t ) {
  GlobalTags = t ;
}

Tag *getTag( char *name ) {
  if ( ! GlobalTags )
    createDefaultTags() ;
  return GlobalTags->GetTag( name ) ;
}

void Tag::Print() {
  cerr << TagName << " " << color << " " << flags << endl ;
}

void createDefaultTags() {
  GlobalTags = new Tags ;

  GlobalTags->AddTag( newDefaultTag( KEYWORD, KEYWORD_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( COMMENT, COMMENT_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( STRING, STRING_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( TYPE, BASETYPE_C ) ) ;
  GlobalTags->AddTag( newDefaultTag( NUMBER, NUMBER_C ) ) ;
}

Tag *newDefaultTag( char *tag, char *color ) {
  Tag *tempTag = new Tag( tag ) ;
  tempTag->SetColor( color ) ;

  return tempTag ;
}
