/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.OP;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OPlist;
import gnu.jel.debug.Debug;

abstract class OP_function
extends OP {
    public boolean optimize(OPlist list) throws Throwable {
        boolean can_interpret = this.canInterpret();
        if (can_interpret) {
            this.interpret(list);
        }
        return can_interpret;
    }

    abstract boolean canInterpret();

    abstract void interpret(OPlist var1) throws Throwable;

    void consume(OPlist list, OP_load replace_with, int nop, boolean match_start) {
        int toremove = nop * 2 + 1;
        if (match_start) {
            ++toremove;
        }
        OP next_op = this.next;
        OP cop = this;
        int i = 0;
        while (i < toremove) {
            OP prv = cop.prev;
            list.remove(cop);
            cop = prv;
            ++i;
        }
        if (next_op != null) {
            list.addBefore(next_op, replace_with);
        } else {
            list.addLast(replace_with);
        }
    }

    boolean operandsReady(int nop, boolean match_start) {
        boolean ready = true;
        OP oper = this.prev;
        int i = 0;
        while (i < nop && ready) {
            ready = oper instanceof OP_param && oper.prev instanceof OP_load;
            oper = oper.prev.prev;
            ++i;
        }
        if (match_start) {
            ready = ready && oper instanceof OP_start;
        }
        return ready;
    }

    static boolean isFloat(int clsID) {
        return clsID > 5;
    }

    static Number widen(Object o, int clsID) {
        switch (clsID) {
            case 0: {
                if (((Boolean)o).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
            case 1: {
                return (Number)o;
            }
            case 2: {
                return new Long(((Character)o).charValue());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)o;
            }
        }
        Debug.println("Attempt to widen wrong primitive (" + clsID + ").");
        return new Long(0L);
    }

    static Object narrow(Number val, int clsID) {
        switch (clsID) {
            case 0: {
                if (val.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return new Byte(val.byteValue());
            }
            case 2: {
                return new Character((char)val.longValue());
            }
            case 3: {
                return new Short(val.shortValue());
            }
            case 4: {
                return new Integer(val.intValue());
            }
            case 5: {
                return new Long(val.longValue());
            }
            case 6: {
                return new Float(val.floatValue());
            }
            case 7: {
                return new Double(val.doubleValue());
            }
        }
        Debug.println("Attempt to narrow wrong primitive (" + clsID + ").");
        return null;
    }

    OP_function() {
    }
}

