/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.Library;
import gnu.jel.Optimizer;
import gnu.jel.generated.EC;
import gnu.jel.generated.ParseException;
import gnu.jel.generated.TokenMgrError;
import java.io.StringReader;

public class Evaluator {
    public static CompiledExpression compile(String expression, Library lib) throws CompilationException {
        return Evaluator.compile(expression, lib, null);
    }

    public static CompiledExpression compile(String expression, Library lib, Class resultType) throws CompilationException {
        return Evaluator.compileBits(expression, lib, resultType).getExpression();
    }

    public static ExpressionBits compileBits(String expression, Library lib) throws CompilationException {
        return Evaluator.compileBits(expression, lib, null);
    }

    public static ExpressionBits compileBits(String expression, Library lib, Class resultType) throws CompilationException {
        Optimizer o = Evaluator.fillOptimizer(expression, lib, resultType);
        o.optimize(1);
        return o.compileBits();
    }

    static Optimizer fillOptimizer(String expression, Library lib, Class resultType) throws CompilationException {
        EC ec = new EC(new StringReader(expression));
        Optimizer o = new Optimizer(lib);
        try {
            ec.expression(o, resultType);
        }
        catch (ParseException pe) {
            throw new CompilationException(pe);
        }
        catch (TokenMgrError tme) {
            throw new CompilationException(tme);
        }
        return o;
    }
}

