;; guile-gnome
;; Copyright (C) 2003,2004 Andy Wingo <wingo at pobox dot com>

;; This program is free software; you can redistribute it and/or    
;; modify it under the terms of the GNU General Public License as   
;; published by the Free Software Foundation; either version 2 of   
;; the License, or (at your option) any later version.              
;;                                                                  
;; This program is distributed in the hope that it will be useful,  
;; but WITHOUT ANY WARRANTY; without even the implied warranty of   
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    
;; GNU General Public License for more details.                     
;;                                                                  
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, contact:
;;
;; Free Software Foundation           Voice:  +1-617-542-5942
;; 59 Temple Place - Suite 330        Fax:    +1-617-542-2652
;; Boston, MA  02111-1307,  USA       gnu@gnu.org

;;; Commentary:
;;
;;GdkEvent wrapper functions and keyvals.
;;
;;; Code:

(define-module (gnome gtk gdk-event)
  :use-module (gnome gw gdk)
  :use-module (gnome gobject)
  :use-module (oop goops))

;; This hack allows us to export all definitions in this file.
(module-use! (module-public-interface (current-module)) (current-module))

(define (gdk-event:type event)
  (let ((vector (gdk-event->vector event)))
    (if vector
        (genum->symbol
         (make <gdk-event-type>
           #:value (vector-ref vector 0)))
        #f))) ;; #f can happen if gdk-support.c needs some work...

(define-macro (define-gdk-event-accessor types kind name index code)
  (define (symbol-append . args)
    (string->symbol (apply string-append (map symbol->string args))))
  `(define (,(symbol-append 'gdk-event- kind (string->symbol ":") name) event)
     (let ((vector (gdk-event->vector event)))
       (case (gdk-event:type event)
         (,types (let ((val (vector-ref vector ,index)))
                   ,code))
         (else (gruntime-error "Event not of the proper type: ~A" event))))))

(define-gdk-event-accessor (key-press key-release) key modifiers 4
  (gflags->symbol-list
   ;; We have to do some hackery here, because there are bitmasks
   ;; used by XKB that we don't know about.
   (make <gdk-modifier-type> #:value (logand #x1fff val))))
(define-gdk-event-accessor (key-press key-release) key keyval 5
  val)

(define-gdk-event-accessor (selection-notify selection-clear selection-request)
  selection selection 3
  (string->symbol val))
   
(define-gdk-event-accessor (button-press button-release) button x 4
  val)
(define-gdk-event-accessor (button-press button-release) button y 5
  val)
(define-gdk-event-accessor (button-press button-release) button modifiers 6
  (gflags->symbol-list (make <gdk-modifier-type> #:value val)))
(define-gdk-event-accessor (button-press button-release) button button 7
  val)
(define-gdk-event-accessor (button-press button-release) button x-root 9
  val)
(define-gdk-event-accessor (button-press button-release) button y-root 10
  val)

(define-gdk-event-accessor (motion-notify) motion modifiers 6
  (gflags->symbol-list (make <gdk-modifier-type> #:value val)))
(define-gdk-event-accessor (motion-notify) motion x 4
  val)
(define-gdk-event-accessor (motion-notify) motion y 5
  val)

(define-gdk-event-accessor (window-state) window-state changed-mask 3
  (gflags->symbol-list (make <gdk-window-state> #:value val)))
(define-gdk-event-accessor (window-state) window-state new-window-state 4
  (gflags->symbol-list (make <gdk-window-state> #:value val)))

(define-gdk-event-accessor (expose) expose area 3
  val)


;;
;; Update this list with the following bit of perl:
;; perl -p -e 's/#define GDK_/(define gdk:/; s/_/-/g; s/0x/#x/; s/$/)/;' \
;;  < /usr/include/gtk-2.0/gdk/gdkkeysyms.h
;;

(define gdk:VoidSymbol #xFFFFFF)
(define gdk:BackSpace #xFF08)
(define gdk:Tab #xFF09)
(define gdk:Linefeed #xFF0A)
(define gdk:Clear #xFF0B)
(define gdk:Return #xFF0D)
(define gdk:Pause #xFF13)
(define gdk:Scroll-Lock #xFF14)
(define gdk:Sys-Req #xFF15)
(define gdk:Escape #xFF1B)
(define gdk:Delete #xFFFF)
(define gdk:Multi-key #xFF20)
(define gdk:Codeinput #xFF37)
(define gdk:SingleCandidate #xFF3C)
(define gdk:MultipleCandidate #xFF3D)
(define gdk:PreviousCandidate #xFF3E)
(define gdk:Kanji #xFF21)
(define gdk:Muhenkan #xFF22)
(define gdk:Henkan-Mode #xFF23)
(define gdk:Henkan #xFF23)
(define gdk:Romaji #xFF24)
(define gdk:Hiragana #xFF25)
(define gdk:Katakana #xFF26)
(define gdk:Hiragana-Katakana #xFF27)
(define gdk:Zenkaku #xFF28)
(define gdk:Hankaku #xFF29)
(define gdk:Zenkaku-Hankaku #xFF2A)
(define gdk:Touroku #xFF2B)
(define gdk:Massyo #xFF2C)
(define gdk:Kana-Lock #xFF2D)
(define gdk:Kana-Shift #xFF2E)
(define gdk:Eisu-Shift #xFF2F)
(define gdk:Eisu-toggle #xFF30)
(define gdk:Kanji-Bangou #xFF37)
(define gdk:Zen-Koho #xFF3D)
(define gdk:Mae-Koho #xFF3E)
(define gdk:Home #xFF50)
(define gdk:Left #xFF51)
(define gdk:Up #xFF52)
(define gdk:Right #xFF53)
(define gdk:Down #xFF54)
(define gdk:Prior #xFF55)
(define gdk:Page-Up #xFF55)
(define gdk:Next #xFF56)
(define gdk:Page-Down #xFF56)
(define gdk:End #xFF57)
(define gdk:Begin #xFF58)
(define gdk:Select #xFF60)
(define gdk:Print #xFF61)
(define gdk:Execute #xFF62)
(define gdk:Insert #xFF63)
(define gdk:Undo #xFF65)
(define gdk:Redo #xFF66)
(define gdk:Menu #xFF67)
(define gdk:Find #xFF68)
(define gdk:Cancel #xFF69)
(define gdk:Help #xFF6A)
(define gdk:Break #xFF6B)
(define gdk:Mode-switch #xFF7E)
(define gdk:script-switch #xFF7E)
(define gdk:Num-Lock #xFF7F)
(define gdk:KP-Space #xFF80)
(define gdk:KP-Tab #xFF89)
(define gdk:KP-Enter #xFF8D)
(define gdk:KP-F1 #xFF91)
(define gdk:KP-F2 #xFF92)
(define gdk:KP-F3 #xFF93)
(define gdk:KP-F4 #xFF94)
(define gdk:KP-Home #xFF95)
(define gdk:KP-Left #xFF96)
(define gdk:KP-Up #xFF97)
(define gdk:KP-Right #xFF98)
(define gdk:KP-Down #xFF99)
(define gdk:KP-Prior #xFF9A)
(define gdk:KP-Page-Up #xFF9A)
(define gdk:KP-Next #xFF9B)
(define gdk:KP-Page-Down #xFF9B)
(define gdk:KP-End #xFF9C)
(define gdk:KP-Begin #xFF9D)
(define gdk:KP-Insert #xFF9E)
(define gdk:KP-Delete #xFF9F)
(define gdk:KP-Equal #xFFBD)
(define gdk:KP-Multiply #xFFAA)
(define gdk:KP-Add #xFFAB)
(define gdk:KP-Separator #xFFAC)
(define gdk:KP-Subtract #xFFAD)
(define gdk:KP-Decimal #xFFAE)
(define gdk:KP-Divide #xFFAF)
(define gdk:KP-0 #xFFB0)
(define gdk:KP-1 #xFFB1)
(define gdk:KP-2 #xFFB2)
(define gdk:KP-3 #xFFB3)
(define gdk:KP-4 #xFFB4)
(define gdk:KP-5 #xFFB5)
(define gdk:KP-6 #xFFB6)
(define gdk:KP-7 #xFFB7)
(define gdk:KP-8 #xFFB8)
(define gdk:KP-9 #xFFB9)
(define gdk:F1 #xFFBE)
(define gdk:F2 #xFFBF)
(define gdk:F3 #xFFC0)
(define gdk:F4 #xFFC1)
(define gdk:F5 #xFFC2)
(define gdk:F6 #xFFC3)
(define gdk:F7 #xFFC4)
(define gdk:F8 #xFFC5)
(define gdk:F9 #xFFC6)
(define gdk:F10 #xFFC7)
(define gdk:F11 #xFFC8)
(define gdk:L1 #xFFC8)
(define gdk:F12 #xFFC9)
(define gdk:L2 #xFFC9)
(define gdk:F13 #xFFCA)
(define gdk:L3 #xFFCA)
(define gdk:F14 #xFFCB)
(define gdk:L4 #xFFCB)
(define gdk:F15 #xFFCC)
(define gdk:L5 #xFFCC)
(define gdk:F16 #xFFCD)
(define gdk:L6 #xFFCD)
(define gdk:F17 #xFFCE)
(define gdk:L7 #xFFCE)
(define gdk:F18 #xFFCF)
(define gdk:L8 #xFFCF)
(define gdk:F19 #xFFD0)
(define gdk:L9 #xFFD0)
(define gdk:F20 #xFFD1)
(define gdk:L10 #xFFD1)
(define gdk:F21 #xFFD2)
(define gdk:R1 #xFFD2)
(define gdk:F22 #xFFD3)
(define gdk:R2 #xFFD3)
(define gdk:F23 #xFFD4)
(define gdk:R3 #xFFD4)
(define gdk:F24 #xFFD5)
(define gdk:R4 #xFFD5)
(define gdk:F25 #xFFD6)
(define gdk:R5 #xFFD6)
(define gdk:F26 #xFFD7)
(define gdk:R6 #xFFD7)
(define gdk:F27 #xFFD8)
(define gdk:R7 #xFFD8)
(define gdk:F28 #xFFD9)
(define gdk:R8 #xFFD9)
(define gdk:F29 #xFFDA)
(define gdk:R9 #xFFDA)
(define gdk:F30 #xFFDB)
(define gdk:R10 #xFFDB)
(define gdk:F31 #xFFDC)
(define gdk:R11 #xFFDC)
(define gdk:F32 #xFFDD)
(define gdk:R12 #xFFDD)
(define gdk:F33 #xFFDE)
(define gdk:R13 #xFFDE)
(define gdk:F34 #xFFDF)
(define gdk:R14 #xFFDF)
(define gdk:F35 #xFFE0)
(define gdk:R15 #xFFE0)
(define gdk:Shift-L #xFFE1)
(define gdk:Shift-R #xFFE2)
(define gdk:Control-L #xFFE3)
(define gdk:Control-R #xFFE4)
(define gdk:Caps-Lock #xFFE5)
(define gdk:Shift-Lock #xFFE6)
(define gdk:Meta-L #xFFE7)
(define gdk:Meta-R #xFFE8)
(define gdk:Alt-L #xFFE9)
(define gdk:Alt-R #xFFEA)
(define gdk:Super-L #xFFEB)
(define gdk:Super-R #xFFEC)
(define gdk:Hyper-L #xFFED)
(define gdk:Hyper-R #xFFEE)
(define gdk:ISO-Lock #xFE01)
(define gdk:ISO-Level2-Latch #xFE02)
(define gdk:ISO-Level3-Shift #xFE03)
(define gdk:ISO-Level3-Latch #xFE04)
(define gdk:ISO-Level3-Lock #xFE05)
(define gdk:ISO-Group-Shift #xFF7E)
(define gdk:ISO-Group-Latch #xFE06)
(define gdk:ISO-Group-Lock #xFE07)
(define gdk:ISO-Next-Group #xFE08)
(define gdk:ISO-Next-Group-Lock #xFE09)
(define gdk:ISO-Prev-Group #xFE0A)
(define gdk:ISO-Prev-Group-Lock #xFE0B)
(define gdk:ISO-First-Group #xFE0C)
(define gdk:ISO-First-Group-Lock #xFE0D)
(define gdk:ISO-Last-Group #xFE0E)
(define gdk:ISO-Last-Group-Lock #xFE0F)
(define gdk:ISO-Left-Tab #xFE20)
(define gdk:ISO-Move-Line-Up #xFE21)
(define gdk:ISO-Move-Line-Down #xFE22)
(define gdk:ISO-Partial-Line-Up #xFE23)
(define gdk:ISO-Partial-Line-Down #xFE24)
(define gdk:ISO-Partial-Space-Left #xFE25)
(define gdk:ISO-Partial-Space-Right #xFE26)
(define gdk:ISO-Set-Margin-Left #xFE27)
(define gdk:ISO-Set-Margin-Right #xFE28)
(define gdk:ISO-Release-Margin-Left #xFE29)
(define gdk:ISO-Release-Margin-Right #xFE2A)
(define gdk:ISO-Release-Both-Margins #xFE2B)
(define gdk:ISO-Fast-Cursor-Left #xFE2C)
(define gdk:ISO-Fast-Cursor-Right #xFE2D)
(define gdk:ISO-Fast-Cursor-Up #xFE2E)
(define gdk:ISO-Fast-Cursor-Down #xFE2F)
(define gdk:ISO-Continuous-Underline #xFE30)
(define gdk:ISO-Discontinuous-Underline #xFE31)
(define gdk:ISO-Emphasize #xFE32)
(define gdk:ISO-Center-Object #xFE33)
(define gdk:ISO-Enter #xFE34)
(define gdk:dead-grave #xFE50)
(define gdk:dead-acute #xFE51)
(define gdk:dead-circumflex #xFE52)
(define gdk:dead-tilde #xFE53)
(define gdk:dead-macron #xFE54)
(define gdk:dead-breve #xFE55)
(define gdk:dead-abovedot #xFE56)
(define gdk:dead-diaeresis #xFE57)
(define gdk:dead-abovering #xFE58)
(define gdk:dead-doubleacute #xFE59)
(define gdk:dead-caron #xFE5A)
(define gdk:dead-cedilla #xFE5B)
(define gdk:dead-ogonek #xFE5C)
(define gdk:dead-iota #xFE5D)
(define gdk:dead-voiced-sound #xFE5E)
(define gdk:dead-semivoiced-sound #xFE5F)
(define gdk:dead-belowdot #xFE60)
(define gdk:First-Virtual-Screen #xFED0)
(define gdk:Prev-Virtual-Screen #xFED1)
(define gdk:Next-Virtual-Screen #xFED2)
(define gdk:Last-Virtual-Screen #xFED4)
(define gdk:Terminate-Server #xFED5)
(define gdk:AccessX-Enable #xFE70)
(define gdk:AccessX-Feedback-Enable #xFE71)
(define gdk:RepeatKeys-Enable #xFE72)
(define gdk:SlowKeys-Enable #xFE73)
(define gdk:BounceKeys-Enable #xFE74)
(define gdk:StickyKeys-Enable #xFE75)
(define gdk:MouseKeys-Enable #xFE76)
(define gdk:MouseKeys-Accel-Enable #xFE77)
(define gdk:Overlay1-Enable #xFE78)
(define gdk:Overlay2-Enable #xFE79)
(define gdk:AudibleBell-Enable #xFE7A)
(define gdk:Pointer-Left #xFEE0)
(define gdk:Pointer-Right #xFEE1)
(define gdk:Pointer-Up #xFEE2)
(define gdk:Pointer-Down #xFEE3)
(define gdk:Pointer-UpLeft #xFEE4)
(define gdk:Pointer-UpRight #xFEE5)
(define gdk:Pointer-DownLeft #xFEE6)
(define gdk:Pointer-DownRight #xFEE7)
(define gdk:Pointer-Button-Dflt #xFEE8)
(define gdk:Pointer-Button1 #xFEE9)
(define gdk:Pointer-Button2 #xFEEA)
(define gdk:Pointer-Button3 #xFEEB)
(define gdk:Pointer-Button4 #xFEEC)
(define gdk:Pointer-Button5 #xFEED)
(define gdk:Pointer-DblClick-Dflt #xFEEE)
(define gdk:Pointer-DblClick1 #xFEEF)
(define gdk:Pointer-DblClick2 #xFEF0)
(define gdk:Pointer-DblClick3 #xFEF1)
(define gdk:Pointer-DblClick4 #xFEF2)
(define gdk:Pointer-DblClick5 #xFEF3)
(define gdk:Pointer-Drag-Dflt #xFEF4)
(define gdk:Pointer-Drag1 #xFEF5)
(define gdk:Pointer-Drag2 #xFEF6)
(define gdk:Pointer-Drag3 #xFEF7)
(define gdk:Pointer-Drag4 #xFEF8)
(define gdk:Pointer-Drag5 #xFEFD)
(define gdk:Pointer-EnableKeys #xFEF9)
(define gdk:Pointer-Accelerate #xFEFA)
(define gdk:Pointer-DfltBtnNext #xFEFB)
(define gdk:Pointer-DfltBtnPrev #xFEFC)
(define gdk:3270-Duplicate #xFD01)
(define gdk:3270-FieldMark #xFD02)
(define gdk:3270-Right2 #xFD03)
(define gdk:3270-Left2 #xFD04)
(define gdk:3270-BackTab #xFD05)
(define gdk:3270-EraseEOF #xFD06)
(define gdk:3270-EraseInput #xFD07)
(define gdk:3270-Reset #xFD08)
(define gdk:3270-Quit #xFD09)
(define gdk:3270-PA1 #xFD0A)
(define gdk:3270-PA2 #xFD0B)
(define gdk:3270-PA3 #xFD0C)
(define gdk:3270-Test #xFD0D)
(define gdk:3270-Attn #xFD0E)
(define gdk:3270-CursorBlink #xFD0F)
(define gdk:3270-AltCursor #xFD10)
(define gdk:3270-KeyClick #xFD11)
(define gdk:3270-Jump #xFD12)
(define gdk:3270-Ident #xFD13)
(define gdk:3270-Rule #xFD14)
(define gdk:3270-Copy #xFD15)
(define gdk:3270-Play #xFD16)
(define gdk:3270-Setup #xFD17)
(define gdk:3270-Record #xFD18)
(define gdk:3270-ChangeScreen #xFD19)
(define gdk:3270-DeleteWord #xFD1A)
(define gdk:3270-ExSelect #xFD1B)
(define gdk:3270-CursorSelect #xFD1C)
(define gdk:3270-PrintScreen #xFD1D)
(define gdk:3270-Enter #xFD1E)
(define gdk:space #x020)
(define gdk:exclam #x021)
(define gdk:quotedbl #x022)
(define gdk:numbersign #x023)
(define gdk:dollar #x024)
(define gdk:percent #x025)
(define gdk:ampersand #x026)
(define gdk:apostrophe #x027)
(define gdk:quoteright #x027)
(define gdk:parenleft #x028)
(define gdk:parenright #x029)
(define gdk:asterisk #x02a)
(define gdk:plus #x02b)
(define gdk:comma #x02c)
(define gdk:minus #x02d)
(define gdk:period #x02e)
(define gdk:slash #x02f)
(define gdk:0 #x030)
(define gdk:1 #x031)
(define gdk:2 #x032)
(define gdk:3 #x033)
(define gdk:4 #x034)
(define gdk:5 #x035)
(define gdk:6 #x036)
(define gdk:7 #x037)
(define gdk:8 #x038)
(define gdk:9 #x039)
(define gdk:colon #x03a)
(define gdk:semicolon #x03b)
(define gdk:less #x03c)
(define gdk:equal #x03d)
(define gdk:greater #x03e)
(define gdk:question #x03f)
(define gdk:at #x040)
(define gdk:A #x041)
(define gdk:B #x042)
(define gdk:C #x043)
(define gdk:D #x044)
(define gdk:E #x045)
(define gdk:F #x046)
(define gdk:G #x047)
(define gdk:H #x048)
(define gdk:I #x049)
(define gdk:J #x04a)
(define gdk:K #x04b)
(define gdk:L #x04c)
(define gdk:M #x04d)
(define gdk:N #x04e)
(define gdk:O #x04f)
(define gdk:P #x050)
(define gdk:Q #x051)
(define gdk:R #x052)
(define gdk:S #x053)
(define gdk:T #x054)
(define gdk:U #x055)
(define gdk:V #x056)
(define gdk:W #x057)
(define gdk:X #x058)
(define gdk:Y #x059)
(define gdk:Z #x05a)
(define gdk:bracketleft #x05b)
(define gdk:backslash #x05c)
(define gdk:bracketright #x05d)
(define gdk:asciicircum #x05e)
(define gdk:underscore #x05f)
(define gdk:grave #x060)
(define gdk:quoteleft #x060)
(define gdk:a #x061)
(define gdk:b #x062)
(define gdk:c #x063)
(define gdk:d #x064)
(define gdk:e #x065)
(define gdk:f #x066)
(define gdk:g #x067)
(define gdk:h #x068)
(define gdk:i #x069)
(define gdk:j #x06a)
(define gdk:k #x06b)
(define gdk:l #x06c)
(define gdk:m #x06d)
(define gdk:n #x06e)
(define gdk:o #x06f)
(define gdk:p #x070)
(define gdk:q #x071)
(define gdk:r #x072)
(define gdk:s #x073)
(define gdk:t #x074)
(define gdk:u #x075)
(define gdk:v #x076)
(define gdk:w #x077)
(define gdk:x #x078)
(define gdk:y #x079)
(define gdk:z #x07a)
(define gdk:braceleft #x07b)
(define gdk:bar #x07c)
(define gdk:braceright #x07d)
(define gdk:asciitilde #x07e)
(define gdk:nobreakspace #x0a0)
(define gdk:exclamdown #x0a1)
(define gdk:cent #x0a2)
(define gdk:sterling #x0a3)
(define gdk:currency #x0a4)
(define gdk:yen #x0a5)
(define gdk:brokenbar #x0a6)
(define gdk:section #x0a7)
(define gdk:diaeresis #x0a8)
(define gdk:copyright #x0a9)
(define gdk:ordfeminine #x0aa)
(define gdk:guillemotleft #x0ab)
(define gdk:notsign #x0ac)
(define gdk:hyphen #x0ad)
(define gdk:registered #x0ae)
(define gdk:macron #x0af)
(define gdk:degree #x0b0)
(define gdk:plusminus #x0b1)
(define gdk:twosuperior #x0b2)
(define gdk:threesuperior #x0b3)
(define gdk:acute #x0b4)
(define gdk:mu #x0b5)
(define gdk:paragraph #x0b6)
(define gdk:periodcentered #x0b7)
(define gdk:cedilla #x0b8)
(define gdk:onesuperior #x0b9)
(define gdk:masculine #x0ba)
(define gdk:guillemotright #x0bb)
(define gdk:onequarter #x0bc)
(define gdk:onehalf #x0bd)
(define gdk:threequarters #x0be)
(define gdk:questiondown #x0bf)
(define gdk:Agrave #x0c0)
(define gdk:Aacute #x0c1)
(define gdk:Acircumflex #x0c2)
(define gdk:Atilde #x0c3)
(define gdk:Adiaeresis #x0c4)
(define gdk:Aring #x0c5)
(define gdk:AE #x0c6)
(define gdk:Ccedilla #x0c7)
(define gdk:Egrave #x0c8)
(define gdk:Eacute #x0c9)
(define gdk:Ecircumflex #x0ca)
(define gdk:Ediaeresis #x0cb)
(define gdk:Igrave #x0cc)
(define gdk:Iacute #x0cd)
(define gdk:Icircumflex #x0ce)
(define gdk:Idiaeresis #x0cf)
(define gdk:ETH #x0d0)
(define gdk:Eth #x0d0)
(define gdk:Ntilde #x0d1)
(define gdk:Ograve #x0d2)
(define gdk:Oacute #x0d3)
(define gdk:Ocircumflex #x0d4)
(define gdk:Otilde #x0d5)
(define gdk:Odiaeresis #x0d6)
(define gdk:multiply #x0d7)
(define gdk:Ooblique #x0d8)
(define gdk:Ugrave #x0d9)
(define gdk:Uacute #x0da)
(define gdk:Ucircumflex #x0db)
(define gdk:Udiaeresis #x0dc)
(define gdk:Yacute #x0dd)
(define gdk:THORN #x0de)
(define gdk:Thorn #x0de)
(define gdk:ssharp #x0df)
(define gdk:agrave #x0e0)
(define gdk:aacute #x0e1)
(define gdk:acircumflex #x0e2)
(define gdk:atilde #x0e3)
(define gdk:adiaeresis #x0e4)
(define gdk:aring #x0e5)
(define gdk:ae #x0e6)
(define gdk:ccedilla #x0e7)
(define gdk:egrave #x0e8)
(define gdk:eacute #x0e9)
(define gdk:ecircumflex #x0ea)
(define gdk:ediaeresis #x0eb)
(define gdk:igrave #x0ec)
(define gdk:iacute #x0ed)
(define gdk:icircumflex #x0ee)
(define gdk:idiaeresis #x0ef)
(define gdk:eth #x0f0)
(define gdk:ntilde #x0f1)
(define gdk:ograve #x0f2)
(define gdk:oacute #x0f3)
(define gdk:ocircumflex #x0f4)
(define gdk:otilde #x0f5)
(define gdk:odiaeresis #x0f6)
(define gdk:division #x0f7)
(define gdk:oslash #x0f8)
(define gdk:ugrave #x0f9)
(define gdk:uacute #x0fa)
(define gdk:ucircumflex #x0fb)
(define gdk:udiaeresis #x0fc)
(define gdk:yacute #x0fd)
(define gdk:thorn #x0fe)
(define gdk:ydiaeresis #x0ff)
(define gdk:Aogonek #x1a1)
(define gdk:breve #x1a2)
(define gdk:Lstroke #x1a3)
(define gdk:Lcaron #x1a5)
(define gdk:Sacute #x1a6)
(define gdk:Scaron #x1a9)
(define gdk:Scedilla #x1aa)
(define gdk:Tcaron #x1ab)
(define gdk:Zacute #x1ac)
(define gdk:Zcaron #x1ae)
(define gdk:Zabovedot #x1af)
(define gdk:aogonek #x1b1)
(define gdk:ogonek #x1b2)
(define gdk:lstroke #x1b3)
(define gdk:lcaron #x1b5)
(define gdk:sacute #x1b6)
(define gdk:caron #x1b7)
(define gdk:scaron #x1b9)
(define gdk:scedilla #x1ba)
(define gdk:tcaron #x1bb)
(define gdk:zacute #x1bc)
(define gdk:doubleacute #x1bd)
(define gdk:zcaron #x1be)
(define gdk:zabovedot #x1bf)
(define gdk:Racute #x1c0)
(define gdk:Abreve #x1c3)
(define gdk:Lacute #x1c5)
(define gdk:Cacute #x1c6)
(define gdk:Ccaron #x1c8)
(define gdk:Eogonek #x1ca)
(define gdk:Ecaron #x1cc)
(define gdk:Dcaron #x1cf)
(define gdk:Dstroke #x1d0)
(define gdk:Nacute #x1d1)
(define gdk:Ncaron #x1d2)
(define gdk:Odoubleacute #x1d5)
(define gdk:Rcaron #x1d8)
(define gdk:Uring #x1d9)
(define gdk:Udoubleacute #x1db)
(define gdk:Tcedilla #x1de)
(define gdk:racute #x1e0)
(define gdk:abreve #x1e3)
(define gdk:lacute #x1e5)
(define gdk:cacute #x1e6)
(define gdk:ccaron #x1e8)
(define gdk:eogonek #x1ea)
(define gdk:ecaron #x1ec)
(define gdk:dcaron #x1ef)
(define gdk:dstroke #x1f0)
(define gdk:nacute #x1f1)
(define gdk:ncaron #x1f2)
(define gdk:odoubleacute #x1f5)
(define gdk:udoubleacute #x1fb)
(define gdk:rcaron #x1f8)
(define gdk:uring #x1f9)
(define gdk:tcedilla #x1fe)
(define gdk:abovedot #x1ff)
(define gdk:Hstroke #x2a1)
(define gdk:Hcircumflex #x2a6)
(define gdk:Iabovedot #x2a9)
(define gdk:Gbreve #x2ab)
(define gdk:Jcircumflex #x2ac)
(define gdk:hstroke #x2b1)
(define gdk:hcircumflex #x2b6)
(define gdk:idotless #x2b9)
(define gdk:gbreve #x2bb)
(define gdk:jcircumflex #x2bc)
(define gdk:Cabovedot #x2c5)
(define gdk:Ccircumflex #x2c6)
(define gdk:Gabovedot #x2d5)
(define gdk:Gcircumflex #x2d8)
(define gdk:Ubreve #x2dd)
(define gdk:Scircumflex #x2de)
(define gdk:cabovedot #x2e5)
(define gdk:ccircumflex #x2e6)
(define gdk:gabovedot #x2f5)
(define gdk:gcircumflex #x2f8)
(define gdk:ubreve #x2fd)
(define gdk:scircumflex #x2fe)
(define gdk:kra #x3a2)
(define gdk:kappa #x3a2)
(define gdk:Rcedilla #x3a3)
(define gdk:Itilde #x3a5)
(define gdk:Lcedilla #x3a6)
(define gdk:Emacron #x3aa)
(define gdk:Gcedilla #x3ab)
(define gdk:Tslash #x3ac)
(define gdk:rcedilla #x3b3)
(define gdk:itilde #x3b5)
(define gdk:lcedilla #x3b6)
(define gdk:emacron #x3ba)
(define gdk:gcedilla #x3bb)
(define gdk:tslash #x3bc)
(define gdk:ENG #x3bd)
(define gdk:eng #x3bf)
(define gdk:Amacron #x3c0)
(define gdk:Iogonek #x3c7)
(define gdk:Eabovedot #x3cc)
(define gdk:Imacron #x3cf)
(define gdk:Ncedilla #x3d1)
(define gdk:Omacron #x3d2)
(define gdk:Kcedilla #x3d3)
(define gdk:Uogonek #x3d9)
(define gdk:Utilde #x3dd)
(define gdk:Umacron #x3de)
(define gdk:amacron #x3e0)
(define gdk:iogonek #x3e7)
(define gdk:eabovedot #x3ec)
(define gdk:imacron #x3ef)
(define gdk:ncedilla #x3f1)
(define gdk:omacron #x3f2)
(define gdk:kcedilla #x3f3)
(define gdk:uogonek #x3f9)
(define gdk:utilde #x3fd)
(define gdk:umacron #x3fe)
(define gdk:OE #x13bc)
(define gdk:oe #x13bd)
(define gdk:Ydiaeresis #x13be)
(define gdk:overline #x47e)
(define gdk:kana-fullstop #x4a1)
(define gdk:kana-openingbracket #x4a2)
(define gdk:kana-closingbracket #x4a3)
(define gdk:kana-comma #x4a4)
(define gdk:kana-conjunctive #x4a5)
(define gdk:kana-middledot #x4a5)
(define gdk:kana-WO #x4a6)
(define gdk:kana-a #x4a7)
(define gdk:kana-i #x4a8)
(define gdk:kana-u #x4a9)
(define gdk:kana-e #x4aa)
(define gdk:kana-o #x4ab)
(define gdk:kana-ya #x4ac)
(define gdk:kana-yu #x4ad)
(define gdk:kana-yo #x4ae)
(define gdk:kana-tsu #x4af)
(define gdk:kana-tu #x4af)
(define gdk:prolongedsound #x4b0)
(define gdk:kana-A #x4b1)
(define gdk:kana-I #x4b2)
(define gdk:kana-U #x4b3)
(define gdk:kana-E #x4b4)
(define gdk:kana-O #x4b5)
(define gdk:kana-KA #x4b6)
(define gdk:kana-KI #x4b7)
(define gdk:kana-KU #x4b8)
(define gdk:kana-KE #x4b9)
(define gdk:kana-KO #x4ba)
(define gdk:kana-SA #x4bb)
(define gdk:kana-SHI #x4bc)
(define gdk:kana-SU #x4bd)
(define gdk:kana-SE #x4be)
(define gdk:kana-SO #x4bf)
(define gdk:kana-TA #x4c0)
(define gdk:kana-CHI #x4c1)
(define gdk:kana-TI #x4c1)
(define gdk:kana-TSU #x4c2)
(define gdk:kana-TU #x4c2)
(define gdk:kana-TE #x4c3)
(define gdk:kana-TO #x4c4)
(define gdk:kana-NA #x4c5)
(define gdk:kana-NI #x4c6)
(define gdk:kana-NU #x4c7)
(define gdk:kana-NE #x4c8)
(define gdk:kana-NO #x4c9)
(define gdk:kana-HA #x4ca)
(define gdk:kana-HI #x4cb)
(define gdk:kana-FU #x4cc)
(define gdk:kana-HU #x4cc)
(define gdk:kana-HE #x4cd)
(define gdk:kana-HO #x4ce)
(define gdk:kana-MA #x4cf)
(define gdk:kana-MI #x4d0)
(define gdk:kana-MU #x4d1)
(define gdk:kana-ME #x4d2)
(define gdk:kana-MO #x4d3)
(define gdk:kana-YA #x4d4)
(define gdk:kana-YU #x4d5)
(define gdk:kana-YO #x4d6)
(define gdk:kana-RA #x4d7)
(define gdk:kana-RI #x4d8)
(define gdk:kana-RU #x4d9)
(define gdk:kana-RE #x4da)
(define gdk:kana-RO #x4db)
(define gdk:kana-WA #x4dc)
(define gdk:kana-N #x4dd)
(define gdk:voicedsound #x4de)
(define gdk:semivoicedsound #x4df)
(define gdk:kana-switch #xFF7E)
(define gdk:Arabic-comma #x5ac)
(define gdk:Arabic-semicolon #x5bb)
(define gdk:Arabic-question-mark #x5bf)
(define gdk:Arabic-hamza #x5c1)
(define gdk:Arabic-maddaonalef #x5c2)
(define gdk:Arabic-hamzaonalef #x5c3)
(define gdk:Arabic-hamzaonwaw #x5c4)
(define gdk:Arabic-hamzaunderalef #x5c5)
(define gdk:Arabic-hamzaonyeh #x5c6)
(define gdk:Arabic-alef #x5c7)
(define gdk:Arabic-beh #x5c8)
(define gdk:Arabic-tehmarbuta #x5c9)
(define gdk:Arabic-teh #x5ca)
(define gdk:Arabic-theh #x5cb)
(define gdk:Arabic-jeem #x5cc)
(define gdk:Arabic-hah #x5cd)
(define gdk:Arabic-khah #x5ce)
(define gdk:Arabic-dal #x5cf)
(define gdk:Arabic-thal #x5d0)
(define gdk:Arabic-ra #x5d1)
(define gdk:Arabic-zain #x5d2)
(define gdk:Arabic-seen #x5d3)
(define gdk:Arabic-sheen #x5d4)
(define gdk:Arabic-sad #x5d5)
(define gdk:Arabic-dad #x5d6)
(define gdk:Arabic-tah #x5d7)
(define gdk:Arabic-zah #x5d8)
(define gdk:Arabic-ain #x5d9)
(define gdk:Arabic-ghain #x5da)
(define gdk:Arabic-tatweel #x5e0)
(define gdk:Arabic-feh #x5e1)
(define gdk:Arabic-qaf #x5e2)
(define gdk:Arabic-kaf #x5e3)
(define gdk:Arabic-lam #x5e4)
(define gdk:Arabic-meem #x5e5)
(define gdk:Arabic-noon #x5e6)
(define gdk:Arabic-ha #x5e7)
(define gdk:Arabic-heh #x5e7)
(define gdk:Arabic-waw #x5e8)
(define gdk:Arabic-alefmaksura #x5e9)
(define gdk:Arabic-yeh #x5ea)
(define gdk:Arabic-fathatan #x5eb)
(define gdk:Arabic-dammatan #x5ec)
(define gdk:Arabic-kasratan #x5ed)
(define gdk:Arabic-fatha #x5ee)
(define gdk:Arabic-damma #x5ef)
(define gdk:Arabic-kasra #x5f0)
(define gdk:Arabic-shadda #x5f1)
(define gdk:Arabic-sukun #x5f2)
(define gdk:Arabic-switch #xFF7E)
(define gdk:Serbian-dje #x6a1)
(define gdk:Macedonia-gje #x6a2)
(define gdk:Cyrillic-io #x6a3)
(define gdk:Ukrainian-ie #x6a4)
(define gdk:Ukranian-je #x6a4)
(define gdk:Macedonia-dse #x6a5)
(define gdk:Ukrainian-i #x6a6)
(define gdk:Ukranian-i #x6a6)
(define gdk:Ukrainian-yi #x6a7)
(define gdk:Ukranian-yi #x6a7)
(define gdk:Cyrillic-je #x6a8)
(define gdk:Serbian-je #x6a8)
(define gdk:Cyrillic-lje #x6a9)
(define gdk:Serbian-lje #x6a9)
(define gdk:Cyrillic-nje #x6aa)
(define gdk:Serbian-nje #x6aa)
(define gdk:Serbian-tshe #x6ab)
(define gdk:Macedonia-kje #x6ac)
(define gdk:Byelorussian-shortu #x6ae)
(define gdk:Cyrillic-dzhe #x6af)
(define gdk:Serbian-dze #x6af)
(define gdk:numerosign #x6b0)
(define gdk:Serbian-DJE #x6b1)
(define gdk:Macedonia-GJE #x6b2)
(define gdk:Cyrillic-IO #x6b3)
(define gdk:Ukrainian-IE #x6b4)
(define gdk:Ukranian-JE #x6b4)
(define gdk:Macedonia-DSE #x6b5)
(define gdk:Ukrainian-I #x6b6)
(define gdk:Ukranian-I #x6b6)
(define gdk:Ukrainian-YI #x6b7)
(define gdk:Ukranian-YI #x6b7)
(define gdk:Cyrillic-JE #x6b8)
(define gdk:Serbian-JE #x6b8)
(define gdk:Cyrillic-LJE #x6b9)
(define gdk:Serbian-LJE #x6b9)
(define gdk:Cyrillic-NJE #x6ba)
(define gdk:Serbian-NJE #x6ba)
(define gdk:Serbian-TSHE #x6bb)
(define gdk:Macedonia-KJE #x6bc)
(define gdk:Byelorussian-SHORTU #x6be)
(define gdk:Cyrillic-DZHE #x6bf)
(define gdk:Serbian-DZE #x6bf)
(define gdk:Cyrillic-yu #x6c0)
(define gdk:Cyrillic-a #x6c1)
(define gdk:Cyrillic-be #x6c2)
(define gdk:Cyrillic-tse #x6c3)
(define gdk:Cyrillic-de #x6c4)
(define gdk:Cyrillic-ie #x6c5)
(define gdk:Cyrillic-ef #x6c6)
(define gdk:Cyrillic-ghe #x6c7)
(define gdk:Cyrillic-ha #x6c8)
(define gdk:Cyrillic-i #x6c9)
(define gdk:Cyrillic-shorti #x6ca)
(define gdk:Cyrillic-ka #x6cb)
(define gdk:Cyrillic-el #x6cc)
(define gdk:Cyrillic-em #x6cd)
(define gdk:Cyrillic-en #x6ce)
(define gdk:Cyrillic-o #x6cf)
(define gdk:Cyrillic-pe #x6d0)
(define gdk:Cyrillic-ya #x6d1)
(define gdk:Cyrillic-er #x6d2)
(define gdk:Cyrillic-es #x6d3)
(define gdk:Cyrillic-te #x6d4)
(define gdk:Cyrillic-u #x6d5)
(define gdk:Cyrillic-zhe #x6d6)
(define gdk:Cyrillic-ve #x6d7)
(define gdk:Cyrillic-softsign #x6d8)
(define gdk:Cyrillic-yeru #x6d9)
(define gdk:Cyrillic-ze #x6da)
(define gdk:Cyrillic-sha #x6db)
(define gdk:Cyrillic-e #x6dc)
(define gdk:Cyrillic-shcha #x6dd)
(define gdk:Cyrillic-che #x6de)
(define gdk:Cyrillic-hardsign #x6df)
(define gdk:Cyrillic-YU #x6e0)
(define gdk:Cyrillic-A #x6e1)
(define gdk:Cyrillic-BE #x6e2)
(define gdk:Cyrillic-TSE #x6e3)
(define gdk:Cyrillic-DE #x6e4)
(define gdk:Cyrillic-IE #x6e5)
(define gdk:Cyrillic-EF #x6e6)
(define gdk:Cyrillic-GHE #x6e7)
(define gdk:Cyrillic-HA #x6e8)
(define gdk:Cyrillic-I #x6e9)
(define gdk:Cyrillic-SHORTI #x6ea)
(define gdk:Cyrillic-KA #x6eb)
(define gdk:Cyrillic-EL #x6ec)
(define gdk:Cyrillic-EM #x6ed)
(define gdk:Cyrillic-EN #x6ee)
(define gdk:Cyrillic-O #x6ef)
(define gdk:Cyrillic-PE #x6f0)
(define gdk:Cyrillic-YA #x6f1)
(define gdk:Cyrillic-ER #x6f2)
(define gdk:Cyrillic-ES #x6f3)
(define gdk:Cyrillic-TE #x6f4)
(define gdk:Cyrillic-U #x6f5)
(define gdk:Cyrillic-ZHE #x6f6)
(define gdk:Cyrillic-VE #x6f7)
(define gdk:Cyrillic-SOFTSIGN #x6f8)
(define gdk:Cyrillic-YERU #x6f9)
(define gdk:Cyrillic-ZE #x6fa)
(define gdk:Cyrillic-SHA #x6fb)
(define gdk:Cyrillic-E #x6fc)
(define gdk:Cyrillic-SHCHA #x6fd)
(define gdk:Cyrillic-CHE #x6fe)
(define gdk:Cyrillic-HARDSIGN #x6ff)
(define gdk:Greek-ALPHAaccent #x7a1)
(define gdk:Greek-EPSILONaccent #x7a2)
(define gdk:Greek-ETAaccent #x7a3)
(define gdk:Greek-IOTAaccent #x7a4)
(define gdk:Greek-IOTAdiaeresis #x7a5)
(define gdk:Greek-OMICRONaccent #x7a7)
(define gdk:Greek-UPSILONaccent #x7a8)
(define gdk:Greek-UPSILONdieresis #x7a9)
(define gdk:Greek-OMEGAaccent #x7ab)
(define gdk:Greek-accentdieresis #x7ae)
(define gdk:Greek-horizbar #x7af)
(define gdk:Greek-alphaaccent #x7b1)
(define gdk:Greek-epsilonaccent #x7b2)
(define gdk:Greek-etaaccent #x7b3)
(define gdk:Greek-iotaaccent #x7b4)
(define gdk:Greek-iotadieresis #x7b5)
(define gdk:Greek-iotaaccentdieresis #x7b6)
(define gdk:Greek-omicronaccent #x7b7)
(define gdk:Greek-upsilonaccent #x7b8)
(define gdk:Greek-upsilondieresis #x7b9)
(define gdk:Greek-upsilonaccentdieresis #x7ba)
(define gdk:Greek-omegaaccent #x7bb)
(define gdk:Greek-ALPHA #x7c1)
(define gdk:Greek-BETA #x7c2)
(define gdk:Greek-GAMMA #x7c3)
(define gdk:Greek-DELTA #x7c4)
(define gdk:Greek-EPSILON #x7c5)
(define gdk:Greek-ZETA #x7c6)
(define gdk:Greek-ETA #x7c7)
(define gdk:Greek-THETA #x7c8)
(define gdk:Greek-IOTA #x7c9)
(define gdk:Greek-KAPPA #x7ca)
(define gdk:Greek-LAMDA #x7cb)
(define gdk:Greek-LAMBDA #x7cb)
(define gdk:Greek-MU #x7cc)
(define gdk:Greek-NU #x7cd)
(define gdk:Greek-XI #x7ce)
(define gdk:Greek-OMICRON #x7cf)
(define gdk:Greek-PI #x7d0)
(define gdk:Greek-RHO #x7d1)
(define gdk:Greek-SIGMA #x7d2)
(define gdk:Greek-TAU #x7d4)
(define gdk:Greek-UPSILON #x7d5)
(define gdk:Greek-PHI #x7d6)
(define gdk:Greek-CHI #x7d7)
(define gdk:Greek-PSI #x7d8)
(define gdk:Greek-OMEGA #x7d9)
(define gdk:Greek-alpha #x7e1)
(define gdk:Greek-beta #x7e2)
(define gdk:Greek-gamma #x7e3)
(define gdk:Greek-delta #x7e4)
(define gdk:Greek-epsilon #x7e5)
(define gdk:Greek-zeta #x7e6)
(define gdk:Greek-eta #x7e7)
(define gdk:Greek-theta #x7e8)
(define gdk:Greek-iota #x7e9)
(define gdk:Greek-kappa #x7ea)
(define gdk:Greek-lamda #x7eb)
(define gdk:Greek-lambda #x7eb)
(define gdk:Greek-mu #x7ec)
(define gdk:Greek-nu #x7ed)
(define gdk:Greek-xi #x7ee)
(define gdk:Greek-omicron #x7ef)
(define gdk:Greek-pi #x7f0)
(define gdk:Greek-rho #x7f1)
(define gdk:Greek-sigma #x7f2)
(define gdk:Greek-finalsmallsigma #x7f3)
(define gdk:Greek-tau #x7f4)
(define gdk:Greek-upsilon #x7f5)
(define gdk:Greek-phi #x7f6)
(define gdk:Greek-chi #x7f7)
(define gdk:Greek-psi #x7f8)
(define gdk:Greek-omega #x7f9)
(define gdk:Greek-switch #xFF7E)
(define gdk:leftradical #x8a1)
(define gdk:topleftradical #x8a2)
(define gdk:horizconnector #x8a3)
(define gdk:topintegral #x8a4)
(define gdk:botintegral #x8a5)
(define gdk:vertconnector #x8a6)
(define gdk:topleftsqbracket #x8a7)
(define gdk:botleftsqbracket #x8a8)
(define gdk:toprightsqbracket #x8a9)
(define gdk:botrightsqbracket #x8aa)
(define gdk:topleftparens #x8ab)
(define gdk:botleftparens #x8ac)
(define gdk:toprightparens #x8ad)
(define gdk:botrightparens #x8ae)
(define gdk:leftmiddlecurlybrace #x8af)
(define gdk:rightmiddlecurlybrace #x8b0)
(define gdk:topleftsummation #x8b1)
(define gdk:botleftsummation #x8b2)
(define gdk:topvertsummationconnector #x8b3)
(define gdk:botvertsummationconnector #x8b4)
(define gdk:toprightsummation #x8b5)
(define gdk:botrightsummation #x8b6)
(define gdk:rightmiddlesummation #x8b7)
(define gdk:lessthanequal #x8bc)
(define gdk:notequal #x8bd)
(define gdk:greaterthanequal #x8be)
(define gdk:integral #x8bf)
(define gdk:therefore #x8c0)
(define gdk:variation #x8c1)
(define gdk:infinity #x8c2)
(define gdk:nabla #x8c5)
(define gdk:approximate #x8c8)
(define gdk:similarequal #x8c9)
(define gdk:ifonlyif #x8cd)
(define gdk:implies #x8ce)
(define gdk:identical #x8cf)
(define gdk:radical #x8d6)
(define gdk:includedin #x8da)
(define gdk:includes #x8db)
(define gdk:intersection #x8dc)
(define gdk:union #x8dd)
(define gdk:logicaland #x8de)
(define gdk:logicalor #x8df)
(define gdk:partialderivative #x8ef)
(define gdk:function #x8f6)
(define gdk:leftarrow #x8fb)
(define gdk:uparrow #x8fc)
(define gdk:rightarrow #x8fd)
(define gdk:downarrow #x8fe)
(define gdk:blank #x9df)
(define gdk:soliddiamond #x9e0)
(define gdk:checkerboard #x9e1)
(define gdk:ht #x9e2)
(define gdk:ff #x9e3)
(define gdk:cr #x9e4)
(define gdk:lf #x9e5)
(define gdk:nl #x9e8)
(define gdk:vt #x9e9)
(define gdk:lowrightcorner #x9ea)
(define gdk:uprightcorner #x9eb)
(define gdk:upleftcorner #x9ec)
(define gdk:lowleftcorner #x9ed)
(define gdk:crossinglines #x9ee)
(define gdk:horizlinescan1 #x9ef)
(define gdk:horizlinescan3 #x9f0)
(define gdk:horizlinescan5 #x9f1)
(define gdk:horizlinescan7 #x9f2)
(define gdk:horizlinescan9 #x9f3)
(define gdk:leftt #x9f4)
(define gdk:rightt #x9f5)
(define gdk:bott #x9f6)
(define gdk:topt #x9f7)
(define gdk:vertbar #x9f8)
(define gdk:emspace #xaa1)
(define gdk:enspace #xaa2)
(define gdk:em3space #xaa3)
(define gdk:em4space #xaa4)
(define gdk:digitspace #xaa5)
(define gdk:punctspace #xaa6)
(define gdk:thinspace #xaa7)
(define gdk:hairspace #xaa8)
(define gdk:emdash #xaa9)
(define gdk:endash #xaaa)
(define gdk:signifblank #xaac)
(define gdk:ellipsis #xaae)
(define gdk:doubbaselinedot #xaaf)
(define gdk:onethird #xab0)
(define gdk:twothirds #xab1)
(define gdk:onefifth #xab2)
(define gdk:twofifths #xab3)
(define gdk:threefifths #xab4)
(define gdk:fourfifths #xab5)
(define gdk:onesixth #xab6)
(define gdk:fivesixths #xab7)
(define gdk:careof #xab8)
(define gdk:figdash #xabb)
(define gdk:leftanglebracket #xabc)
(define gdk:decimalpoint #xabd)
(define gdk:rightanglebracket #xabe)
(define gdk:marker #xabf)
(define gdk:oneeighth #xac3)
(define gdk:threeeighths #xac4)
(define gdk:fiveeighths #xac5)
(define gdk:seveneighths #xac6)
(define gdk:trademark #xac9)
(define gdk:signaturemark #xaca)
(define gdk:trademarkincircle #xacb)
(define gdk:leftopentriangle #xacc)
(define gdk:rightopentriangle #xacd)
(define gdk:emopencircle #xace)
(define gdk:emopenrectangle #xacf)
(define gdk:leftsinglequotemark #xad0)
(define gdk:rightsinglequotemark #xad1)
(define gdk:leftdoublequotemark #xad2)
(define gdk:rightdoublequotemark #xad3)
(define gdk:prescription #xad4)
(define gdk:minutes #xad6)
(define gdk:seconds #xad7)
(define gdk:latincross #xad9)
(define gdk:hexagram #xada)
(define gdk:filledrectbullet #xadb)
(define gdk:filledlefttribullet #xadc)
(define gdk:filledrighttribullet #xadd)
(define gdk:emfilledcircle #xade)
(define gdk:emfilledrect #xadf)
(define gdk:enopencircbullet #xae0)
(define gdk:enopensquarebullet #xae1)
(define gdk:openrectbullet #xae2)
(define gdk:opentribulletup #xae3)
(define gdk:opentribulletdown #xae4)
(define gdk:openstar #xae5)
(define gdk:enfilledcircbullet #xae6)
(define gdk:enfilledsqbullet #xae7)
(define gdk:filledtribulletup #xae8)
(define gdk:filledtribulletdown #xae9)
(define gdk:leftpointer #xaea)
(define gdk:rightpointer #xaeb)
(define gdk:club #xaec)
(define gdk:diamond #xaed)
(define gdk:heart #xaee)
(define gdk:maltesecross #xaf0)
(define gdk:dagger #xaf1)
(define gdk:doubledagger #xaf2)
(define gdk:checkmark #xaf3)
(define gdk:ballotcross #xaf4)
(define gdk:musicalsharp #xaf5)
(define gdk:musicalflat #xaf6)
(define gdk:malesymbol #xaf7)
(define gdk:femalesymbol #xaf8)
(define gdk:telephone #xaf9)
(define gdk:telephonerecorder #xafa)
(define gdk:phonographcopyright #xafb)
(define gdk:caret #xafc)
(define gdk:singlelowquotemark #xafd)
(define gdk:doublelowquotemark #xafe)
(define gdk:cursor #xaff)
(define gdk:leftcaret #xba3)
(define gdk:rightcaret #xba6)
(define gdk:downcaret #xba8)
(define gdk:upcaret #xba9)
(define gdk:overbar #xbc0)
(define gdk:downtack #xbc2)
(define gdk:upshoe #xbc3)
(define gdk:downstile #xbc4)
(define gdk:underbar #xbc6)
(define gdk:jot #xbca)
(define gdk:quad #xbcc)
(define gdk:uptack #xbce)
(define gdk:circle #xbcf)
(define gdk:upstile #xbd3)
(define gdk:downshoe #xbd6)
(define gdk:rightshoe #xbd8)
(define gdk:leftshoe #xbda)
(define gdk:lefttack #xbdc)
(define gdk:righttack #xbfc)
(define gdk:hebrew-doublelowline #xcdf)
(define gdk:hebrew-aleph #xce0)
(define gdk:hebrew-bet #xce1)
(define gdk:hebrew-beth #xce1)
(define gdk:hebrew-gimel #xce2)
(define gdk:hebrew-gimmel #xce2)
(define gdk:hebrew-dalet #xce3)
(define gdk:hebrew-daleth #xce3)
(define gdk:hebrew-he #xce4)
(define gdk:hebrew-waw #xce5)
(define gdk:hebrew-zain #xce6)
(define gdk:hebrew-zayin #xce6)
(define gdk:hebrew-chet #xce7)
(define gdk:hebrew-het #xce7)
(define gdk:hebrew-tet #xce8)
(define gdk:hebrew-teth #xce8)
(define gdk:hebrew-yod #xce9)
(define gdk:hebrew-finalkaph #xcea)
(define gdk:hebrew-kaph #xceb)
(define gdk:hebrew-lamed #xcec)
(define gdk:hebrew-finalmem #xced)
(define gdk:hebrew-mem #xcee)
(define gdk:hebrew-finalnun #xcef)
(define gdk:hebrew-nun #xcf0)
(define gdk:hebrew-samech #xcf1)
(define gdk:hebrew-samekh #xcf1)
(define gdk:hebrew-ayin #xcf2)
(define gdk:hebrew-finalpe #xcf3)
(define gdk:hebrew-pe #xcf4)
(define gdk:hebrew-finalzade #xcf5)
(define gdk:hebrew-finalzadi #xcf5)
(define gdk:hebrew-zade #xcf6)
(define gdk:hebrew-zadi #xcf6)
(define gdk:hebrew-qoph #xcf7)
(define gdk:hebrew-kuf #xcf7)
(define gdk:hebrew-resh #xcf8)
(define gdk:hebrew-shin #xcf9)
(define gdk:hebrew-taw #xcfa)
(define gdk:hebrew-taf #xcfa)
(define gdk:Hebrew-switch #xFF7E)
(define gdk:Thai-kokai #xda1)
(define gdk:Thai-khokhai #xda2)
(define gdk:Thai-khokhuat #xda3)
(define gdk:Thai-khokhwai #xda4)
(define gdk:Thai-khokhon #xda5)
(define gdk:Thai-khorakhang #xda6)
(define gdk:Thai-ngongu #xda7)
(define gdk:Thai-chochan #xda8)
(define gdk:Thai-choching #xda9)
(define gdk:Thai-chochang #xdaa)
(define gdk:Thai-soso #xdab)
(define gdk:Thai-chochoe #xdac)
(define gdk:Thai-yoying #xdad)
(define gdk:Thai-dochada #xdae)
(define gdk:Thai-topatak #xdaf)
(define gdk:Thai-thothan #xdb0)
(define gdk:Thai-thonangmontho #xdb1)
(define gdk:Thai-thophuthao #xdb2)
(define gdk:Thai-nonen #xdb3)
(define gdk:Thai-dodek #xdb4)
(define gdk:Thai-totao #xdb5)
(define gdk:Thai-thothung #xdb6)
(define gdk:Thai-thothahan #xdb7)
(define gdk:Thai-thothong #xdb8)
(define gdk:Thai-nonu #xdb9)
(define gdk:Thai-bobaimai #xdba)
(define gdk:Thai-popla #xdbb)
(define gdk:Thai-phophung #xdbc)
(define gdk:Thai-fofa #xdbd)
(define gdk:Thai-phophan #xdbe)
(define gdk:Thai-fofan #xdbf)
(define gdk:Thai-phosamphao #xdc0)
(define gdk:Thai-moma #xdc1)
(define gdk:Thai-yoyak #xdc2)
(define gdk:Thai-rorua #xdc3)
(define gdk:Thai-ru #xdc4)
(define gdk:Thai-loling #xdc5)
(define gdk:Thai-lu #xdc6)
(define gdk:Thai-wowaen #xdc7)
(define gdk:Thai-sosala #xdc8)
(define gdk:Thai-sorusi #xdc9)
(define gdk:Thai-sosua #xdca)
(define gdk:Thai-hohip #xdcb)
(define gdk:Thai-lochula #xdcc)
(define gdk:Thai-oang #xdcd)
(define gdk:Thai-honokhuk #xdce)
(define gdk:Thai-paiyannoi #xdcf)
(define gdk:Thai-saraa #xdd0)
(define gdk:Thai-maihanakat #xdd1)
(define gdk:Thai-saraaa #xdd2)
(define gdk:Thai-saraam #xdd3)
(define gdk:Thai-sarai #xdd4)
(define gdk:Thai-saraii #xdd5)
(define gdk:Thai-saraue #xdd6)
(define gdk:Thai-sarauee #xdd7)
(define gdk:Thai-sarau #xdd8)
(define gdk:Thai-sarauu #xdd9)
(define gdk:Thai-phinthu #xdda)
(define gdk:Thai-maihanakat-maitho #xdde)
(define gdk:Thai-baht #xddf)
(define gdk:Thai-sarae #xde0)
(define gdk:Thai-saraae #xde1)
(define gdk:Thai-sarao #xde2)
(define gdk:Thai-saraaimaimuan #xde3)
(define gdk:Thai-saraaimaimalai #xde4)
(define gdk:Thai-lakkhangyao #xde5)
(define gdk:Thai-maiyamok #xde6)
(define gdk:Thai-maitaikhu #xde7)
(define gdk:Thai-maiek #xde8)
(define gdk:Thai-maitho #xde9)
(define gdk:Thai-maitri #xdea)
(define gdk:Thai-maichattawa #xdeb)
(define gdk:Thai-thanthakhat #xdec)
(define gdk:Thai-nikhahit #xded)
(define gdk:Thai-leksun #xdf0)
(define gdk:Thai-leknung #xdf1)
(define gdk:Thai-leksong #xdf2)
(define gdk:Thai-leksam #xdf3)
(define gdk:Thai-leksi #xdf4)
(define gdk:Thai-lekha #xdf5)
(define gdk:Thai-lekhok #xdf6)
(define gdk:Thai-lekchet #xdf7)
(define gdk:Thai-lekpaet #xdf8)
(define gdk:Thai-lekkao #xdf9)
(define gdk:Hangul #xff31)
(define gdk:Hangul-Start #xff32)
(define gdk:Hangul-End #xff33)
(define gdk:Hangul-Hanja #xff34)
(define gdk:Hangul-Jamo #xff35)
(define gdk:Hangul-Romaja #xff36)
(define gdk:Hangul-Codeinput #xff37)
(define gdk:Hangul-Jeonja #xff38)
(define gdk:Hangul-Banja #xff39)
(define gdk:Hangul-PreHanja #xff3a)
(define gdk:Hangul-PostHanja #xff3b)
(define gdk:Hangul-SingleCandidate #xff3c)
(define gdk:Hangul-MultipleCandidate #xff3d)
(define gdk:Hangul-PreviousCandidate #xff3e)
(define gdk:Hangul-Special #xff3f)
(define gdk:Hangul-switch #xFF7E)
(define gdk:Hangul-Kiyeog #xea1)
(define gdk:Hangul-SsangKiyeog #xea2)
(define gdk:Hangul-KiyeogSios #xea3)
(define gdk:Hangul-Nieun #xea4)
(define gdk:Hangul-NieunJieuj #xea5)
(define gdk:Hangul-NieunHieuh #xea6)
(define gdk:Hangul-Dikeud #xea7)
(define gdk:Hangul-SsangDikeud #xea8)
(define gdk:Hangul-Rieul #xea9)
(define gdk:Hangul-RieulKiyeog #xeaa)
(define gdk:Hangul-RieulMieum #xeab)
(define gdk:Hangul-RieulPieub #xeac)
(define gdk:Hangul-RieulSios #xead)
(define gdk:Hangul-RieulTieut #xeae)
(define gdk:Hangul-RieulPhieuf #xeaf)
(define gdk:Hangul-RieulHieuh #xeb0)
(define gdk:Hangul-Mieum #xeb1)
(define gdk:Hangul-Pieub #xeb2)
(define gdk:Hangul-SsangPieub #xeb3)
(define gdk:Hangul-PieubSios #xeb4)
(define gdk:Hangul-Sios #xeb5)
(define gdk:Hangul-SsangSios #xeb6)
(define gdk:Hangul-Ieung #xeb7)
(define gdk:Hangul-Jieuj #xeb8)
(define gdk:Hangul-SsangJieuj #xeb9)
(define gdk:Hangul-Cieuc #xeba)
(define gdk:Hangul-Khieuq #xebb)
(define gdk:Hangul-Tieut #xebc)
(define gdk:Hangul-Phieuf #xebd)
(define gdk:Hangul-Hieuh #xebe)
(define gdk:Hangul-A #xebf)
(define gdk:Hangul-AE #xec0)
(define gdk:Hangul-YA #xec1)
(define gdk:Hangul-YAE #xec2)
(define gdk:Hangul-EO #xec3)
(define gdk:Hangul-E #xec4)
(define gdk:Hangul-YEO #xec5)
(define gdk:Hangul-YE #xec6)
(define gdk:Hangul-O #xec7)
(define gdk:Hangul-WA #xec8)
(define gdk:Hangul-WAE #xec9)
(define gdk:Hangul-OE #xeca)
(define gdk:Hangul-YO #xecb)
(define gdk:Hangul-U #xecc)
(define gdk:Hangul-WEO #xecd)
(define gdk:Hangul-WE #xece)
(define gdk:Hangul-WI #xecf)
(define gdk:Hangul-YU #xed0)
(define gdk:Hangul-EU #xed1)
(define gdk:Hangul-YI #xed2)
(define gdk:Hangul-I #xed3)
(define gdk:Hangul-J-Kiyeog #xed4)
(define gdk:Hangul-J-SsangKiyeog #xed5)
(define gdk:Hangul-J-KiyeogSios #xed6)
(define gdk:Hangul-J-Nieun #xed7)
(define gdk:Hangul-J-NieunJieuj #xed8)
(define gdk:Hangul-J-NieunHieuh #xed9)
(define gdk:Hangul-J-Dikeud #xeda)
(define gdk:Hangul-J-Rieul #xedb)
(define gdk:Hangul-J-RieulKiyeog #xedc)
(define gdk:Hangul-J-RieulMieum #xedd)
(define gdk:Hangul-J-RieulPieub #xede)
(define gdk:Hangul-J-RieulSios #xedf)
(define gdk:Hangul-J-RieulTieut #xee0)
(define gdk:Hangul-J-RieulPhieuf #xee1)
(define gdk:Hangul-J-RieulHieuh #xee2)
(define gdk:Hangul-J-Mieum #xee3)
(define gdk:Hangul-J-Pieub #xee4)
(define gdk:Hangul-J-PieubSios #xee5)
(define gdk:Hangul-J-Sios #xee6)
(define gdk:Hangul-J-SsangSios #xee7)
(define gdk:Hangul-J-Ieung #xee8)
(define gdk:Hangul-J-Jieuj #xee9)
(define gdk:Hangul-J-Cieuc #xeea)
(define gdk:Hangul-J-Khieuq #xeeb)
(define gdk:Hangul-J-Tieut #xeec)
(define gdk:Hangul-J-Phieuf #xeed)
(define gdk:Hangul-J-Hieuh #xeee)
(define gdk:Hangul-RieulYeorinHieuh #xeef)
(define gdk:Hangul-SunkyeongeumMieum #xef0)
(define gdk:Hangul-SunkyeongeumPieub #xef1)
(define gdk:Hangul-PanSios #xef2)
(define gdk:Hangul-KkogjiDalrinIeung #xef3)
(define gdk:Hangul-SunkyeongeumPhieuf #xef4)
(define gdk:Hangul-YeorinHieuh #xef5)
(define gdk:Hangul-AraeA #xef6)
(define gdk:Hangul-AraeAE #xef7)
(define gdk:Hangul-J-PanSios #xef8)
(define gdk:Hangul-J-KkogjiDalrinIeung #xef9)
(define gdk:Hangul-J-YeorinHieuh #xefa)
(define gdk:Korean-Won #xeff)
(define gdk:EcuSign #x20a0)
(define gdk:ColonSign #x20a1)
(define gdk:CruzeiroSign #x20a2)
(define gdk:FFrancSign #x20a3)
(define gdk:LiraSign #x20a4)
(define gdk:MillSign #x20a5)
(define gdk:NairaSign #x20a6)
(define gdk:PesetaSign #x20a7)
(define gdk:RupeeSign #x20a8)
(define gdk:WonSign #x20a9)
(define gdk:NewSheqelSign #x20aa)
(define gdk:DongSign #x20ab)
(define gdk:EuroSign #x20ac)
