/*
   XGBitmapImageRep.m

   NSBitmapImageRep for GNUstep GUI X/GPS Backend

   Copyright (C) 1996-1999 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@colorado.edu>
   Author:  Scott Christley <scottc@net-community.com>
   Date: Feb 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   Author:  Richard Frith-Macdonald <richard@brainstorm.co.uk>
   Date: Mar 1999

   This file is part of the GNUstep GUI X/GPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <stdlib.h>
#include <tiff.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <SharedX/xrtools.h>
#include <gnustep/xgps/XGContext.h>
#include <gnustep/xgps/XGGState.h>
#include <Foundation/NSDebug.h>
#include <Foundation/NSUserDefaults.h>

typedef struct _XGBitmapImageRep_struct
{
  BOOL		is_cached;
  RXImage	*xImage;
  Pixmap	xOpaquePixmap;

} XGBitmapImageRep_struct;

#define XCACHE (((XGBitmapImageRep_struct *)back_end_reserved)->is_cached)
#define XIMAGE (((XGBitmapImageRep_struct *)back_end_reserved)->xImage)
#define XPIXMAP (((XGBitmapImageRep_struct *)back_end_reserved)->xOpaquePixmap)

#define ALPHA_THRESHOLD 158

@implementation NSBitmapImageRep (Backend)

#ifdef HAVE_WRASTER_H
+ (NSArray *) _wrasterFileTypes
{
  int i;
  NSMutableArray *warray;
  char **types = RSupportedFileFormats();
  
  i = 0;
  warray = [NSMutableArray arrayWithCapacity: 4];
  while (types[i] != NULL)
    {
      NSString *type = [NSString stringWithCString: types[i]];
      type = [type lowercaseString];
      if (strcmp(types[i], "TIFF") != 0)
	{
	  [warray addObject: type];
	  if (strcmp(types[i], "JPEG") == 0)
	    [warray addObject: @"jpg"];
	  else if (strcmp(types[i], "PPM") == 0)
	    [warray addObject: @"pgm"];
	}
      i++;
    }
  return warray;
}

- _initFromWrasterFile: (NSString *)filename number: (int)imageNumber
{
  RImage *image;
  RContext *context;

  if (imageNumber > 0)
    {
      /* RLoadImage doesn't handle this very well */
      RELEASE(self);
      return nil;
    }

  NSDebugLLog(@"NSImage", @"Loading %@ using wraster routines", filename);
  context = [(XGContext *)GSCurrentContext() xrContext];
  image = RLoadImage(context, [filename cString], imageNumber);
  if (!image)
    {
      RELEASE(self);
      return nil;
    }
  [self initWithBitmapDataPlanes: &(image->data)
		pixelsWide: image->width
		pixelsHigh: image->height
		bitsPerSample: 8
	        samplesPerPixel: (image->format == RRGBAFormat) ? 4 : 3
		hasAlpha: (image->format == RRGBAFormat) ? YES : NO
		isPlanar: NO
		colorSpaceName: NSDeviceRGBColorSpace
		bytesPerRow: 0
		bitsPerPixel: 0];

  /* Make NSBitmapImageRep own the data */
  imageData = [NSMutableData dataWithBytesNoCopy: image->data
				    length: (bytesPerRow*image->height)];
  RETAIN(imageData);
  free(image);

  return self;
}
#endif /* HAVE_WRASTER_H */

- (Pixmap) xPixmapMask
{
  if (back_end_reserved == NULL)
    {
      back_end_reserved = malloc(sizeof(XGBitmapImageRep_struct));
      XCACHE = NO;
      XIMAGE = 0;
      XPIXMAP = 0;
    }

  if (XPIXMAP == None)
    {
      uint32 j, i;
      unsigned char	ialpha;
      unsigned char	*bData = [(NSBitmapImageRep *)self bitmapData];
      XGContext		*ctxt = (XGContext*)[XGContext currentContext];
      RContext		*xContext = (RContext *)[ctxt xrContext];
      Display		*xDisplay = xContext->dpy;
      Drawable		xDrawable;
      GC		gc;
      int               x, y;
      int		bitmapSize = (((int)size.width * (int)size.height)/8);
      char		*aData = calloc(1, bitmapSize);
      char		*cData = aData;

      DPScurrentgcdrawable(ctxt, (void**)&gc, (void**)&xDrawable, &x, &y);
      if (numColors == 4)
	{
	  for (j = 0; j < bitmapSize; j++)
	    {
	      for (i = 0; i < 8; i++)
		{
		  bData += 3;
		  ialpha = (unsigned short)((char)*bData++);
		  if (ialpha > ALPHA_THRESHOLD)
		    *cData |= (0x01 << i);
		}
	      cData++;
	    }
	}
      else
	{
	  for (j = 0; j < bitmapSize; j++)
	    *cData++ = 0xff;
	}

      XPIXMAP = XCreatePixmapFromBitmapData(xDisplay,xDrawable,(char *)aData,
	      (int)size.width, (int)size.height, 1L, 0L, 1);
      free(aData);
    }

  return XPIXMAP;
}

@end

