/* Private interface for GNU Objective-C coder object for use serializing
   Copyright (C) 1994, 1995, 1996 Free Software Foundation, Inc.
   
   Written by:  Andrew Kachites McCallum <mccallum@gnu.ai.mit.edu>
   Created: February 1996
   
   This file is part of the GNUstep Base Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */ 

#ifndef __CoderPrivate_h_GNUSTEP_BASE_INCLUDE
#define __CoderPrivate_h_GNUSTEP_BASE_INCLUDE

#include <base/Coder.h>
#include <base/CStreaming.h>

enum {
  CODER_OBJECT_NIL = 0, 
  CODER_OBJECT, 
  CODER_OBJECT_ROOT, 
  CODER_OBJECT_REPEATED, 
  CODER_OBJECT_FORWARD_REFERENCE,
  CODER_OBJECT_CLASS, 
  CODER_CLASS_NIL, 
  CODER_CLASS, 
  CODER_CLASS_REPEATED,
  CODER_CONST_PTR_NULL, 
  CODER_CONST_PTR, 
  CODER_CONST_PTR_REPEATED
};

#define DOING_ROOT_OBJECT (interconnect_stack_height != 0)

@interface Coder (Private)
- _initWithCStream: (id <CStreaming>) cs formatVersion: (int) version;
- (unsigned) _coderReferenceForObject: anObject;
@end

#define SIGNATURE_FORMAT_STRING \
@"GNU Objective C (%s %d.%d.%d) [%s %d]\n"

#define WRITE_SIGNATURE_FORMAT_ARGS \
STRINGIFY(GNUSTEP_BASE_PACKAGE_NAME), \
GNUSTEP_BASE_MAJOR_VERSION, \
GNUSTEP_BASE_MINOR_VERSION, \
GNUSTEP_BASE_SUBMINOR_VERSION, \
[self defaultDecoderClassname], \
format_version


#define NO_SEL_TYPES "none"

#endif /* __CoderPrivate_h_GNUSTEP_BASE_INCLUDE */
