/* drawing context using the Xlib library.

   Copyright (C) 1999 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Mar 1999
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

/* This is a reasonable attempt at mapping PostScript operators to an
   Xlib library implementation. Don't even begin to think that this
   is a full PostScript implementation, however. Many, many operators are
   not implemented or do not work as expected. Before using an operator,
   check to make sure it is implemented, otherwise the opstack may 
   be screwed up and nothing else will work!. No errors are returned
   for non-implmeneted operators.
*/

#ifndef _XGStreamContext_h_INCLUDE
#define _XGStreamContext_h_INCLUDE

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#include <wraster/wraster.h>

@class XGGState;

typedef enum {
  alloc_local, alloc_global
} alloc_mode_t;

@interface XGStreamContext : NSGraphicsContext
{
@public
  NSMutableArray	*opstack;
  NSMutableArray	*gstack;
  XGGState		*gstate;
  NSMutableArray	*glist;
  NSMutableArray	*fontid;
  FILE                  *gstream;

  RContext		*context;
  alloc_mode_t		alloc_mode;
}

+ (Display*) currentXDisplay;

- (Display*)xDisplay;
- (void)setXDisplay:(Display *)xdisplay;
- (Window)xDisplayRootWindow;
- (Window)xAppRootWindow;

- (RContext *) xrContext;
- (XGGState *) xrCurrentGState;
- (XGGState *) xrGStateWithIdent: (int)gst;

@end

#endif /* _XGStreamContext_h_INCLUDE */
