/*
   AFMFileFontInfo.h

   Private data of PXKFont class.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February 1997
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef __AFMFileFontInfo_h__
#define __AFMFileFontInfo_h__

#include <Foundation/NSMapTable.h>
#include <AppKit/NSFont.h>
#include "parseAFM.h"

@class NSDictionary;
@class NSMutableDictionary;
@class NSString;
@class NSFont;

typedef struct {
  NSGlyph glyph;
  NSSize advancement;
} tPairKerningInfo;

@interface AFMGlyphInfo : NSObject
{
  NSString* name;
  NSGlyph code;
  NSRect bbox;
  NSSize advancement;
  int lastKernPair;
  int numOfPairs;
  tPairKerningInfo* kerning;
}

+ (AFMGlyphInfo*)glyphFromAFMCharMetricInfo:(AFMCharMetricInfo*)metricInfo;

- copy;

- (NSString*)name;
- (NSGlyph)code;
- (NSRect)boundingRect;
- (NSSize)advancement;
- (BOOL)isEncoded;

- (void)transformUsingMatrix:(const float*)matrix;

- (void)incrementNumberOfKernPairs;
- (void)addPairKerningForGlyph:(NSGlyph)glyph advancement:(NSSize)advancement;
- (NSSize)advancementIfFollowedByGlyph:(NSGlyph)glyph
  isNominal:(BOOL*)nominal;

@end


@interface AFMFileFontInfo : NSObject
{
  NSMutableDictionary* afmDictionary;
  NSMapTable* glyphsByName;
  NSSize maximumAdvancement;
  NSSize minimumAdvancement;
  float widths[256];
  AFMGlyphInfo* glyphs[256];

  // metrics of the font
  NSString* fontName;
  NSString* familyName;
  float italicAngle;
  NSString* weight;
  float underlinePosition;
  float underlineThickness;
  float capHeight;
  float xHeight;
  float descender;
  float ascender;
  NSString* encodingScheme;
  NSRect fontBBox;
  BOOL isFixedPitch;
  BOOL isBaseFont;
}

+ (AFMFileFontInfo*)fontInfoForFont:(NSFont*)font
  afmFilename:(NSString*)fontFileName;
+ (AFMFileFontInfo*)createFontInfoFromAFMFileName:(NSString*)filename;

- (AFMFileFontInfo*)newTransformedFontInfoForMatrix:(const float*)matrix;
- (void)transformUsingMatrix:(const float*)matrix;
- copy;

- (NSDictionary*)afmDictionary;
- (NSRect)boundingRectForFont;
- (NSString*)displayName;
- (NSString*)familyName;
- (NSString*)fontName;
- (NSString*)encodingScheme;
- (float)ascender;
- (float)descender;
- (float)capHeight;
- (float)italicAngle;
- (NSSize)maximumAdvancement;
- (NSSize)minimumAdvancement;
- (float)underlinePosition;
- (float)underlineThickness;
- (float)xHeight;
- (BOOL)isFixedPitch;
- (BOOL)isBaseFont;
- (float*)widths;
- (NSSize)advancementForGlyph:(NSGlyph)aGlyph;
- (NSRect)boundingRectForGlyph:(NSGlyph)aGlyph;
- (BOOL)glyphIsEncoded:(NSGlyph)aGlyph;
- (NSGlyph)glyphWithName:(NSString*)glyphName;
- (NSPoint)positionOfGlyph:(NSGlyph)curGlyph
	   precededByGlyph:(NSGlyph)prevGlyph
		 isNominal:(BOOL*)nominal;
- (float)widthOfString:(NSString*)string;

@end

#endif /* __AFMFileFontInfo_h__ */
