/* 
   IMModelWindow.m

   Model window used for moving, sizing, and editing of visual components.

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: August 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: Sept 1998
   
   This file is part of the GNUstep Interface Modeller.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <AppKit/AppKit.h>

#include <Foundation/NSSet.h>

#include <gnustep/xraw/XR.h>

#include "IMModelWindow.h"
#include "IMModelView.h"
#include "Controller.h"


extern GC XRCurrentGC(void);
extern void XRSetGC(GC aGC);



@implementation IMModelWindow

//
// Class methods
//
+ (void)initialize
{
	if (self == [IMModelWindow class])
		{
      	NSDebugLog(@"Initialize IMModelWindow class\n");
		[self setVersion:1];								// Initial version
    	}
}

//
// Instance methods
//
- initWithContentRect:(NSRect)contentRect
	    	styleMask:(unsigned int)aStyle
	     	backing:(NSBackingStoreType)bufferingType
			defer:(BOOL)flag
	       	screen:aScreen
{
	selection = [[NSMutableSet alloc] init];

	return [super initWithContentRect: contentRect
				  styleMask: aStyle
				  backing: bufferingType
				  defer: flag
				  screen: aScreen];
}

- (NSMutableSet *)selectedElements
{
	return selection;
}

- (void)sendEvent:(NSEvent *)theEvent
{
NSApplication *theApp = [NSApplication sharedApplication];
GSContext* context = (GSContext*)[GSContext currentContext];
Display *xDisplay = [context xDisplay];
XColor c = [(XRColor *)[NSColor lightGrayColor] xColor];
XColor w = [(XRColor *)[NSColor whiteColor] xColor];
XColor b = [(XRColor *)[NSColor blackColor] xColor];
GC cGC; 
NSRect h = {{0,0},{6,6}}, oh = {{-999,0},{6,6}};
NSRect oldRect = {{0,0},{0,0}};	
										// intercept NSWindow's sendEvent: so
										// that controls within this window do
    									// not behave like controls while in
										// modelling mode
	if([(Controller *)[theApp delegate] testInterface])
		{
		[super sendEvent:theEvent];						// user has selected
		return;											// test interface mode
		}

	cGC = [(XRWindow*)self xGC];						// use win's default GC
														
	XSetFunction(xDisplay, cGC, GXxor);					// GXxor allows a
	XSetPlaneMask(xDisplay, cGC, AllPlanes);			// second draw op to
	XSetForeground(xDisplay, cGC, c.pixel ^ b.pixel);	// erase the effects
	XSetBackground(xDisplay, cGC, 0L);					// of the first 		
	XRSetGC(cGC);	
										// intercept NSWindow's sendEvent: so
	switch ([theEvent type])			// that controls within this window
    	{								// do not behave like controls
    	case NSLeftMouseDown:				
			{												// Left mouse down
			IMHandleType handle;
			NSPoint p = [theEvent locationInWindow];
			NSView *v = [content_view hitTestForHandle: &handle atPoint: p];

			if (v)									// if a handle was grabbed
	  			{									// do size tracking
				BOOL done, mouseUp;
				NSEvent *e;
				NSRect newf, old_frame = [v frame];
				NSPoint newp, diff, newd;
				NSSize old_size;
				unsigned int event_mask = NSLeftMouseDownMask | 
										NSLeftMouseUpMask | NSMouseMovedMask | 
										NSLeftMouseDraggedMask | 
										NSRightMouseDraggedMask;

	    		[self _captureMouse: self];					// capture mouse

				done = NO;
				newf = old_frame;
				diff.x = old_frame.origin.x - p.x;
				diff.y = old_frame.origin.y - p.y;	
				[[self contentView] lockFocus];
													// begin a modal loop in
			while (!done)							// order to track the mouse
				{
				e = [theApp nextEventMatchingMask:event_mask 
							untilDate:nil
							inMode:nil 
							dequeue:YES];
	
				if ([e type] == NSLeftMouseUp)			// If mouse went up
					done = YES;							// then we are done
				else	
					{
					newp = [e locationInWindow];
					switch (handle)
						{								// x origin is fixed
						case IMBottomRightHandle:		
							newd.x = newp.x - p.x;
							newd.y = newp.y - p.y;
							newf.origin.y = old_frame.origin.y + newd.y;
							newf.size.width = old_frame.size.width + newd.x;
							newf.size.height = old_frame.size.height - newd.y;
 
							h.origin = newf.origin;		// calc handle origin
							h.origin.x += newf.size.width;
							h.origin.y -= 6;
							break;

		     			case IMBottomMiddleHandle:			// width is fixed
							newd.y = newp.y - p.y;
							newf.origin.y = old_frame.origin.y + newd.y;
							newf.size.height = old_frame.size.height - newd.y;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x += ((newf.size.width/2) - 2);
							h.origin.y -= 6;
							break;

		      			case IMBottomLeftHandle:
							newd.x = newp.x - p.x;
							newd.y = newp.y - p.y;
							newf.origin.x = old_frame.origin.x + newd.x;
							newf.origin.y = old_frame.origin.y + newd.y;
							newf.size.width = old_frame.size.width - newd.x;
							newf.size.height = old_frame.size.height - newd.y;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x -= 6;
							h.origin.y -= 6;
							break;
														// origin is fixed
		      			case IMTopRightHandle:
							newf.size.width = newp.x - newf.origin.x;
							newf.size.height = newp.y - newf.origin.y;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x += newf.size.width;
							h.origin.y += newf.size.height;
							break;

		     	 		case IMTopMiddleHandle:
							newd.y = newp.y - p.y;
							newf.size.height = old_frame.size.height + newd.y;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x += ((newf.size.width/2) - 2);
							h.origin.y += newf.size.height;
							break;

		      			case IMTopLeftHandle:
							newd.x = newp.x - p.x;
							newd.y = newp.y - p.y;
							newf.origin.x = old_frame.origin.x + newd.x;
							newf.size.width = old_frame.size.width - newd.x;
							newf.size.height = old_frame.size.height + newd.y;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x -= 6;
							h.origin.y += newf.size.height;
							break;

		      			case IMRightMiddleHandle:
							newd.x = newp.x - p.x;
							newf.size.width = old_frame.size.width + newd.x;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x += newf.size.width;
							h.origin.y += ((newf.size.height/2) - 3);
							break;

		      			case IMLeftMiddleHandle:
							newd.x = newp.x - p.x;
							newf.origin.x = old_frame.origin.x + newd.x;
							newf.size.width = old_frame.size.width - newd.x;

							h.origin = newf.origin;		// calc handle origin
							h.origin.x -= 6;
							h.origin.y += ((newf.size.height/2) - 3);
							break;

		      		default:
						   NSLog(@"IMWindow internal error: unknown handle\n");
		      		}
														// highlight the handle 
														// which was grabbed
				XSetForeground(xDisplay, cGC, c.pixel ^ w.pixel);	
				if(oh.origin.x != -999)		
					NSRectFill(oh);					 
				NSRectFill(h);
				oh = h;										// save old rect
				XSetForeground(xDisplay, cGC, c.pixel ^ b.pixel);	


				if (newf.size.width < 0)
		      		newf.size.width = 0;
		    	if (newf.size.height < 0)
		      		newf.size.height = 0;
		    	[v setFrame: newf];
				}

//fprintf(stderr, " tracking loop\n");

			if(oldRect.size.width != 0)
				NSFrameRect(oldRect);	
								
			NSFrameRect(newf);									
			oldRect=newf;
			}
	    [[self contentView] unlockFocus];
	   
	    [self _releaseMouse: self];						 	// Release mouse

	    [self display];
	    [v display];
	    break;
		}

	if (!v)
		v = [content_view hitTest: p];

fprintf(stderr, " IMModelWindow\n");

	if (v && v != content_view)							// Do movement tracking
		{
	    BOOL done, mouseUp;
	    NSEvent *e;
	    NSRect new_frame, old_frame = [v frame];
	    NSPoint new_point, diff;
	    unsigned int event_mask = NSLeftMouseDownMask | NSLeftMouseUpMask |
	      							NSMouseMovedMask | NSLeftMouseDraggedMask 
	      							| NSRightMouseDraggedMask;

						// Determine the distance between the view's frame
						// and the mouse location, this will be used to 
						// determine the new view's frame when moving the mouse
	    diff.x = old_frame.origin.x - p.x;
	    diff.y = old_frame.origin.y - p.y;

	    [selection addObject: v];						// change the selection
	
	    [self _captureMouse: self];							// capture mouse

	    done = NO;
	    new_frame = old_frame;
	    while (!done)
			{
			e = [theApp nextEventMatchingMask:event_mask 
						untilDate:nil
			    		inMode:nil 
						dequeue:YES];
		
			if ([e type] == NSLeftMouseUp)					// If mouse went up
		  		done = YES;									// we are done
			else
		  		{
				new_point = [e locationInWindow];
				new_frame.origin.x = new_point.x + diff.x;
				new_frame.origin.y = new_point.y + diff.y;
				[v setFrame: new_frame];
				[v display];
		  		}
			}

	    [self _releaseMouse: self];							// Release mouse

	    [self display];
//	    [v display];
	    [[self contentView] display];
		}
	else
		fprintf(stderr, " IMModelWindow no v :\n");

			break;
			}					// catch but don't handle these in model mode
		case NSLeftMouseUp:								// Left mouse up
		case NSRightMouseDown:							// Right mouse down
		case NSRightMouseUp:							// Right mouse up
		case NSMouseMoved:								// Mouse moved
		case NSLeftMouseDragged:						// Left mouse dragged
		case NSRightMouseDragged:						// Right mouse dragged
		case NSMouseEntered:							// Mouse entered
		case NSMouseExited:								// Mouse exited
		case NSKeyDown:									// Key down
		case NSKeyUp:									// Key up
		case NSFlagsChanged:							// Flags changed
		case NSPeriodic:
			break;
		}
}

@end
