/* 
   XR.h

   High level include file for the GNUstep GUI X/RAW Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: April 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: June 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_XR
#define _GNUstep_H_XR

#include <gnustep/xraw/stdxr.h>
#include <AppKit/AppKit.h>

// Classes
@class XRApplication;
@class XRBitmapImageRep;
@class XRCachedImageRep;
@class XRColor;
@class XRCursor;
@class XRFont;
@class XRFontManager;
@class XRImage;
@class XRImageRep;
@class XRMenu;
@class XRMenuCell;
@class XRPopUpButton;
@class XRScreen;
@class XRView;
@class XRWindow;
@class XRWindowView;

// Class interfaces
#include <gnustep/xraw/XRApplication.h>
#include <gnustep/xraw/XRBitmapImageRep.h>
#include <gnustep/xraw/XRCachedImageRep.h>
#include <gnustep/xraw/XRColor.h>
#include <gnustep/xraw/XRCursor.h>
#include <gnustep/xraw/XRContext.h>
#include <gnustep/xraw/XRFont.h>
#include <gnustep/xraw/XRFontManager.h>
#include <gnustep/xraw/XRImage.h>
#include <gnustep/xraw/XRImageRep.h>
#include <gnustep/xraw/XRMenu.h>
#include <gnustep/xraw/XRMenuCell.h>
#include <gnustep/xraw/XRPopUpButton.h>
#include <gnustep/xraw/XRScreen.h>
#include <gnustep/xraw/XRStringDrawing.h>
#include <gnustep/xraw/XRView.h>
#include <gnustep/xraw/XRWindow.h>
#include <gnustep/xraw/XRWindowView.h>

#endif /* _GNUstep_H_XR */
