/* 
   PXKDrawingEngine.h

   The drawing engine encapsulates all windowing system
   dependencies.  This leads to a small performance drop,
   and to a substantial gain in reusability for the other
   elements of the kit.

   Reusing the other objects of the kit with other windowing
   systems should be only a matter of rewriting these functions.

   The drawing code is composed of a series of functions instead
   of being grouped in a class, because function calls are
   faster than method calls, and when we're drawing, speed is
   the name of the game.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: January 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_PXKDrawingEngine
#define _GNUstep_H_PXKDrawingEngine

#include <X11/Xlib.h>
#include <Foundation/NSGeometry.h>

@class PXKWindow;

/*
 * initializeDrawingSystem() is called once from the NSApplication object
 * when the application starts
 */

void initializeDrawingEngine(void);

void load_font(XFontStruct **font_info);

/* Private functions */
NSPoint intersectionPoint(NSRect lineA, NSRect lineB);
float dist2D(NSPoint a, NSPoint b);
NSRect clipLineToRect(NSRect aLine, NSRect aRect);

#endif /* _GNUstep_H_PXKDrawingEngine */



