/* 
   PXKView.m

   NSView for GNUstep GUI X/DPS Backend.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: January 1996
   Author:  Ovidiu Predescu <ovidiu@net-community.com>
   Date: May 1997
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <AppKit/NSColor.h>
#include <AppKit/PSMatrix.h>

#include <gnustep/xdps/PXKView.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include <gnustep/xdps/PXKWindow.h>

#include "general.h"

@implementation PSMatrix (BackendMethods)

- (void)set
{
  PSWConcatMatrix (matrix);
}

@end

@implementation PXKView

- (void)lockFocus
{
  PXKDPSContext *context = (PXKDPSContext*)[NSDPSContext currentContext];
  PXKWindow *w = (PXKWindow*)[self window];

  // Save the graphics state
  PSgsave();

  // Set the Xgcdrawable
  [context setXDrawable:w];

  [super lockFocus];

  [frameMatrix set];
  PSrectclip (0, 0, frame.size.width, frame.size.height);
  [boundsMatrix set];
}

- (void)unlockFocus
{
  [super unlockFocus];

  // Restore the graphics state
  PSgrestore();
}

#if 0
- (void)drawRect:(NSRect)rect
{
  NSColor *c = [[self window] backgroundColor];
  [c set];
  NSRectFill(rect);
}
#endif

@end
