/* 
   GarbageCollector.h

   Copyright (C) 1995, 1996, 1997 Ovidiu Predescu and Mircea Oancea.
   All rights reserved.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>

   This file is part of the Foundation Extensions Library.

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies and that both that
   copyright notice and this permission notice appear in supporting
   documentation.

   We disclaim all warranties with regard to this software, including all
   implied warranties of merchantability and fitness, in no event shall
   we be liable for any special, indirect or consequential damages or any
   damages whatsoever resulting from loss of use, data or profits, whether in
   an action of contract, negligence or other tortious action, arising out of
   or in connection with the use or performance of this software.
*/

#ifndef __GarbageCollector_h__
#define __GarbageCollector_h__

#import <Foundation/NSObject.h>

@interface GarbageCollector : NSObject

+ (void)addObject:(id)anObject;
+ (void)objectWillBeDeallocated:(id)anObject;

+ (void)collectGarbages;
+ (BOOL)isGarbageCollecting;

@end

#endif /* __GarbageCollector_h__ */
