

module test_decim();

   reg clock;
   initial clock = 1'b0;
   always #50 clock <= ~clock;

   reg reset;
   initial reset = 1'b1;
   initial #1000 reset = 1'b0;
   
   initial $dumpfile("test_hb.vcd");
   initial $dumpvars(0,test_hb);

   reg [15:0] i_in, q_in;
   //reg [15:0] i_in = 16'd39;
   //reg [15:0] q_in = 16'd127;
   
   wire [15:0] i_out, q_out;

   reg 	       strobe_in, strobe_out;
   reg 	       coeff_write;
   reg [15:0]  coeff_data;
   reg [4:0]   coeff_addr;
   
   
   halfband_decim halfband_decim 
     ( .clock(clock),.reset(reset),.enable(),.strobe_in(strobe_in),.strobe_out(strobe_out),
       .signal_in_i(i_in),.signal_in_q(q_in),.signal_out_i(i_out),.signal_out_q(q_out),
       .coeff_write(coeff_write),.coeff_wr_addr(coeff_addr),.coeff_ram_in(coeff_data)
       );
   
   initial strobe_out = 1'b0;
   initial strobe_in = 1'b0;

   always @(posedge strobe_out)
     if(i_out[15])
       $display("-%d  %d",65536-i_out,i_in);
     else
       $display("%d  %d",i_out,i_in);

   always
     begin
	repeat (12)
	  @(posedge clock);
	strobe_out <= #1 1'b1;
	@(posedge clock)
	  strobe_out <= #1 1'b0;
     end

   always
     begin
	repeat (2)
	  @(posedge strobe_out);
	strobe_in <= #1 1'b1;
	@(posedge clock)
	  strobe_in <= #1 1'b0;
     end
   
   
   //initial #1000000 $finish;
   
   initial
     begin
	@(negedge reset);
	repeat (25)
	  @(posedge strobe_in)
	    i_in <= #1 16'd0;
	@(posedge strobe_in)
	  i_in <= #1 16'd3277;
	repeat (25)
	  @(posedge strobe_in)
	    i_in <= #1 16'd0;
	@(posedge strobe_in)
	  i_in <= #1 16'd3277;
	repeat (25)
	  @(posedge strobe_in);
	$finish;
     end // initial begin
   

endmodule // test_hb
