#!/usr/bin/env python

from gnuradio import gr, eng_notation
from gnuradio import audio
from gnuradio import usrp
from gnuradio import blks
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import sys
import math

#
# return a gr.flow_graph
#
def build_graph (IF_freq, freqs, mid_freq):
    adc_rate = 64e6
    decim = 250
    quad_rate = adc_rate / decim               # 256 kHz
    audio_decimation = 8
    audio_rate = quad_rate / audio_decimation  # 32 kHz

    nchan = len (freqs)
    
    fg = gr.flow_graph ()
    
    # usrp is data source
    mux = 0xf0f0f0f0
    u = usrp.source_c (0, decim, nchan, mux)
    di = gr.deinterleave (gr.sizeof_gr_complex)
    
    fg.connect (u, di)
    
    # sound card as final sink
    audio_sink = audio.sink (int (audio_rate))

    i = 0
    for f in freqs:
        x = (mid_freq - f) + IF_freq
        print x
        u.set_rx_freq (i, -x)
        guts = blks.wfm_rcv (fg, quad_rate, audio_decimation)
        fg.connect ((di, i), guts)
        fg.connect (guts, (audio_sink, i))
        i += 1

    return fg


def main (args):
    parser = OptionParser (option_class=eng_option)
    (options, args) = parser.parse_args ()
    nargs = len (args)
    if nargs < 1 or nargs > 4:
        sys.stderr.write ('usage: wfm_rcv_many freq1...\n')
        sys.exit (1)

    freqs = [float(x) * 1e6 for x in args]
    freqs.sort ()

    min_freq = freqs[0]
    max_freq = freqs[-1]
    mid_freq = (min_freq + max_freq) / 2
    
    print eng_notation.num_to_str (mid_freq)
    
    # connect to RF front end
    rf_front_end = gr.microtune_4937_eval_board ()
    if not rf_front_end.board_present_p ():
        raise IOError, 'RF front end not found'

    # set front end gain
    rf_front_end.set_AGC (300)
    IF_freq = rf_front_end.get_output_freq ()

    rf_front_end.set_RF_freq (mid_freq)

    fg = build_graph (IF_freq, freqs, mid_freq)

    fg.start ()        # fork thread(s) and return
    raw_input ('Press Enter to quit: ')
    fg.stop ()

if __name__ == '__main__':
    main (sys.argv[1:])


