/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRUSRPSOURCE_H_
#define _GRUSRPSOURCE_H_

#include <GrSource.h>

class usrp_rx;

class GrUsrpSource : public GrSource
{
 private:
  int	 	 d_noutputs;
  usrp_rx	*d_usrp;

 public:
  /*!
   * usrp_rx_config specifies which and how many of the four possible
   * A/D streams will be read.  adc_clk_div specifies the divisor used
   * to divide down the on-board master clock (currently 125MHz, but
   * will be 120MHz).  Legal values are in the range 2 through 6,
   * inclusive.  The resulting clock drives the A/D converters.
   * decim_rate specifies the decimation rate through the CIC filter
   * associated with each rx channel in the FPGA.
   *
   * The output is N streams of VrComplex, where N is determined
   * by the usrp_rx_config value.  See usrp_config.h.
   */
  GrUsrpSource (int which_board, unsigned int usrp_rx_config,
		unsigned int adc_clk_div, unsigned int decim_rate);

  ~GrUsrpSource ();

  /*!
   * invoke constructor and return instance, or 0 if trouble
   */
  GrUsrpSource *make (int which_board, unsigned int usrp_rx_config,
		      unsigned int adc_clk_div, unsigned int decim_rate);

  virtual const char *name () { return "GrUsrpSource"; }
  virtual int work2 (VrSampleRange output, void *o[]);

  bool set_adc_clk_div (unsigned int div);
  bool set_decim_rate (unsigned int rate);
  bool set_rx_freq (int channel, double freq);
  bool set_ext_clk_div (unsigned int div);

  bool _set_decim_reg (unsigned int regval);	// diagnostics only

  // ACCESSORS

  double  get_oscillator_freq () const; 	// freq of master oscillator on board
  unsigned int get_adc_clk_div () const;
  unsigned int get_decim_rate () const;
  double get_rx_freq (int channel) const;
  unsigned int get_ext_clk_div () const;
};


#endif /* _GRUSRPSOURCE_H_ */

