/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_gr_fir_sysconfig.py
 * Any changes made to this file will be overwritten.
 */

#ifndef _GR_FIR_SYSCONFIG_H_
#define _GR_FIR_SYSCONFIG_H_

#include <vector>
#include <VrComplex.h>

#include <gr_fir_util.h>

/*!
 * \brief abstract base class for configuring the automatic selection of the
 * fastest gr_fir for your platform.
 *
 * This is used internally by gr_fir_util.
 */

class gr_fir_sysconfig {
public:
  virtual ~gr_fir_sysconfig ();

  virtual gr_fir_CCF *create_gr_fir_CCF (const std::vector<float> &taps) = 0;
  virtual gr_fir_FCC *create_gr_fir_FCC (const std::vector<VrComplex> &taps) = 0;
  virtual gr_fir_CCC *create_gr_fir_CCC (const std::vector<VrComplex> &taps) = 0;
  virtual gr_fir_FFF *create_gr_fir_FFF (const std::vector<float> &taps) = 0;
  virtual gr_fir_SCC *create_gr_fir_SCC (const std::vector<VrComplex> &taps) = 0;
  virtual gr_fir_SIS *create_gr_fir_SIS (const std::vector<short> &taps) = 0;
  virtual gr_fir_FSF *create_gr_fir_FSF (const std::vector<float> &taps) = 0;

  virtual void get_gr_fir_CCF_info (std::vector<gr_fir_CCF_info> *info) = 0;
  virtual void get_gr_fir_FCC_info (std::vector<gr_fir_FCC_info> *info) = 0;
  virtual void get_gr_fir_CCC_info (std::vector<gr_fir_CCC_info> *info) = 0;
  virtual void get_gr_fir_FFF_info (std::vector<gr_fir_FFF_info> *info) = 0;
  virtual void get_gr_fir_SCC_info (std::vector<gr_fir_SCC_info> *info) = 0;
  virtual void get_gr_fir_SIS_info (std::vector<gr_fir_SIS_info> *info) = 0;
  virtual void get_gr_fir_FSF_info (std::vector<gr_fir_FSF_info> *info) = 0;

};

/*
 * This returns the single instance of the appropriate derived class.
 * This function must be defined only once in the system, and should be defined 
 * in the platform specific code.
 */

gr_fir_sysconfig *gr_fir_sysconfig_singleton ();


#endif /* _GR_FIR_SYSCONFIG_H_ */
