/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrKeepOneInN.h>

GrKeepOneInN::GrKeepOneInN (int item_size, int N)
  : VrSigProc (1, item_size, item_size),
    d_item_size (item_size), d_N (N)
{
  assert (d_N >= 1);
}

GrKeepOneInN::~GrKeepOneInN ()
{
}

void
GrKeepOneInN::pre_initialize ()
{
  if (getSamplingFrequency () == 0.0)
    setSamplingFrequency (getInputSamplingFrequencyN (0) / d_N);
}

int 
GrKeepOneInN::forecast (VrSampleRange output, VrSampleRange inputs[])
{
  assert (numberInputs == 1);
  
  inputs[0].index = output.index * d_N;
  inputs[0].size = output.size * d_N;

  return 0;
}

int
GrKeepOneInN::work (VrSampleRange output, void *ao[],
		    VrSampleRange inputs[], void *ai[])
{
  char 	*out = ((char **) ao)[0];
  char  *in  = ((char **) ai)[0];

  for (unsigned int i = 0; i < output.size; i++){
    memcpy (out, in, d_item_size); 	// copy 1 item
    in  += d_item_size * d_N;
    out += d_item_size;			
  }

  return output.size;
}
