/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <microtune_eval_board.h>
#include <cstdio>
#include <cstdlib>


int
main (int argc, char **argv)
{
  int	which = 0;
  bool	ok = true;

  microtune_eval_board *eb = new microtune_eval_board (which);

  if (!eb->board_present_p ()){
    ok = false;
    fprintf (stderr, "microtune: eval board is NOT present\n");
  }

  if (!ok)
    exit (1);

  while (1){
    float	v;
#if 1
    for (v = 0; v <= 1000; v += 10){
      eb->set_AGC (v);
    }
#else
    for (v = 0; v < 4.0; v += 0.01){
      eb->set_RF_AGC_voltage (v);
      eb->set_IF_AGC_voltage (4.0 - v);
    }
#endif
  }
}
