/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/gnunet-setup-transport-tcp.c
 * @brief support for TCP configuration
 * @author Christian Grothoff
 */
#include "gnunet-setup.h"



/**
 * Callback function invoked for each interface found.
 *
 * @param cls closure
 * @param name name of the interface (can be NULL for unknown)
 * @param isDefault is this presumably the default interface
 * @param addr address of this interface (can be NULL for unknown or unassigned)
 * @param addrlen length of the address
 * @return GNUNET_OK to continue iteration, GNUNET_SYSERR to abort
 */
static int
ni_proc (void *cls,
	 const char *name,
	 int isDefault,
	 const struct sockaddr *addr,
	 socklen_t addrlen)
{
  GtkListStore *ls = cls;
  GtkTreeIter iter;
  GtkComboBox *cb;
  char new_text[INET6_ADDRSTRLEN];
  const struct sockaddr_in *v4;
  const struct sockaddr_in6 *v6;
  gchar *at;

  switch (addr->sa_family)
    {
    case AF_INET:
      v4 = (const struct sockaddr_in*) addr;
      if (NULL == inet_ntop (AF_INET,
			     &v4->sin_addr,
			     new_text,
			     sizeof (new_text)))
	{
	  GNUNET_break (0);
	  return GNUNET_OK;
	}
      break;
    case AF_INET6:
      v6 = (const struct sockaddr_in6*) addr;
      if (NULL == inet_ntop (AF_INET6,
			     &v6->sin6_addr,
			     new_text,
			     sizeof (new_text)))
	{
	  GNUNET_break (0);
	  return GNUNET_OK;
	}
      break;
    default:
      /* unsupported af */
      return GNUNET_OK;
    }
  gtk_list_store_insert_before (ls, &iter, NULL);
  gtk_list_store_set (ls,
		      &iter,
		      0, new_text,
		      -1);
  if (isDefault)
    {
      cb = GTK_COMBO_BOX (gtk_builder_get_object (builder, 
						  "GNUNET_setup_transport_tcp_internal_ip_comboboxentry"));
      at = gtk_combo_box_get_active_text (cb);
      if ( (at == NULL) ||
	   (strlen (at) == 0) )
	gtk_combo_box_set_active_iter (cb, &iter);
      g_free (at);
    }
  return GNUNET_OK;
}



void
GNUNET_setup_transport_tcp_internal_ip_comboboxentry_realize_cb (GtkWidget *widget,
								 gpointer user_data)
{
  GtkListStore *ls;

  ls = GTK_LIST_STORE (gtk_builder_get_object (builder, 
					       "GNUNET_setup_transport_tcp_internal_ip_liststore"));
  if (ls == NULL)
    {
      GNUNET_break (0);
      return;
    }
  GNUNET_OS_network_interfaces_list (&ni_proc,
				     ls);
}


void
GNUNET_setup_transport_tcp_autoconfig_button_clicked_cb ()
{
  GNUNET_break (0); /* not implemented */
}

void
GNUNET_setup_transport_tcp_test_button_clicked_cb ()
{
  GNUNET_break (0); /* not implemented */
}


/* end of gnunet-setup-transport-tcp.c */

