/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/peerinfo.c
 * @brief Updates the peerinfo view
 * @author Christian Grothoff
 */
#include "peerinfo.h"

/**
 * Function called for peers that we know about.
 *
 * @param cls closure
 * @param peer id of the peer, NULL for last call
 * @param hello hello message for the peer (can be NULL)
 * @param trust amount of trust we have in the peer
 */
void
GNUNET_GTK_peerinfo_processor (void *cls,
			       const struct GNUNET_PeerIdentity * peer,
			       const struct GNUNET_HELLO_Message * hello,
			       uint32_t trust)
{
  GtkListStore *ls;
  GtkTreeModel *tm;
  GtkTreeIter iter;
  int found;
  char *pid;
  const char *npid;
  struct GNUNET_CRYPTO_HashAsciiEncoded enc;

  GNUNET_CRYPTO_hash_to_enc (&peer->hashPubKey,
			     &enc);
  npid = (const char*) &enc;
  ls = GTK_LIST_STORE (GNUNET_GTK_get_main_window_object ("GNUNET_GTK_peer_info_list_store"));
  tm = GTK_TREE_MODEL (ls);
  found = GNUNET_NO;
  if (TRUE == gtk_tree_model_get_iter_first (tm, &iter))
    {
      do
        {
	  pid = NULL;
          gtk_tree_model_get (tm,
                              &iter, 
			      0, &pid, -1);
          if (pid != NULL)
            {
              if (0 == strcmp (pid, npid))
		{
		  found = GNUNET_YES;
		  break;
                }
	    }
        }
      while ( (found == GNUNET_NO) &&
	      (TRUE == gtk_tree_model_iter_next (tm,
						 &iter)));
    }
  if (found == GNUNET_NO)
    gtk_list_store_append (ls, &iter);
  gtk_list_store_set (ls,
                      &iter,
                      0, npid,
                      1, trust,
                      2, 0 /* number of known addresses */,
                      3, "" /* country name */,
		      4, NULL /* country flag */,
		      -1);   
}

/* end of peerinfo.c */
