/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/download.c
 * @brief functions for downloading
 * @author Christian Grothoff
 */

#include "download.h"
#include "fs_event_handler.h"

void
GNUNET_GTK_open_download_as_dialog (struct DownloadContext *dc)
{
  GtkWidget *ad;
  GtkBuilder *builder;
  struct GNUNET_FS_Handle *fs;
  uint64_t len;
  enum GNUNET_FS_DownloadOptions opt;
  uint32_t anonymity;
  struct DownloadEntry *de;

  builder = GNUNET_GTK_get_new_builder ("download_as.glade");
  if (builder == NULL)
    {
      if (dc->rr != NULL)
	gtk_tree_row_reference_free (dc->rr);
      GNUNET_free_non_null (dc->mime);
      GNUNET_free_non_null (dc->filename);
      GNUNET_FS_uri_destroy (dc->uri);
      GNUNET_free (dc);
      return;
    }
  ad = GTK_WIDGET (gtk_builder_get_object (builder,
					   "GNUNET_GTK_save_as_dialog"));
  if (dc->filename != NULL)
    {
      char buf[1024];
      if (NULL != getcwd (buf, sizeof(buf)))
	{
	  if (strlen (buf) + strlen (dc->filename) + 2 < sizeof(buf))
	    {
	      strcat (buf, DIR_SEPARATOR_STR);
	      strcat (buf, dc->filename);
	    }
	  /* sadly, this does not quite work in current GTK, GTK just
	     ignores the filename if the file does not yet exist */
	  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (ad),
					 buf);
	}
    }
  if (GTK_RESPONSE_OK != gtk_dialog_run (GTK_DIALOG (ad)))
    {
      gtk_widget_destroy (ad);
      g_object_unref (G_OBJECT (builder));
      if (dc->rr != NULL)
	gtk_tree_row_reference_free (dc->rr);
      GNUNET_free_non_null (dc->mime);
      GNUNET_free_non_null (dc->filename);
      GNUNET_FS_uri_destroy (dc->uri);
      GNUNET_free (dc);
      return;
    }
  GNUNET_free_non_null (dc->filename);
  dc->filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(ad));
  fs = GNUNET_GTK_get_fs_handle ();
  opt = GNUNET_FS_DOWNLOAD_OPTION_NONE;
  if (dc->is_recursive)
    opt |= GNUNET_FS_DOWNLOAD_OPTION_RECURSIVE;
  anonymity = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gtk_builder_get_object (builder,
										  "GNUNET_GTK_save_as_dialog_anonymity_spin_button")));
  len = GNUNET_FS_uri_chk_get_file_size (dc->uri);
  gtk_widget_destroy (ad);
  g_object_unref (G_OBJECT (builder));
  de = GNUNET_malloc (sizeof (struct DownloadEntry));
  de->uri = dc->uri;
  de->meta = dc->meta;
  if (dc->rr != NULL)
    {
      de->rr = dc->rr;
      de->ts = GTK_TREE_STORE (gtk_tree_row_reference_get_model (dc->rr));
    }
  if (dc->sr != NULL)
    {
      GNUNET_break (NULL !=
		    GNUNET_FS_download_start_from_search (fs,
							  dc->sr,
							  dc->filename,
							  NULL /* tempname */,
							  0 /* offset */,
							  len,
							  anonymity,
							  opt,
							  de));
    }
  else
    {
      GNUNET_break (NULL !=
		    GNUNET_FS_download_start (fs,
					      dc->uri,
					      NULL /* meta */,
					      dc->filename,
					      NULL /* tempname */,
					      0 /* offset */,
					      len,
					      anonymity,
					      opt,
					      de,
					      NULL /* parent download ctx */));
    }
  GNUNET_free (dc);
}

/* end of download.c */
