/*
     This file is part of GNUnet
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/include/gnunetgtk_common.h
 * @author Igor Wronsky
 * @author Christian Grothoff
 */

#ifndef GNUNET_GTK_COMMON_H
#define GNUNET_GTK_COMMON_H

#include <gtk/gtk.h>
#include <gtk/gtktext.h>
#include <glade/glade.h>

#define GNUNET_GTK_DEBUG_GTK 0

#if GNUNET_GTK_DEBUG_GTK
#define GNUNET_GTK_DEBUG_BEGIN() fprintf(stderr, "BEGIN of %s\n", __FUNCTION__)
#define GNUNET_GTK_DEBUG_MARK() fprintf(stderr, "AT %s:%d\n", __FILE__, __LINE__)
#define GNUNET_GTK_DEBUG_END() fprintf(stderr, "END of %s\n", __FUNCTION__)
#else
#define GNUNET_GTK_DEBUG_BEGIN()
#define GNUNET_GTK_DEBUG_MARK()
#define GNUNET_GTK_DEBUG_END()
#endif


void GNUNET_GTK_initialize_common_library (const char * ccfn,
					   struct GNUNET_GC_Configuration
                                           *cfg, void *callback);

void GNUNET_GTK_shutdown_plugins (void);

void GNUNET_GTK_shutdown_common_library (void);

const char *GNUNET_GTK_get_client_config_filename (void);

/**
 * Get the name of the main glade file for gnunet-gtk.
 */
const char *GNUNET_GTK_get_glade_filename (void);

/**
 * Get the GladeXML for the main window of gnunet-gtk.
 */
GladeXML *GNUNET_GTK_get_main_glade_XML (void);

/**
 * Get the GtkIconFactory for gnunet-gtk
 */
GtkIconFactory *GNUNET_GTK_get_iconFactory (void);

/**
 * Get the GtkStatusIcon for the tray icon (if GTK >= 2.10)
 */
#if GTK_CHECK_VERSION(2,10,0)
GtkStatusIcon *GNUNET_GTK_get_trayIcon (void);
#endif

/**
 * Appends a message to the info window
 * @param doPopup if GNUNET_YES, the info window will
 *   be opened
 */
void GNUNET_GTK_show_info_message (const char *format, ...);

/**
 * Appends a log entry to the info window
 * and update the statusbar to show this
 * message (until the next call).
 *
 * @param txt the log entry
 */
void GNUNET_GTK_add_log_entry (const char *txt, ...);

struct GNUNET_GE_Context *GNUNET_GTK_create_gtk_logger (GNUNET_GE_KIND mask);

void GNUNET_GTK_shutdown_logger ();

#define GNUNET_GTK_NOTIFY_LEVEL_LOW 0
#define GNUNET_GTK_NOTIFY_LEVEL_NORMAL 1
#define GNUNET_GTK_NOTIFY_LEVEL_CRITICAL 2

typedef enum
{
  GNUNET_GTK_STATUS_NODAEMON,
  GNUNET_GTK_STATUS_DAEMONUP,
  GNUNET_GTK_STATUS_DISCONNECTED,
  GNUNET_GTK_STATUS_CONNECTED,
  GNUNET_GTK_STATUS_UNKNOWN
} GNUNET_GTK_STATUS;

/*
 * Update the status bar indicator and the status icon
 * about daemon and connexions status.
 *
 * @param status current status of gnunetd
 * @param peers number of connected peers (with GNUNET_GTK_STATUS_CONNECTED)
 */
void
GNUNET_GTK_display_daemon_status (GNUNET_GTK_STATUS status,
                                  unsigned long long peers);

/**
 * Sends a message to libnotify
 */
void GNUNET_GTK_notify (int type, const char *message, ...);

/**
 * Call a callback function from the mainloop/main thread ("SaveCall").
 * Since GTK doesn't work with multi-threaded applications
 * all GTK operations have to be done in the main thread
 */
void *GNUNET_GTK_save_call (GNUNET_ThreadMainFunction func, void *arg);

/**
 * Run the given "cb" function and save calls
 * in parallel (used within the event loop to
 * keep save calls going while something else
 * happens).
 */
void *GNUNET_GTK_run_with_save_calls (GNUNET_ThreadMainFunction cb,
                                      void *arg);

/**
 * Bind handlers defined by the various
 * plugins to the signals defined by the
 * Glade XML.
 */
void GNUNET_GTK_connect_glade_with_plugins (GladeXML * xml);

/**
 * Validate that a string is a Utf-8 string.
 * If validation fails, msg is freed and a valid
 * Utf-8 string is returned.
 */
char *GNUNET_GTK_validate_utf8 (char *msg);

/**
 * Gtk callback to save the main window state (tray icon use)
 */
void GNUNET_GTK_save_main_window_state (GtkWidget * main_window,
                                        GdkEventWindowState * event,
                                        gpointer user_data);

/**
 * Get the last main window state when restoring (tray icon use)
 */
GdkWindowState GNUNET_GTK_get_main_window_state (void);

void GNUNET_GTK_main_quit (void);

/**
 * Identical to "gtk_tree_selection_selected_foreach",
 * except that modifications of the underlying model
 * during the iteration are tolerated.
 */
void GNUNET_GTK_tree_selection_selected_foreach (GtkTreeSelection * selection,
                                                 GtkTreeSelectionForeachFunc
                                                 func, gpointer data);

/**
 * Identical to "gtk_tree_model_foreach",
 * except that modifications of the underlying model
 * during the iteration are tolerated.
 */
void GNUNET_GTK_tree_model_foreach (GtkTreeModel * model,
                                    GtkTreeSelectionForeachFunc func,
                                    gpointer data);


struct GNUNET_CronManager *GNUNET_GTK_get_cron_manager (void);


GtkWidget *GNUNET_GTK_extract_main_widget_from_window (GladeXML * xml,
                                                       const char
                                                       *windowName);




#endif
