/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

#ifndef FS_HELPER_H
#define FS_HELPER_H

/**
 * @file src/plugins/fs/helper.h
 * @brief helper functions (parsing)
 * @author Christian Grothoff
 */

/* Create the tab label and icon,
 * adding a little button to close the search
 * This function is a modified version of an Epiphany/Gedit code,
 * part of this work is copyrighted (GPL license) by its authors.
 *
 * @param the title of the new label
 * @returns the created widget to pack into the page header
 */
GtkWidget *buildSearchTabLabel (GtkWidget * searchPage, const char *title);


GtkWidget *makeSearchResultFrame (struct GNUNET_GC_Configuration *cfg,
                                  GtkWidget ** treeview,
                                  GtkWidget ** anonSpin);

/**
 * Parse a time given in the form
 * "XX seconds yy days zz months".
 *
 * @param val set to the computed time
 * @return GNUNET_OK on success, GNUNET_SYSERR on error
 */
int parseTime (const char *t, GNUNET_Int32Time * val);

#endif
