/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/collection.c
 * @brief code for operations with collections
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "fs.h"
#include "helper.h"
#include "meta.h"
#include "collection.h"
#include <GNUnet/gnunet_collection_lib.h>
#include <extractor.h>

static GladeXML *metaXML;

void
on_collectionDialogMetaDataAddButton_clicked_fs (gpointer dummy,
                                                 GtkWidget * uploadButton)
{
  handleMetaDataListUpdate (metaXML,
                            "collectionMetaDataTypeComboBox",
                            "collectionMetaDataValueEntry",
                            "collectionMetaDataTreeView");
}

void
on_collectionMetaDataValueEntry_activate_fs (GtkWidget *
                                             collectionMetaDataValueEntry,
                                             gpointer dummy)
{
  const char *input;

  input = gtk_entry_get_text (GTK_ENTRY (collectionMetaDataValueEntry));
  if ((input == NULL) || (strlen (input) == 0))
    return;
  handleMetaDataListUpdate (metaXML,
                            "collectionMetaDataTypeComboBox",
                            "collectionMetaDataValueEntry",
                            "collectionMetaDataTreeView");
}


void
createCollection_clicked_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  GtkWidget *w;
  GtkWidget *dialog;
  GtkWidget *spin;
  struct GNUNET_MetaData *meta;
  struct GNUNET_ECRS_URI *root;

  metaXML
    = glade_xml_new (GNUNET_GTK_get_glade_filename (),
                     "createCollectionDialog", PACKAGE_NAME);
  GNUNET_GTK_connect_glade_with_plugins (metaXML);
  dialog = glade_xml_get_widget (metaXML, "createCollectionDialog");
  createMetaDataListTreeView (metaXML,
                              "collectionMetaDataTreeView", NULL, NULL);
  createMetaTypeComboBox (metaXML, "collectionMetaDataTypeComboBox");
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      meta = getMetaDataFromList (metaXML,
                                  "collectionMetaDataTreeView", NULL);
      spin = glade_xml_get_widget (metaXML, "collectionAnonymityLevel");
      root = NULL;
      if (GNUNET_OK == GNUNET_CO_collection_start (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin)), 1000,     /* priority */
                                                   meta))
        {
          w =
            glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                                  "createCollection");
          gtk_widget_set_sensitive (w, FALSE);
          w =
            glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                                  "deleteCollection");
          gtk_widget_set_sensitive (w, TRUE);
        }
      else
        {
          GtkWidget *dialog;

          dialog = gtk_message_dialog_new
            (NULL,
             GTK_DIALOG_MODAL,
             GTK_MESSAGE_ERROR,
             GTK_BUTTONS_CLOSE,
             _("Failed to start collection (consult logs)."));
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
        }
      GNUNET_meta_data_destroy (meta);
    }
  gtk_widget_destroy (dialog);
  UNREF (metaXML);
  metaXML = NULL;
}

void
deleteCollection_clicked_fs (GtkWidget * dummy1, GtkWidget * dummy2)
{
  GtkWidget *w;

  if (GNUNET_OK == GNUNET_CO_collection_stop ())
    {
      w =
        glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                              "createCollection");
      gtk_widget_set_sensitive (w, TRUE);
      w =
        glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                              "deleteCollection");
      gtk_widget_set_sensitive (w, FALSE);
      GNUNET_GTK_show_info_message (_("Collection stopped.\n"));
    }
  else
    {
      GNUNET_GTK_show_info_message (_
                                    ("Failed to stop collection (consult logs).\n"));
    }
}

void
fs_collection_start ()
{
  GtkWidget *w;
  struct GNUNET_MetaData *h;

  h = GNUNET_CO_collection_get_name ();
  if (NULL != h)
    {
      w =
        glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                              "createCollection");
      GNUNET_meta_data_destroy (h);
    }
  else
    w =
      glade_xml_get_widget (GNUNET_GTK_get_main_glade_XML (),
                            "deleteCollection");
  gtk_widget_set_sensitive (w, FALSE);
}

/* end of collection.c */
