/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/meta.h
 * @brief code for dealing with meta and keyword tree views
 * @author Christian Grothoff
 */

#ifndef GTK_META_H
#define GTK_META_H

#include "gnunetgtk_common.h"
#include <GNUnet/gnunet_ecrs_lib.h>

void createMetaDataListTreeView (GladeXML * xml,
                                 const char *name,
                                 const char *previewName,
                                 const struct GNUNET_MetaData *init);

void createKeywordListTreeView (GladeXML * xml,
                                const char *name,
                                const struct GNUNET_ECRS_URI *init);

void createMetaTypeComboBox (GladeXML * xml, const char *name);

void handleKeywordListUpdate (GladeXML * xml,
                              const char *inputLineName,
                              const char *keywordListName);

void handleMetaDataListUpdate (GladeXML * xml,
                               const char *typeInputLineName,
                               const char *valueInputLineName,
                               const char *metaDataListName);

void handleListRemove (GladeXML * xml, const char *listName);

struct GNUNET_MetaData *getMetaDataFromList (GladeXML * xml,
                                             const char *name,
                                             const char *preview);

struct GNUNET_ECRS_URI *getKeywordURIFromList (GladeXML * xml,
                                               const char *name);

char *updateIntervalToString (GNUNET_Int32Time interval);

int tryParseTimeInterval (GladeXML * xml,
                          const char *intervalComboBoxEntry,
                          GNUNET_Int32Time * interval);

int parseTimeInterval (const char *frequency, GNUNET_Int32Time * interval);

char *getMimeTypeFromMetaData (const struct GNUNET_MetaData *meta);

char *getFileNameFromMetaData (const struct GNUNET_MetaData *meta);

char *getDescriptionFromMetaData (const struct GNUNET_MetaData *meta);

unsigned int getSpinButtonValue (GladeXML * xml, const char *spinButtonName);

int getToggleButtonValue (GladeXML * xml, const char *widgetName);

const char *getEntryLineValue (GladeXML * xml, const char *widgetName);

GdkPixbuf *getThumbnailFromMetaData (const struct GNUNET_MetaData *meta);

/* end of meta.h */
#endif
