# GNU Enterprise Forms - win32 UI Driver - ToolButton widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: toolbutton.py 9956 2009-10-11 18:54:57Z reinhard $

import array
import struct

import win32api
import win32con
import win32gui
import commctrl

from gnue.forms.uidrivers.win32.widgets._base import UIHelper
from gnue.forms.uidrivers.win32.common import getNextId, textEncode


# =============================================================================
# UIToolButton
# =============================================================================

class UIToolButton(UIHelper):
    """
    Implements a toolbar button object.
    """

    # -------------------------------------------------------------------------
    # Create a menu item widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new toolbar button widget.
        """
        
        # These are the relevant parameters
        icon_file = self._gfObject._get_icon_file(size="24x24", format="bmp")
        label = self._gfObject.label
        description = self._gfObject.description
        self.check = (self._gfObject.action_off is not None)

        if self.check:
            style = commctrl.TBSTYLE_CHECK
        else:
            style = commctrl.TBSTYLE_BUTTON
            
        self.parent = event.container
        self.id = getNextId()

        if event.container is not None:
            if label is not None:
                # Set the action icon if available
                if icon_file:
                    icon_flags = win32con.LR_LOADFROMFILE | win32con.LR_SHARED
                    try:
                        him = win32gui.LoadImage(0, str(icon_file), win32con.IMAGE_BITMAP, 24, 24, icon_flags)
                        win32gui.ImageList_Add(self.parent.himl, him, 0)
                    except:
                        gDebug(1, win32api.FormatMessage(0))

                self.parent.toolbar.Connect(self.id, self.__on_tool)

    #    TBBUTTON stru (iBitmap, idCommand, fsState, fsStyle, dwData, iString)
                tbb=struct.pack("iibbli", self.parent._buttonCount, self.id, commctrl.TBSTATE_ENABLED, style, 0, 0)
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_ADDBUTTONS, 1, tbb)
                # i have to count myself 'coz TB_BUTTONCOUNT counts separators too...
                self.parent._buttonCount += 1

    #    TOOLINFO stru (cbSize, uFlags, hwnd, uId, rect, hinst, lpszText, lParam)
                buff = array.array('c', '%s \0x00' % (textEncode(description) or ''))
                addrText = buff.buffer_info()[0]
                format = "IIiIllllili"
                size = struct.calcsize(format)
                ti = struct.pack(format, size, 0, self.parent.toolbar.GetHwnd(), self.id, 0, 0, 0, 0, 0, addrText, 0)
                win32gui.SendMessage(self.parent._htt, commctrl.TTM_UPDATETIPTEXT , 0, ti)

                widget = ToolButton(self.parent, self.id, self.check)

            else:
                widget = None
                tbb=struct.pack("iibbli", 0, 0, commctrl.TBSTATE_ENABLED, commctrl.TBSTYLE_SEP, 0, 0)
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_ADDBUTTONS, 1, tbb)

        else:
            # TOOLBAR:SUPPRESS was set
            widget = None

        self.__widget = widget

        return widget


    # -------------------------------------------------------------------------
    # Events
    # -------------------------------------------------------------------------

    def __on_tool(self, *args):
        self._gfObject._event_fire()

    # -------------------------------------------------------------------------
    # Check/uncheck menu item
    # -------------------------------------------------------------------------

    def _ui_switch_on_(self):
        if self.__widget is not None:
            if self.check:
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_CHECKBUTTON, self.id, 1)
            else:
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_PRESSBUTTON, self.id, 1)

    # -------------------------------------------------------------------------

    def _ui_switch_off_(self):
        if self.__widget is not None:
            if self.check:
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_CHECKBUTTON, self.id, 0)
            else:
                win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_PRESSBUTTON, self.id, 0)

    # -------------------------------------------------------------------------
    # Enable/disable menu item
    # -------------------------------------------------------------------------

    def _ui_enable_(self):
        if self.__widget is not None:
            win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_ENABLEBUTTON, self.id, 1)

    # -------------------------------------------------------------------------

    def _ui_disable_(self):
        if self.__widget is not None:
            win32gui.SendMessage(self.parent.toolbar.GetHwnd(), commctrl.TB_ENABLEBUTTON, self.id, 0)


class ToolButton:
    def __init__(self, parent, id, check):
        self.data = (parent, id, check)


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIToolButton,
  'provides' : 'GFToolButton',
  'container': False
}
