# GNU Enterprise Forms - GTK UI driver - Scrollbar Widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: scrollbar.py 9956 2009-10-11 18:54:57Z reinhard $

import gtk

from gnue.common import events
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

# =============================================================================
# This class implements a scrollbar for navigating multiple records
# =============================================================================

class UIScrollBar (UIHelper):

  # ---------------------------------------------------------------------------
  # Create the GTK widget
  # ---------------------------------------------------------------------------

  def _create_widget (self, event, spacer):
    gfObject = event.object

    self.adjustment = gtk.Adjustment (0, 0, 0, 0, 0, 0)

    newWidget = gtk.VScrollbar (self.adjustment)
    height    = gfObject.Char__height * event.widgetHeight
    newWidget.set_size_request (-1, height)

    self.adjustment._scrollHandler = self.adjustment.connect ('value-changed',
                                                self._scrollHandler)
    
    event.container.put (newWidget, self.itemX, self.itemY)
    newWidget.show ()

    return newWidget


  # ---------------------------------------------------------------------------
  # adjust the scrollbar to a new position
  # ---------------------------------------------------------------------------

  def _ui_adjust_scrollbar_(self, position, size, count):

    self._blockHandler (self.adjustment, '_scrollHandler')
    self.adjustment.set_all(position, 0, count - 1, 1, size - 1, size - 1)
    self._blockHandler (self.adjustment, '_scrollHandler', True)


  # ---------------------------------------------------------------------------
  # Handle changes of the adjustment's value
  # ---------------------------------------------------------------------------

  def _scrollHandler (self, adjustment):

    assert gDebug (6, "Adjust to %s" % int (adjustment.value))
    self._gfObject._event_scrollToRecord (int (adjustment.value))

    return True


# -----------------------------------------------------------------------------
# Configuration data
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UIScrollBar,
  'provides'   : 'GFScrollBar',
  'container'  : 0,
}
