# GNU Enterprise Forms - Curses UI Driver - Login Handler
#
# Copyright 2000-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: UILoginHandler.py 9956 2009-10-11 18:54:57Z reinhard $

import curses

from gnue.common.datasources import GLoginHandler
from gnue.forms.uidrivers.curses import dialogs

# =============================================================================
# This class implements a login handler for curses
# =============================================================================

class UILoginHandler (GLoginHandler.LoginHandler):

  # ---------------------------------------------------------------------------
  # Get input for all fields listed in loginData
  # ---------------------------------------------------------------------------

  def _askLogin_ (self, title, fields):

    dlg = dialogs.InputDialog (title, fields, self.uiDriver.attr)

    dlg.run ()
    return dlg.inputData
