# GNU Enterprise Forms - GF Object Hierarchy - Button
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFButton.py 10016 2009-10-28 14:41:59Z reinhard $
"""
Logical button support
"""

from GFTabStop import GFTabStop

# =============================================================================
# Class implementing a button
# =============================================================================

class GFButton(GFTabStop):

    _navigableInQuery_ = False          # Buttons don't get focus in query mode

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent=None):

        GFTabStop.__init__(self, parent, 'GFButton')

        self.label = ""
        self.action = None

        self._validTriggers = {
          'ON-ACTION'        : 'On-Action',
          'PRE-FOCUSOUT'     : 'Pre-FocusOut',
          'POST-FOCUSOUT'    : 'Post-FocusOut',
          'PRE-FOCUSIN'      : 'Pre-FocusIn',
          'POST-FOCUSIN'     : 'Post-FocusIn',
          'ON-NEXT-ENTRY'    : 'On-Next-Entry',
          'ON-PREVIOUS-ENTRY': 'On-Previous-Entry'}


    # -------------------------------------------------------------------------
    # Implementation of virtual methods
    # -------------------------------------------------------------------------

    def _phase_1_init_(self):

        GFTabStop._phase_1_init_(self)

        if self._block:
            self._block._entryList.append(self)

            grid = self.findParentOfType('GFGrid')
            if grid:
                self._rows = int(getattr(grid, 'rows', 1))
            else:
                self._rows = getattr(self._block, 'rows', self._rows)
                self._gap  = getattr(self._block, 'rowSpacer', self._gap)

        self._rows = getattr(self, 'rows', self._rows)
        self._gap  = getattr(self, 'rowSpacer', self._gap)


    # -------------------------------------------------------------------------
    # Fire the trigger associated with the button from outside GF
    # -------------------------------------------------------------------------

    def _event_fire(self):
        """
        Update the value of the current entry and execute the trigger
        associated with the button. Use this function to fire a button from the
        UI layer.
        """

        self._form.event_begin()

        try:
            # Fire the ON-ACTION trigger
            self.processTrigger('On-Action', False)

            # Fire the action
            if self.action is not None:
                self._form._actions[self.action].run()
        finally:
            self._form.event_end()
