# setup script for py2app to build the GNUe Forms Application bundle
from setuptools import setup
import py2app

app_name = 'GNU Enterprise Forms'
app_vers = '0.6.3'
short_vers = '0.6.3'

# Build the .app file
setup(
  options=dict(
     py2app=dict(
        iconfile='forms.icns',
        site_packages=True,
        argv_emulation=True,
        semi_standalone=True,
        excludes=['gnue'],
        dist_dir='build-env/pkg-root/Applications',
        bdist_base='build-pyapp',
        plist=dict(
          CFBundleName = app_name,
          CFBundleShortVersionString = short_vers, # must be in X.X.X format
          CFBundleGetInfoString = "%s %s" % (app_name, app_vers),
          CFBundleExecutable = app_name,
          CFBundleIdentifier = "com.gnuenterprise.forms",
          CFBundleDocumentTypes = [dict(
              CFBundleTypeExtensions = ["gfd"],
              CFBundleTypeName = "GNU Enterprise Form Definition",
              CFBundleTypeRole = "Viewer"),
              ],
          ),
        ),
      ),
      app=[ 'gnue-forms.py' ]
  )
